/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.snowflake.common.core.CalendarCache;
import net.snowflake.common.util.TimeUtil;

public abstract class SFInstant {
    public static final int DAY_OF_WEEK_ISO = 10001;
    public static final int WEEK_ISO = 10002;
    public static final int YEAR_OF_WEEK = 10003;
    public static final int YEAR_OF_WEEK_ISO = 10004;
    protected static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    protected static final int[] POWERS_OF_TEN = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    public abstract int extract(int var1, Integer var2, Integer var3);

    public int extract(int field) {
        return this.extract(field, null, null);
    }

    protected int extract(int field, TimeZone tz, long time, Integer optWeekStart, Integer optWoyPolicy) {
        int val;
        GregorianCalendar calendar = CalendarCache.get(tz);
        int[] firstDays = new int[]{2, 3, 4, 5, 6, 7, 1};
        calendar.setTimeInMillis(time);
        boolean isIso = false;
        boolean isJan1st = false;
        int weekStart = optWeekStart != null ? optWeekStart : 0;
        weekStart = weekStart == 0 ? 1 : weekStart;
        weekStart %= 7;
        if (field == 10001 || field == 10002 || field == 10004) {
            calendar.setFirstDayOfWeek(2);
            calendar.setMinimalDaysInFirstWeek(4);
            if (field == 10001) {
                field = 7;
            } else if (field == 10002) {
                field = 3;
            } else if (field == 10004) {
                field = 10003;
            }
            isIso = true;
        } else {
            int firstDay = 2;
            if (optWeekStart != null && optWeekStart != 0) {
                assert (optWeekStart >= 1 && optWeekStart <= 7);
                firstDay = firstDays[optWeekStart - 1];
            }
            int minimalDaysInFirstWeek = 4;
            if (optWoyPolicy != null && optWoyPolicy != 0) {
                assert (optWoyPolicy == 1);
                minimalDaysInFirstWeek = 1;
                isJan1st = true;
            }
            calendar.setFirstDayOfWeek(firstDay);
            calendar.setMinimalDaysInFirstWeek(minimalDaysInFirstWeek);
        }
        if (isJan1st && field == 10003) {
            val = TimeUtil.getYearAsInt(calendar);
        } else if (isJan1st && field == 3) {
            int week;
            long outputYear = TimeUtil.getYearAsInt(calendar);
            int yday = calendar.get(6);
            int wday = calendar.get(7);
            int dowJan1 = (--wday - --yday + 700) % 7;
            val = week = (yday + (7 - weekStart + dowJan1) % 7) / 7 + 1;
        } else if (field == 10003) {
            int year = TimeUtil.getYearAsInt(calendar);
            int week = calendar.get(3);
            int month = calendar.get(2);
            if (month == 0 && week > 10) {
                --year;
            } else if (month == 11 && week < 10) {
                ++year;
            }
            val = year;
        } else if (field == 1) {
            val = TimeUtil.getYearAsInt(calendar);
        } else {
            val = calendar.get(field);
            if (field == 2) {
                ++val;
            } else if (field == 7) {
                if (isIso) {
                    val = (val + 6 - 1) % 7 + 1;
                } else if (optWeekStart == null || optWeekStart == 0) {
                    --val;
                } else {
                    assert (optWeekStart >= 1 && optWeekStart <= 7);
                    val = (val + 7 + 6 - optWeekStart) % 7 + 1;
                }
            }
        }
        return val;
    }
}

