/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TimeZone;
import net.snowflake.common.core.SFDate;
import net.snowflake.common.core.SFTime;
import net.snowflake.common.core.SFTimestamp;
import net.snowflake.common.core.SqlFormat;
import net.snowflake.common.core.TmExt;
import net.snowflake.common.util.GSCommonLogUtil;
import net.snowflake.common.util.GenericGSCommonLogger;

public class SqlFormatScanner {
    static GenericGSCommonLogger LOGGER = GSCommonLogUtil.getLogger(MethodHandles.lookup().lookupClass());
    private ArrayList<SqlFormat> m_formats = new ArrayList();
    private static final ArrayList<SqlFormat> s_numFormats;
    private static final ArrayList<SqlFormat> s_timeFormats;
    private static final ArrayList<SqlFormat> s_dateFormats;
    private static final ArrayList<SqlFormat> s_tsFormats;

    public void addFormat(SqlFormat fmt) {
        this.m_formats.add(fmt);
    }

    public String setFormats(int model, String str) {
        if (str.length() == 0) {
            return "empty input format";
        }
        boolean gotAuto = false;
        String s = str;
        block13: do {
            if (s.startsWith("auto") || s.startsWith("AUTO")) {
                if (s.length() == 4) {
                    s = "";
                } else {
                    if (s.charAt(4) != '|') {
                        return "unknown format element: '" + s + "'";
                    }
                    if ((s = s.substring(5)).length() == 0) {
                        return "no format elements after |";
                    }
                }
                if (gotAuto) {
                    return "duplicate AUTO in format list";
                }
                gotAuto = true;
                switch (model) {
                    default: {
                        assert (false);
                    }
                    case 1: {
                        for (SqlFormat f : s_numFormats) {
                            this.m_formats.add(f);
                        }
                        continue block13;
                    }
                    case 4: {
                        for (SqlFormat f : s_timeFormats) {
                            this.m_formats.add(f);
                        }
                        continue block13;
                    }
                    case -1: {
                        for (SqlFormat f : s_numFormats) {
                            this.m_formats.add(f);
                        }
                        for (SqlFormat f : s_timeFormats) {
                            this.m_formats.add(f);
                        }
                    }
                    case 6: 
                    case 14: {
                        for (SqlFormat f : s_tsFormats) {
                            this.m_formats.add(f);
                        }
                    }
                    case 2: {
                        for (SqlFormat f : s_dateFormats) {
                            this.m_formats.add(f);
                        }
                        continue block13;
                    }
                }
            }
            SqlFormat f = new SqlFormat();
            if ((s = f.setFormat(model, s)) == null) {
                return f.getErrorMsg();
            }
            if (!f.checkScanModel(model)) {
                switch (model) {
                    case 1: {
                        s = "numbers";
                        break;
                    }
                    case 2: {
                        s = "dates";
                        break;
                    }
                    case 4: {
                        s = "time";
                        break;
                    }
                    case 6: 
                    case 14: {
                        s = "timestamps";
                    }
                }
                return "missing or conflicting format elements required for parsing " + s;
            }
            this.m_formats.add(f);
        } while (s.length() > 0);
        return null;
    }

    public SFDate parseDate(String str, int cenBound) {
        SqlFormat f;
        TmExt tm = null;
        Iterator<SqlFormat> iterator = this.m_formats.iterator();
        while (iterator.hasNext() && (tm = (f = iterator.next()).parseTm(str, cenBound)) == null) {
        }
        if (tm == null) {
            return null;
        }
        return tm.getDate();
    }

    public SFDate parseDate(String str) {
        return this.parseDate(str, 1970);
    }

    public SFTime parseTime(String str) {
        SqlFormat f;
        TmExt tm = null;
        Iterator<SqlFormat> iterator = this.m_formats.iterator();
        while (iterator.hasNext() && (tm = (f = iterator.next()).parseTm(str, 2000)) == null) {
        }
        if (tm == null) {
            return null;
        }
        return tm.getTime();
    }

    public SFTimestamp parseTimestamp(String str, TimeZone tz, int cenBound) {
        SqlFormat f;
        TmExt tm = null;
        Iterator<SqlFormat> iterator = this.m_formats.iterator();
        while (iterator.hasNext() && (tm = (f = iterator.next()).parseTm(str, cenBound)) == null) {
        }
        if (tm == null) {
            return null;
        }
        return tm.getTimestamp(tz);
    }

    public SFTimestamp parseTimestamp(String str, TimeZone tz) {
        return this.parseTimestamp(str, tz, 1970);
    }

    static {
        String[] autoNum = new String[]{"TM9", "TME"};
        s_numFormats = new ArrayList();
        for (String s : autoNum) {
            SqlFormat f = new SqlFormat();
            String res = f.setFormat(1, s);
            assert (res != null && res.equals(""));
            assert (f.checkScanModel(1));
            s_numFormats.add(f);
        }
        String[] autoTime = new String[]{"HH24:MI", "HH24:MI:SS", "HH24:MI:SS.FF", "HH12:MI_AM", "HH12:MI:SS_AM", "HH12:MI:SS.FF_AM"};
        s_timeFormats = new ArrayList();
        for (String s : autoTime) {
            SqlFormat f = new SqlFormat();
            String res = f.setFormat(4, s);
            assert (res != null && res.equals(""));
            assert (f.checkScanModel(4));
            s_timeFormats.add(f);
        }
        String[] autoDate = new String[]{"YYYY-MM-DD", "YYYY-MON-DD", "DD-MON-YYYY", "MM/DD/YYYY"};
        s_dateFormats = new ArrayList();
        for (String s : autoDate) {
            SqlFormat f = new SqlFormat();
            String res = f.setFormat(2, s);
            assert (res != null && res.equals(""));
            assert (f.checkScanModel(2));
            s_dateFormats.add(f);
        }
        String[] autoTs = new String[]{"YYYY-MM-DD\"T\"HH24:MI", "YYYY-MM-DD\"T\"HH24:MI:SS", "YYYY-MM-DD\"T\"HH24:MI:SS.FF", "YYYY-MM-DD\"T\"HH24:MITZISO", "YYYY-MM-DD\"T\"HH24:MI:SSTZISO", "YYYY-MM-DD\"T\"HH24:MI:SS.FFTZISO", "YYYY-MM-DD HH24:MI", "YYYY-MM-DD HH24:MI:SS", "YYYY-MM-DD HH24:MI:SS.FF", "YYYY-MM-DD HH24:MI_TZH:TZM", "YYYY-MM-DD HH24:MI:SS_TZH:TZM", "YYYY-MM-DD HH24:MI:SS.FF_TZH:TZM", "YYYY-MM-DD HH24:MI_TZISO", "YYYY-MM-DD HH24:MI:SS_TZISO", "YYYY-MM-DD HH24:MI:SS.FF_TZISO", "Dy, DD Mon YYYY HH24:MI:SS", "Dy, DD Mon YYYY HH24:MI:SS.FF", "Dy, DD Mon YYYY HH12:MI:SS_AM", "Dy, DD Mon YYYY HH12:MI:SS.FF_AM", "Dy, DD Mon YYYY HH24:MI:SS TZHTZM", "Dy, DD Mon YYYY HH24:MI:SS.FF TZHTZM", "Dy, DD Mon YYYY HH12:MI:SS_AM TZHTZM", "Dy, DD Mon YYYY HH12:MI:SS.FF_AM TZHTZM", "MM/DD/YYYY HH24:MI:SS", "MM/DD/YYYY HH24:MI:SS.FF", "Dy Mon DD HH24:MI:SS TZHTZM YYYY"};
        s_tsFormats = new ArrayList();
        for (String s : autoTs) {
            SqlFormat f = new SqlFormat();
            String res = f.setFormat(14, s);
            assert (res != null && res.equals(""));
            assert (f.checkScanModel(14));
            s_tsFormats.add(f);
        }
    }
}

