/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.google.common.base.Strings;
import net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.telemetryOOB.TelemetryService;

public class ExecTimeTelemetryData {
    private long queryStart;
    private long bindStart;
    private long bindEnd;
    private long gzipStart;
    private long gzipEnd;
    private long httpClientStart;
    private long httpClientEnd;
    private long responseIOStreamStart;
    private long responseIOStreamEnd;
    private long processResultChunkStart;
    private long processResultChunkEnd;
    private long createResultSetStart;
    private long createResultSetEnd;
    private long queryEnd;
    private String batchId;
    private String queryId;
    private String queryFunction;
    private int retryCount = 0;
    private String retryLocations = "";
    private Boolean ocspEnabled = false;
    boolean sendData = true;
    private String requestId;

    public ExecTimeTelemetryData(String queryFunction, String batchId) {
        if (TelemetryService.getInstance().isHTAPEnabled()) {
            this.queryStart = SnowflakeUtil.getEpochTimeInMicroSeconds();
            this.queryFunction = queryFunction;
            this.batchId = batchId;
        } else {
            this.sendData = false;
        }
    }

    public ExecTimeTelemetryData() {
        this.sendData = false;
    }

    public void setBindStart() {
        if (!this.sendData) {
            return;
        }
        this.bindStart = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setOCSPStatus(Boolean ocspEnabled) {
        if (!this.sendData) {
            return;
        }
        this.ocspEnabled = ocspEnabled;
    }

    public void setBindEnd() {
        if (!this.sendData) {
            return;
        }
        this.bindEnd = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setHttpClientStart() {
        if (!this.sendData) {
            return;
        }
        this.httpClientStart = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setHttpClientEnd() {
        if (!this.sendData) {
            return;
        }
        this.httpClientEnd = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setGzipStart() {
        if (!this.sendData) {
            return;
        }
        this.gzipStart = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setGzipEnd() {
        if (!this.sendData) {
            return;
        }
        this.gzipEnd = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setQueryEnd() {
        if (!this.sendData) {
            return;
        }
        this.queryEnd = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setQueryId(String queryId) {
        if (!this.sendData) {
            return;
        }
        this.queryId = queryId;
    }

    public void setProcessResultChunkStart() {
        if (!this.sendData) {
            return;
        }
        this.processResultChunkStart = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setProcessResultChunkEnd() {
        if (!this.sendData) {
            return;
        }
        this.processResultChunkEnd = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setResponseIOStreamStart() {
        if (!this.sendData) {
            return;
        }
        this.responseIOStreamStart = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setResponseIOStreamEnd() {
        if (!this.sendData) {
            return;
        }
        this.responseIOStreamEnd = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setCreateResultSetStart() {
        if (!this.sendData) {
            return;
        }
        this.createResultSetStart = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void setCreateResultSetEnd() {
        if (!this.sendData) {
            return;
        }
        this.createResultSetEnd = SnowflakeUtil.getEpochTimeInMicroSeconds();
    }

    public void incrementRetryCount() {
        if (!this.sendData) {
            return;
        }
        ++this.retryCount;
    }

    public void setRequestId(String requestId) {
        if (!this.sendData) {
            return;
        }
        this.requestId = requestId;
    }

    public void addRetryLocation(String location) {
        if (!this.sendData) {
            return;
        }
        this.retryLocations = Strings.isNullOrEmpty((String)this.retryLocations) ? location : this.retryLocations.concat(", ").concat(location);
    }

    public String generateTelemetry() {
        if (this.sendData) {
            String eventType = "ExecutionTimeRecord";
            JSONObject value = new JSONObject();
            value.put((Object)"eventType", (Object)eventType);
            value.put((Object)"QueryStart", (Object)this.queryStart);
            value.put((Object)"BindStart", (Object)this.bindStart);
            value.put((Object)"BindEnd", (Object)this.bindEnd);
            value.put((Object)"GzipStart", (Object)this.gzipStart);
            value.put((Object)"GzipEnd", (Object)this.gzipEnd);
            value.put((Object)"HttpClientStart", (Object)this.httpClientStart);
            value.put((Object)"HttpClientEnd", (Object)this.httpClientEnd);
            value.put((Object)"ResponseIOStreamStart", (Object)this.responseIOStreamStart);
            value.put((Object)"ResponseIOStreamEnd", (Object)this.responseIOStreamEnd);
            value.put((Object)"ProcessResultChunkStart", (Object)this.processResultChunkStart);
            value.put((Object)"ProcessResultChunkEnd", (Object)this.processResultChunkEnd);
            value.put((Object)"CreateResultSetStart", (Object)this.createResultSetStart);
            value.put((Object)"CreatResultSetEnd", (Object)this.createResultSetEnd);
            value.put((Object)"QueryEnd", (Object)this.queryEnd);
            value.put((Object)"BatchID", (Object)this.batchId);
            value.put((Object)"QueryID", (Object)this.queryId);
            value.put((Object)"RequestID", (Object)this.requestId);
            value.put((Object)"QueryFunction", (Object)this.queryFunction);
            value.put((Object)"RetryCount", (Object)this.retryCount);
            value.put((Object)"RetryLocations", (Object)this.retryLocations);
            value.put((Object)"ocspEnabled", (Object)this.ocspEnabled);
            value.put((Object)"ElapsedQueryTime", (Object)(this.queryEnd - this.queryStart));
            value.put((Object)"ElapsedResultProcessTime", (Object)(this.createResultSetEnd - this.processResultChunkStart));
            value.put((Object)"Urgent", (Object)true);
            String valueStr = value.toString();
            TelemetryService.getInstance().logExecutionTimeTelemetryEvent(value, eventType);
            return valueStr;
        }
        return "";
    }
}

