/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.microsoft.azure.storage.OperationContext;
import com.snowflake.client.jdbc.SnowflakeDriver;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManager;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFSSLConnectionSocketFactory;
import net.snowflake.client.core.SFSessionProperty;
import net.snowflake.client.core.SFTrustManager;
import net.snowflake.client.core.SnowflakeMutableProxyRoutePlanner;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SecretDetector;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLInitializationException;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    static final SFLogger logger = SFLoggerFactory.getLogger(HttpUtil.class);
    static final int DEFAULT_MAX_CONNECTIONS = 300;
    static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 300;
    static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300000;
    static final int DEFAULT_TTL = 60;
    static final int DEFAULT_IDLE_CONNECTION_TIMEOUT = 5;
    static final int DEFAULT_DOWNLOADED_CONDITION_TIMEOUT = 3600;
    public static final String JDBC_TTL = "net.snowflake.jdbc.ttl";
    public static final String JDBC_MAX_CONNECTIONS_PROPERTY = "net.snowflake.jdbc.max_connections";
    public static final String JDBC_MAX_CONNECTIONS_PER_ROUTE_PROPERTY = "net.snowflake.jdbc.max_connections_per_route";
    public static Map<HttpClientSettingsKey, CloseableHttpClient> httpClient = new ConcurrentHashMap<HttpClientSettingsKey, CloseableHttpClient>();
    private static Map<HttpClientSettingsKey, CloseableHttpClient> httpClientWithoutDecompression = new ConcurrentHashMap<HttpClientSettingsKey, CloseableHttpClient>();
    static Map<HttpClientSettingsKey, SnowflakeMutableProxyRoutePlanner> httpClientRoutePlanner = new ConcurrentHashMap<HttpClientSettingsKey, SnowflakeMutableProxyRoutePlanner>();
    private static PoolingHttpClientConnectionManager connectionManager = null;
    private static RequestConfig DefaultRequestConfig = null;
    private static boolean socksProxyDisabled = false;

    public static long getDownloadedConditionTimeoutInSeconds() {
        return 3600L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeExpiredAndIdleConnections() {
        if (connectionManager != null) {
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = connectionManager;
            synchronized (poolingHttpClientConnectionManager) {
                logger.debug("connection pool stats: {}", connectionManager.getTotalStats());
                connectionManager.closeExpiredConnections();
                connectionManager.closeIdleConnections(5L, TimeUnit.SECONDS);
            }
        }
    }

    public static void setProxyForS3(HttpClientSettingsKey key, ClientConfiguration clientConfig) {
        if (key != null && key.usesProxy()) {
            clientConfig.setProxyProtocol(key.getProxyProtocol());
            clientConfig.setProxyHost(key.getProxyHost());
            clientConfig.setProxyPort(key.getProxyPort());
            clientConfig.setNonProxyHosts(key.getNonProxyHosts());
            if (!Strings.isNullOrEmpty((String)key.getProxyUser()) && !Strings.isNullOrEmpty((String)key.getProxyPassword())) {
                clientConfig.setProxyUsername(key.getProxyUser());
                clientConfig.setProxyPassword(key.getProxyPassword());
            }
        }
    }

    public static void setSessionlessProxyForS3(Properties proxyProperties, ClientConfiguration clientConfig) throws SnowflakeSQLException {
        Boolean useProxy;
        if (proxyProperties != null && proxyProperties.size() > 0 && proxyProperties.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()) != null && (useProxy = Boolean.valueOf(proxyProperties.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()))).booleanValue()) {
            int proxyPort;
            String proxyHost = proxyProperties.getProperty(SFSessionProperty.PROXY_HOST.getPropertyKey());
            try {
                proxyPort = Integer.parseInt(proxyProperties.getProperty(SFSessionProperty.PROXY_PORT.getPropertyKey()));
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new SnowflakeSQLException(ErrorCode.INVALID_PROXY_PROPERTIES, "Could not parse port number");
            }
            String proxyUser = proxyProperties.getProperty(SFSessionProperty.PROXY_USER.getPropertyKey());
            String proxyPassword = proxyProperties.getProperty(SFSessionProperty.PROXY_PASSWORD.getPropertyKey());
            String nonProxyHosts = proxyProperties.getProperty(SFSessionProperty.NON_PROXY_HOSTS.getPropertyKey());
            String proxyProtocol = proxyProperties.getProperty(SFSessionProperty.PROXY_PROTOCOL.getPropertyKey());
            Protocol protocolEnum = !Strings.isNullOrEmpty((String)proxyProtocol) && proxyProtocol.equalsIgnoreCase("https") ? Protocol.HTTPS : Protocol.HTTP;
            clientConfig.setProxyHost(proxyHost);
            clientConfig.setProxyPort(proxyPort);
            clientConfig.setNonProxyHosts(nonProxyHosts);
            clientConfig.setProxyProtocol(protocolEnum);
            if (!Strings.isNullOrEmpty((String)proxyUser) && !Strings.isNullOrEmpty((String)proxyPassword)) {
                clientConfig.setProxyUsername(proxyUser);
                clientConfig.setProxyPassword(proxyPassword);
            }
        }
    }

    public static void setSessionlessProxyForAzure(Properties proxyProperties, OperationContext opContext) throws SnowflakeSQLException {
        Boolean useProxy;
        if (proxyProperties != null && proxyProperties.size() > 0 && proxyProperties.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()) != null && (useProxy = Boolean.valueOf(proxyProperties.getProperty(SFSessionProperty.USE_PROXY.getPropertyKey()))).booleanValue()) {
            int proxyPort;
            String proxyHost = proxyProperties.getProperty(SFSessionProperty.PROXY_HOST.getPropertyKey());
            try {
                proxyPort = Integer.parseInt(proxyProperties.getProperty(SFSessionProperty.PROXY_PORT.getPropertyKey()));
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new SnowflakeSQLException(ErrorCode.INVALID_PROXY_PROPERTIES, "Could not parse port number");
            }
            Proxy azProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
            opContext.setProxy(azProxy);
        }
    }

    public static void setProxyForAzure(HttpClientSettingsKey key, OperationContext opContext) {
        if (key != null && key.usesProxy()) {
            Proxy azProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(key.getProxyHost(), key.getProxyPort()));
            opContext.setProxy(azProxy);
        }
    }

    @VisibleForTesting
    static String buildUserAgent(String customSuffix) {
        StringBuilder builder = new StringBuilder("JDBC/");
        builder.append(SnowflakeDriver.implementVersion);
        builder.append(" (");
        String osPlatform = SnowflakeUtil.systemGetProperty("os.name") != null ? SnowflakeUtil.systemGetProperty("os.name") : "";
        String osVersion = SnowflakeUtil.systemGetProperty("os.version") != null ? SnowflakeUtil.systemGetProperty("os.version") : "";
        builder.append(osPlatform);
        builder.append(" ");
        builder.append(osVersion);
        builder.append(") JAVA/");
        String languageVersion = SnowflakeUtil.systemGetProperty("java.version") != null ? SnowflakeUtil.systemGetProperty("java.version") : "";
        builder.append(languageVersion);
        if (!customSuffix.isEmpty()) {
            builder.append(" " + customSuffix);
        }
        String userAgent = builder.toString();
        return userAgent;
    }

    public static CloseableHttpClient buildHttpClient(@Nullable HttpClientSettingsKey key, File ocspCacheFile, boolean downloadUnCompressed) {
        boolean noDefaultRequestConfig;
        int timeToLive = HttpUtil.convertSystemPropertyToIntValue(JDBC_TTL, 60);
        logger.debug("time to live in connection pooling manager: {}", timeToLive);
        HttpHost proxy = key != null && key.usesProxy() ? new HttpHost(key.getProxyHost(), key.getProxyPort(), key.getProxyProtocol().toString()) : null;
        boolean bl = noDefaultRequestConfig = DefaultRequestConfig == null || DefaultRequestConfig.getProxy() == null;
        if (noDefaultRequestConfig || !DefaultRequestConfig.getProxy().equals((Object)proxy)) {
            RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(300000);
            if (proxy != null && Strings.isNullOrEmpty((String)key.getNonProxyHosts())) {
                builder.setProxy(proxy);
            }
            DefaultRequestConfig = builder.build();
        }
        TrustManager[] trustManagers = null;
        if (key != null && key.getOcspMode() != OCSPMode.INSECURE) {
            try {
                TrustManager[] tm;
                trustManagers = tm = new TrustManager[]{new SFTrustManager(key, ocspCacheFile)};
            }
            catch (Error | Exception err) {
                StringWriter errors = new StringWriter();
                err.printStackTrace(new PrintWriter(errors));
                logger.error(errors.toString(), true);
                throw new RuntimeException(err);
            }
        }
        try {
            Registry registry = RegistryBuilder.create().register("https", (Object)new SFSSLConnectionSocketFactory(trustManagers, socksProxyDisabled)).register("http", (Object)new SFConnectionSocketFactory()).build();
            connectionManager = new PoolingHttpClientConnectionManager(registry, null, null, null, (long)timeToLive, TimeUnit.SECONDS);
            int maxConnections = HttpUtil.convertSystemPropertyToIntValue(JDBC_MAX_CONNECTIONS_PROPERTY, 300);
            int maxConnectionsPerRoute = HttpUtil.convertSystemPropertyToIntValue(JDBC_MAX_CONNECTIONS_PER_ROUTE_PROPERTY, 300);
            logger.debug("Max connections total in connection pooling manager: {}; max connections per route: {}", maxConnections, maxConnectionsPerRoute);
            connectionManager.setMaxTotal(maxConnections);
            connectionManager.setDefaultMaxPerRoute(maxConnectionsPerRoute);
            String userAgentSuffix = key != null ? key.getUserAgentSuffix() : "";
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManager).useSystemProperties().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).setUserAgent(HttpUtil.buildUserAgent(userAgentSuffix)).disableCookieManagement();
            if (key != null && key.usesProxy()) {
                SnowflakeMutableProxyRoutePlanner sdkProxyRoutePlanner = httpClientRoutePlanner.computeIfAbsent(key, k -> new SnowflakeMutableProxyRoutePlanner(key.getProxyHost(), key.getProxyPort(), key.getProxyProtocol(), key.getNonProxyHosts()));
                httpClientBuilder = httpClientBuilder.setProxy(proxy).setRoutePlanner((HttpRoutePlanner)sdkProxyRoutePlanner);
                if (!Strings.isNullOrEmpty((String)key.getProxyUser()) && !Strings.isNullOrEmpty((String)key.getProxyPassword())) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(key.getProxyUser(), key.getProxyPassword());
                    AuthScope authScope = new AuthScope(key.getProxyHost(), key.getProxyPort());
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(authScope, (Credentials)credentials);
                    httpClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
            }
            httpClientBuilder.setDefaultRequestConfig(DefaultRequestConfig);
            if (downloadUnCompressed) {
                httpClientBuilder = httpClientBuilder.disableContentCompression();
            }
            return httpClientBuilder.build();
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new SSLInitializationException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static void updateRoutePlanner(HttpClientSettingsKey key) {
        if (httpClientRoutePlanner.containsKey(key) && !httpClientRoutePlanner.get(key).getNonProxyHosts().equalsIgnoreCase(key.getNonProxyHosts())) {
            httpClientRoutePlanner.get(key).setNonProxyHosts(key.getNonProxyHosts());
        }
    }

    public static CloseableHttpClient getHttpClient(HttpClientSettingsKey ocspAndProxyKey) {
        return HttpUtil.initHttpClient(ocspAndProxyKey, null);
    }

    public static CloseableHttpClient getHttpClientWithoutDecompression(HttpClientSettingsKey ocspAndProxyKey) {
        return HttpUtil.initHttpClientWithoutDecompression(ocspAndProxyKey, null);
    }

    public static CloseableHttpClient initHttpClientWithoutDecompression(HttpClientSettingsKey key, File ocspCacheFile) {
        HttpUtil.updateRoutePlanner(key);
        return httpClientWithoutDecompression.computeIfAbsent(key, k -> HttpUtil.buildHttpClient(key, ocspCacheFile, true));
    }

    public static CloseableHttpClient initHttpClient(HttpClientSettingsKey key, File ocspCacheFile) {
        HttpUtil.updateRoutePlanner(key);
        return httpClient.computeIfAbsent(key, k -> HttpUtil.buildHttpClient(key, ocspCacheFile, key.getGzipDisabled()));
    }

    public static RequestConfig getDefaultRequestConfigWithSocketTimeout(int soTimeoutMs, boolean withoutCookies) {
        String cookieSpec = withoutCookies ? "ignoreCookies" : "default";
        return RequestConfig.copy((RequestConfig)DefaultRequestConfig).setSocketTimeout(soTimeoutMs).setCookieSpec(cookieSpec).build();
    }

    public static RequestConfig getDefaultRequestConfigWithSocketAndConnectTimeout(int requestSocketAndConnectTimeout, boolean withoutCookies) {
        String cookieSpec = withoutCookies ? "ignoreCookies" : "default";
        return RequestConfig.copy((RequestConfig)DefaultRequestConfig).setSocketTimeout(requestSocketAndConnectTimeout).setConnectTimeout(requestSocketAndConnectTimeout).setCookieSpec(cookieSpec).build();
    }

    public static RequestConfig getRequestConfigWithoutCookies() {
        return RequestConfig.copy((RequestConfig)DefaultRequestConfig).setCookieSpec("ignoreCookies").build();
    }

    public static void setRequestConfig(RequestConfig requestConfig) {
        DefaultRequestConfig = requestConfig;
    }

    private static String getHttpClientStats() {
        return connectionManager == null ? "" : connectionManager.getTotalStats().toString();
    }

    public static void setSocksProxyDisabled(boolean socksProxyDisabled) {
        HttpUtil.socksProxyDisabled = socksProxyDisabled;
    }

    public static boolean isSocksProxyDisabled() {
        return socksProxyDisabled;
    }

    static String executeRequestWithoutCookies(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, int injectSocketTimeout, AtomicBoolean canceling, HttpClientSettingsKey ocspAndProxyKey) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, injectSocketTimeout, canceling, true, false, true, false, HttpUtil.getHttpClient(ocspAndProxyKey), new ExecTimeTelemetryData());
    }

    public static String executeGeneralRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, HttpClientSettingsKey ocspAndProxyAndGzipKey) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequest(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, 0, null, false, false, ocspAndProxyAndGzipKey, new ExecTimeTelemetryData());
    }

    public static String executeGeneralRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int retryCount, CloseableHttpClient httpClient) throws SnowflakeSQLException, IOException {
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, authTimeout, socketTimeout, retryCount, 0, null, false, false, true, false, httpClient, new ExecTimeTelemetryData());
    }

    public static String executeRequest(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean includeRetryParameters, boolean retryOnHTTP403, HttpClientSettingsKey ocspAndProxyKey, ExecTimeTelemetryData execTimeData) throws SnowflakeSQLException, IOException {
        boolean ocspEnabled = !ocspAndProxyKey.getOcspMode().equals((Object)OCSPMode.INSECURE);
        execTimeData.setOCSPStatus(ocspEnabled);
        return HttpUtil.executeRequestInternal(httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, false, includeRetryParameters, true, retryOnHTTP403, HttpUtil.getHttpClient(ocspAndProxyKey), execTimeData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeRequestInternal(HttpRequestBase httpRequest, int retryTimeout, int authTimeout, int socketTimeout, int maxRetries, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, boolean retryOnHTTP403, CloseableHttpClient httpClient, ExecTimeTelemetryData execTimeData) throws SnowflakeSQLException, IOException {
        String theString;
        String requestInfoScrubbed = SecretDetector.maskSASToken(httpRequest.toString());
        logger.debug("Pool: {} Executing: {}", HttpUtil::getHttpClientStats, requestInfoScrubbed);
        StringWriter writer = null;
        CloseableHttpResponse response = null;
        try {
            response = RestRequest.execute(httpClient, httpRequest, retryTimeout, authTimeout, socketTimeout, maxRetries, injectSocketTimeout, canceling, withoutCookies, includeRetryParameters, includeRequestGuid, retryOnHTTP403, execTimeData);
            if (response == null || response.getStatusLine().getStatusCode() != 200) {
                logger.error("Error executing request: {}", requestInfoScrubbed);
                SnowflakeUtil.logResponseDetails((HttpResponse)response, logger);
                if (response != null) {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                throw new SnowflakeSQLException("58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "HTTP status=" + (response != null ? Integer.valueOf(response.getStatusLine().getStatusCode()) : "null response"));
            }
            execTimeData.setResponseIOStreamStart();
            writer = new StringWriter();
            try (InputStream ins = response.getEntity().getContent();){
                IOUtils.copy((InputStream)ins, (Writer)writer, (String)"UTF-8");
            }
            theString = writer.toString();
            execTimeData.setResponseIOStreamEnd();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            IOUtils.closeQuietly(response);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
        IOUtils.closeQuietly((Closeable)response);
        logger.debug("Pool: {} Request returned for: {}", HttpUtil::getHttpClientStats, requestInfoScrubbed);
        return theString;
    }

    static int convertSystemPropertyToIntValue(String systemProperty, int defaultValue) {
        String systemPropertyValue = SnowflakeUtil.systemGetProperty(systemProperty);
        int returnVal = defaultValue;
        if (systemPropertyValue != null) {
            try {
                returnVal = Integer.parseInt(systemPropertyValue);
            }
            catch (NumberFormatException ex) {
                logger.info("Failed to parse the system parameter {} with value {}", systemProperty, systemPropertyValue);
            }
        }
        return returnVal;
    }

    static void applyAdditionalHeadersForSnowsight(HttpRequestBase request, Map<String, String> additionalHeaders) {
        if (additionalHeaders != null && !additionalHeaders.isEmpty()) {
            additionalHeaders.forEach((arg_0, arg_1) -> ((HttpRequestBase)request).addHeader(arg_0, arg_1));
        }
    }

    static final class SFConnectionSocketFactory
    extends PlainConnectionSocketFactory {
        SFConnectionSocketFactory() {
        }

        public Socket createSocket(HttpContext ctx) throws IOException {
            if (socksProxyDisabled) {
                return new Socket(Proxy.NO_PROXY);
            }
            return super.createSocket(ctx);
        }
    }

    public static final class HttpInputStream
    extends InputStream {
        private final InputStream httpIn;

        public HttpInputStream(InputStream httpIn) {
            this.httpIn = httpIn;
        }

        @Override
        public final int available() throws IOException {
            int available = this.httpIn.available();
            return available == 0 ? 1 : available;
        }

        @Override
        public final int read() throws IOException {
            return this.httpIn.read();
        }

        @Override
        public final int read(byte[] b) throws IOException {
            return this.httpIn.read(b);
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            return this.httpIn.read(b, off, len);
        }

        @Override
        public final long skip(long n) throws IOException {
            return this.httpIn.skip(n);
        }

        @Override
        public final void close() throws IOException {
            this.httpIn.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.httpIn.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.httpIn.reset();
        }

        @Override
        public final boolean markSupported() {
            return this.httpIn.markSupported();
        }
    }
}

