/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.ParameterBindingDTO;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFPreparedStatementMetaData;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public abstract class SFBaseStatement {
    protected static final int MAX_STATEMENT_PARAMETERS = 1000;
    static final SFLogger logger = SFLoggerFactory.getLogger(SFBaseStatement.class);
    protected final Map<String, Object> statementParametersMap = new HashMap<String, Object>();
    protected int queryTimeout = 0;

    public void addProperty(String propertyName, Object propertyValue) throws SFException {
        this.statementParametersMap.put(propertyName, propertyValue);
        if ("query_timeout".equalsIgnoreCase(propertyName)) {
            this.queryTimeout = (Integer)propertyValue;
        }
        if (this.statementParametersMap.size() > 1000) {
            throw new SFException(ErrorCode.TOO_MANY_STATEMENT_PARAMETERS, 1000);
        }
    }

    public Map<String, Object> getStatementParameters() {
        return this.statementParametersMap;
    }

    public abstract SFPreparedStatementMetaData describe(String var1) throws SFException, SQLException;

    public abstract SFBaseResultSet execute(String var1, Map<String, ParameterBindingDTO> var2, CallingMethod var3, ExecTimeTelemetryData var4) throws SQLException, SFException;

    public abstract SFBaseResultSet asyncExecute(String var1, Map<String, ParameterBindingDTO> var2, CallingMethod var3, ExecTimeTelemetryData var4) throws SQLException, SFException;

    public abstract void close();

    public abstract void cancel() throws SFException, SQLException;

    public void executeSetProperty(String sql) {
        logger.debug("setting property", false);
        String[] tokens = sql.split("\\s+");
        if (tokens.length < 2) {
            return;
        }
        if ("sort".equalsIgnoreCase(tokens[1])) {
            if (tokens.length >= 3 && "on".equalsIgnoreCase(tokens[2])) {
                logger.debug("setting sort on", false);
                this.getSFBaseSession().setSessionPropertyByKey("sort", true);
            } else {
                logger.debug("setting sort off", false);
                this.getSFBaseSession().setSessionPropertyByKey("sort", false);
            }
        }
    }

    public static boolean isFileTransfer(String sql) {
        SFStatementType statementType = StmtUtil.checkStageManageCommand(sql);
        return statementType == SFStatementType.PUT || statementType == SFStatementType.GET;
    }

    public abstract boolean hasChildren();

    public abstract SFBaseSession getSFBaseSession();

    public abstract SFBaseResultSet getResultSet();

    public abstract boolean getMoreResults(int var1) throws SQLException;

    public abstract long getConservativeMemoryLimit();

    public abstract int getConservativePrefetchThreads();

    public abstract String[] getChildQueryIds(String var1) throws SQLException;

    public static enum CallingMethod {
        EXECUTE,
        EXECUTE_UPDATE,
        EXECUTE_QUERY;

    }
}

