/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.snowflake.client.core.FileCacheManager;
import net.snowflake.client.core.SecureStorageManager;
import net.snowflake.client.core.StmtUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class SecureStorageLinuxManager
implements SecureStorageManager {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SecureStorageLinuxManager.class);
    private static final String CACHE_FILE_NAME = "temporary_credential.json";
    private static final String CACHE_DIR_PROP = "net.snowflake.jdbc.temporaryCredentialCacheDir";
    private static final String CACHE_DIR_ENV = "SF_TEMPORARY_CREDENTIAL_CACHE_DIR";
    private static final long CACHE_EXPIRATION_IN_SECONDS = 86400L;
    private static final long CACHE_FILE_LOCK_EXPIRATION_IN_SECONDS = 60L;
    private FileCacheManager fileCacheManager;
    private final Map<String, Map<String, String>> localCredCache = new HashMap<String, Map<String, String>>();

    private SecureStorageLinuxManager() {
        this.fileCacheManager = FileCacheManager.builder().setCacheDirectorySystemProperty(CACHE_DIR_PROP).setCacheDirectoryEnvironmentVariable(CACHE_DIR_ENV).setBaseCacheFileName(CACHE_FILE_NAME).setCacheExpirationInSeconds(86400L).setCacheFileLockExpirationInSeconds(60L).build();
    }

    public static SecureStorageLinuxManager getInstance() {
        return SecureStorageLinuxManagerHolder.INSTANCE;
    }

    private ObjectNode localCacheToJson() {
        ObjectNode res = StmtUtil.mapper.createObjectNode();
        for (Map.Entry<String, Map<String, String>> elem : this.localCredCache.entrySet()) {
            String elemHost = elem.getKey();
            Map<String, String> hostMap = elem.getValue();
            ObjectNode hostNode = StmtUtil.mapper.createObjectNode();
            for (Map.Entry<String, String> elem0 : hostMap.entrySet()) {
                hostNode.put(elem0.getKey(), elem0.getValue());
            }
            res.set(elemHost, (JsonNode)hostNode);
        }
        return res;
    }

    @Override
    public synchronized SecureStorageManager.SecureStorageStatus setCredential(String host, String user, String type, String token) {
        if (Strings.isNullOrEmpty((String)token)) {
            logger.info("No token provided", false);
            return SecureStorageManager.SecureStorageStatus.SUCCESS;
        }
        this.localCredCache.computeIfAbsent(host.toUpperCase(), newMap -> new HashMap());
        Map<String, String> hostMap = this.localCredCache.get(host.toUpperCase());
        hostMap.put(SecureStorageManager.convertTarget(host, user, type), token);
        this.fileCacheManager.writeCacheFile((JsonNode)this.localCacheToJson());
        return SecureStorageManager.SecureStorageStatus.SUCCESS;
    }

    @Override
    public synchronized String getCredential(String host, String user, String type) {
        JsonNode res = this.fileCacheManager.readCacheFile();
        this.readJsonStoreCache(res);
        Map<String, String> hostMap = this.localCredCache.get(host.toUpperCase());
        if (hostMap == null) {
            return null;
        }
        return hostMap.get(SecureStorageManager.convertTarget(host, user, type));
    }

    @Override
    public synchronized SecureStorageManager.SecureStorageStatus deleteCredential(String host, String user, String type) {
        Map<String, String> hostMap = this.localCredCache.get(host.toUpperCase());
        if (hostMap != null) {
            hostMap.remove(SecureStorageManager.convertTarget(host, user, type));
            if (hostMap.isEmpty()) {
                this.localCredCache.remove(host.toUpperCase());
            }
        }
        this.fileCacheManager.writeCacheFile((JsonNode)this.localCacheToJson());
        return SecureStorageManager.SecureStorageStatus.SUCCESS;
    }

    private void readJsonStoreCache(JsonNode m) {
        if (m == null || !m.getNodeType().equals((Object)JsonNodeType.OBJECT)) {
            logger.debug("Invalid cache file format.", new Object[0]);
            return;
        }
        Iterator itr = m.fields();
        while (itr.hasNext()) {
            Map.Entry hostMap = (Map.Entry)itr.next();
            String host = (String)hostMap.getKey();
            if (!this.localCredCache.containsKey(host)) {
                this.localCredCache.put(host, new HashMap());
            }
            JsonNode userJsonNode = (JsonNode)hostMap.getValue();
            Iterator itr0 = userJsonNode.fields();
            while (itr0.hasNext()) {
                Map.Entry userMap = (Map.Entry)itr0.next();
                this.localCredCache.get(host).put((String)userMap.getKey(), ((JsonNode)userMap.getValue()).asText());
            }
        }
    }

    private static class SecureStorageLinuxManagerHolder {
        private static final SecureStorageLinuxManager INSTANCE = new SecureStorageLinuxManager();

        private SecureStorageLinuxManagerHolder() {
        }
    }
}

