/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.json;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.snowflake.client.core.SFException;
import net.snowflake.client.jdbc.ErrorCode;

public class NumberConverter {
    private static final int LONG_PRECISION = 19;
    private static final BigDecimal MAX_LONG_VAL = new BigDecimal(Long.MAX_VALUE);
    private static final BigDecimal MIN_LONG_VAL = new BigDecimal(Long.MIN_VALUE);

    public byte getByte(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            return Byte.parseByte((String)obj);
        }
        return ((Number)obj).byteValue();
    }

    public short getShort(Object obj, int columnType) throws SFException {
        if (obj == null) {
            return 0;
        }
        try {
            if (obj instanceof String) {
                String objString = (String)obj;
                if (objString.contains(".") && (columnType == 6 || columnType == 8)) {
                    objString = objString.substring(0, objString.indexOf("."));
                }
                return Short.parseShort(objString);
            }
            return ((Number)obj).shortValue();
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "short", obj);
        }
    }

    public int getInt(Object obj, int columnType) throws SFException {
        if (obj == null) {
            return 0;
        }
        try {
            if (obj instanceof String) {
                String objString = (String)obj;
                if (objString.contains(".") && (columnType == 6 || columnType == 8)) {
                    objString = objString.substring(0, objString.indexOf("."));
                }
                return Integer.parseInt(objString);
            }
            return ((Number)obj).intValue();
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "int", obj);
        }
    }

    public long getLong(Object obj, int columnType) throws SFException {
        if (obj == null) {
            return 0L;
        }
        try {
            if (obj instanceof String) {
                String objString = (String)obj;
                if (objString.contains(".") && (columnType == 6 || columnType == 8)) {
                    objString = objString.substring(0, objString.indexOf("."));
                }
                return Long.parseLong(objString);
            }
            return ((Number)obj).longValue();
        }
        catch (NumberFormatException nfe) {
            if (4 == columnType || 5 == columnType) {
                throw new SFException(ErrorCode.INTERNAL_ERROR, "long: " + obj.toString());
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "long", obj);
        }
    }

    public BigDecimal getBigDecimal(Object obj, int columnType) throws SFException {
        if (obj == null) {
            return null;
        }
        try {
            if (columnType != 92 && columnType != 93 && columnType != 2014) {
                return new BigDecimal(obj.toString());
            }
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "big decimal", obj);
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "big decimal", obj);
        }
    }

    public BigDecimal getBigDecimal(Object obj, int columnType, Integer scale) throws SFException {
        if (obj == null) {
            return null;
        }
        BigDecimal value = new BigDecimal(obj.toString());
        value = value.setScale((int)scale, RoundingMode.HALF_UP);
        return value;
    }

    public float getFloat(Object obj, int columnType) throws SFException {
        if (obj == null) {
            return 0.0f;
        }
        try {
            if (obj instanceof String) {
                if (columnType != 92 && columnType != 93 && columnType != 2014) {
                    if ("inf".equals(obj)) {
                        return Float.POSITIVE_INFINITY;
                    }
                    if ("-inf".equals(obj)) {
                        return Float.NEGATIVE_INFINITY;
                    }
                    return Float.parseFloat((String)obj);
                }
                throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "float", obj);
            }
            return ((Number)obj).floatValue();
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "float", obj);
        }
    }

    public double getDouble(Object obj, int columnType) throws SFException {
        if (obj == null) {
            return 0.0;
        }
        try {
            if (obj instanceof String) {
                if (columnType != 92 && columnType != 93 && columnType != 2014) {
                    if ("inf".equals(obj)) {
                        return Double.POSITIVE_INFINITY;
                    }
                    if ("-inf".equals(obj)) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    return Double.parseDouble((String)obj);
                }
                throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "double", obj);
            }
            return ((Number)obj).doubleValue();
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, columnType, "double", obj);
        }
    }

    public Object getBigInt(Object obj, int columnType) throws SFException {
        BigDecimal bigNum;
        String numberAsString = obj.toString();
        if (numberAsString.length() >= 19 && ((bigNum = this.getBigDecimal(obj, columnType)).compareTo(MAX_LONG_VAL) == 1 || bigNum.compareTo(MIN_LONG_VAL) == -1)) {
            return bigNum;
        }
        return this.getLong(obj, columnType);
    }
}

