/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.snowflake.client.core.ExecTimeTelemetryData;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.jdbc.ChunkDownloadContext;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.ResultStreamProvider;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.util.SecretDetector;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public class DefaultResultStreamProvider
implements ResultStreamProvider {
    private static final String SSE_C_ALGORITHM = "x-amz-server-side-encryption-customer-algorithm";
    private static final String SSE_C_KEY = "x-amz-server-side-encryption-customer-key";
    private static final String SSE_C_AES = "AES256";
    private static final int STREAM_BUFFER_SIZE = 0x100000;

    @Override
    public InputStream getInputStream(ChunkDownloadContext context) throws Exception {
        InputStream inputStream;
        HttpResponse response;
        try {
            response = this.getResultChunk(context);
        }
        catch (IOException | URISyntaxException ex) {
            throw new SnowflakeSQLLoggedException(context.getSession(), (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "58030", "Error encountered when request a result chunk URL: " + context.getResultChunk().getUrl() + " " + ex.getLocalizedMessage());
        }
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            SnowflakeResultSetSerializableV1.logger.error("Error fetching chunk from: {}", context.getResultChunk().getScrubbedUrl());
            SnowflakeUtil.logResponseDetails(response, SnowflakeResultSetSerializableV1.logger);
            throw new SnowflakeSQLException("58030", (int)ErrorCode.NETWORK_ERROR.getMessageCode(), "Error encountered when downloading a result chunk: HTTP status=" + (response != null ? Integer.valueOf(response.getStatusLine().getStatusCode()) : "null response"));
        }
        HttpEntity entity = response.getEntity();
        try {
            inputStream = this.detectContentEncodingAndGetInputStream(response, entity.getContent());
        }
        catch (Exception ex) {
            SnowflakeResultSetSerializableV1.logger.error("Failed to decompress data: {}", response);
            throw new SnowflakeSQLLoggedException(context.getSession(), (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Failed to decompress data: " + response.toString());
        }
        SnowflakeResultSetSerializableV1.logger.debug("Json response: {}", response);
        return inputStream;
    }

    private HttpResponse getResultChunk(ChunkDownloadContext context) throws Exception {
        URIBuilder uriBuilder = new URIBuilder(context.getResultChunk().getUrl());
        HttpGet httpRequest = new HttpGet(uriBuilder.build());
        if (context.getChunkHeadersMap() != null && context.getChunkHeadersMap().size() != 0) {
            for (Map.Entry<String, String> entry : context.getChunkHeadersMap().entrySet()) {
                SnowflakeResultSetSerializableV1.logger.debug("Adding header key={}, value={}", entry.getKey(), entry.getValue());
                httpRequest.addHeader(entry.getKey(), entry.getValue());
            }
        } else if (context.getQrmk() != null) {
            httpRequest.addHeader(SSE_C_ALGORITHM, SSE_C_AES);
            httpRequest.addHeader(SSE_C_KEY, context.getQrmk());
            SnowflakeResultSetSerializableV1.logger.debug("Adding SSE-C headers", false);
        }
        SnowflakeResultSetSerializableV1.logger.debug("Thread {} Fetching result #chunk{}: {}", Thread.currentThread().getId(), context.getChunkIndex(), context.getResultChunk().getScrubbedUrl());
        CloseableHttpClient httpClient = HttpUtil.getHttpClient(context.getChunkDownloader().getHttpClientSettingsKey());
        CloseableHttpResponse response = RestRequest.execute(httpClient, (HttpRequestBase)httpRequest, context.getNetworkTimeoutInMilli() / 1000, context.getAuthTimeout(), context.getSocketTimeout(), 0, 0, null, false, false, false, true, true, new ExecTimeTelemetryData());
        SnowflakeResultSetSerializableV1.logger.debug("Thread {} Call #chunk{} returned for URL: {}, response={}", Thread.currentThread().getId(), context.getChunkIndex(), () -> SecretDetector.maskSASToken(context.getResultChunk().getUrl()), response);
        return response;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InputStream detectContentEncodingAndGetInputStream(HttpResponse response, InputStream is) throws IOException, SnowflakeSQLException {
        InputStream inputStream = is;
        Header encoding = response.getFirstHeader("Content-Encoding");
        if (encoding == null) return DefaultResultStreamProvider.detectGzipAndGetStream(is);
        if (!"gzip".equalsIgnoreCase(encoding.getValue())) throw new SnowflakeSQLException("XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Exception: unexpected compression got " + encoding.getValue());
        return new GZIPInputStream(is, 0x100000);
    }

    public static InputStream detectGzipAndGetStream(InputStream is) throws IOException {
        PushbackInputStream pb = new PushbackInputStream(is, 2);
        byte[] signature = new byte[2];
        int len = pb.read(signature);
        pb.unread(signature, 0, len);
        if (signature[0] == 31 && signature[1] == -117) {
            return new GZIPInputStream(pb);
        }
        return pb;
    }
}

