/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.cloud.storage.Blob;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.net.URISyntaxException;
import java.util.Base64;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class StorageObjectSummary {
    private static final SFLogger logger = SFLoggerFactory.getLogger(StorageObjectSummary.class);
    private String location;
    private String key;
    private String md5;
    private long size;

    private StorageObjectSummary(String location, String key, String md5, long size) {
        this.location = location;
        this.key = key;
        this.md5 = md5;
        this.size = size;
    }

    public static StorageObjectSummary createFromS3ObjectSummary(S3ObjectSummary objSummary) {
        return new StorageObjectSummary(objSummary.getBucketName(), objSummary.getKey(), objSummary.getETag(), objSummary.getSize());
    }

    public static StorageObjectSummary createFromAzureListBlobItem(ListBlobItem listBlobItem) throws StorageProviderException {
        long size;
        String md5;
        String key;
        String location;
        try {
            CloudBlobContainer container = listBlobItem.getContainer();
            location = container.getName();
            CloudBlob cloudBlob = (CloudBlob)listBlobItem;
            key = cloudBlob.getName();
            BlobProperties blobProperties = cloudBlob.getProperties();
            md5 = StorageObjectSummary.convertBase64ToHex(blobProperties.getContentMD5());
            size = blobProperties.getLength();
        }
        catch (StorageException | URISyntaxException ex) {
            logger.debug("Failed to create StorageObjectSummary from Azure ListBlobItem: {}", ex);
            throw new StorageProviderException((Exception)ex);
        }
        catch (Throwable th) {
            logger.debug("Failed to create StorageObjectSummary from Azure ListBlobItem: {}", th);
            throw th;
        }
        return new StorageObjectSummary(location, key, md5, size);
    }

    public static StorageObjectSummary createFromGcsBlob(Blob blob) {
        String bucketName = blob.getBucket();
        String path = blob.getName();
        String hexMD5 = blob.getMd5ToHexString();
        long size = blob.getSize();
        return new StorageObjectSummary(bucketName, path, hexMD5, size);
    }

    private static String convertBase64ToHex(String base64String) {
        try {
            byte[] bytes = Base64.getDecoder().decode(base64String);
            StringBuilder builder = new StringBuilder();
            for (byte b : bytes) {
                builder.append(String.format("%02x", b));
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public String getLocation() {
        return this.location;
    }

    public String getKey() {
        return this.key;
    }

    public String getMD5() {
        return this.md5;
    }

    public long getSize() {
        return this.size;
    }
}

