/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl;

import java.time.Duration;
import java.time.Period;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.PeriodDuration;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.impl.AbstractFieldReader;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.IntervalMonthDayNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.holders.NullableIntervalMonthDayNanoHolder;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;

public class NullableIntervalMonthDayNanoHolderReaderImpl
extends AbstractFieldReader {
    private NullableIntervalMonthDayNanoHolder holder;

    public NullableIntervalMonthDayNanoHolderReaderImpl(NullableIntervalMonthDayNanoHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INTERVALMONTHDAYNANO;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(IntervalMonthDayNanoHolder h) {
        h.months = this.holder.months;
        h.days = this.holder.days;
        h.nanoseconds = this.holder.nanoseconds;
    }

    @Override
    public void read(NullableIntervalMonthDayNanoHolder h) {
        h.months = this.holder.months;
        h.days = this.holder.days;
        h.nanoseconds = this.holder.nanoseconds;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public PeriodDuration readPeriodDuration() {
        if (!this.isSet()) {
            return null;
        }
        return new PeriodDuration(Period.ofMonths(this.holder.months).plusDays(this.holder.days), Duration.ofNanos(this.holder.nanoseconds));
    }

    @Override
    public Object readObject() {
        return this.readPeriodDuration();
    }
}

