/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.snowflake.client.core.HttpClientSettingsKey;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FileBackedOutputStream;
import net.snowflake.client.jdbc.MatDesc;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.SnowflakeFileTransferAgent;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.CommonObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.EncryptionProvider;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectSummaryCollection;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.amazonaws.util.Base64;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.Header;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpResponseException;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPut;
import net.snowflake.client.jdbc.internal.apache.http.client.utils.URIBuilder;
import net.snowflake.client.jdbc.internal.apache.http.entity.InputStreamEntity;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.CloseableHttpClient;
import net.snowflake.client.jdbc.internal.apache.http.util.EntityUtils;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonParser;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.google.api.gax.paging.Page;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.FixedHeaderProvider;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Blob;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobId;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Storage;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageOptions;
import net.snowflake.client.jdbc.internal.google.common.base.Strings;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.SFPair;

public class SnowflakeGCSClient
implements SnowflakeStorageClient {
    private static final String GCS_ENCRYPTIONDATAPROP = "encryptiondata";
    private static final String localFileSep = SnowflakeUtil.systemGetProperty("file.separator");
    private static final String GCS_METADATA_PREFIX = "x-goog-meta-";
    private static final String GCS_STREAMING_INGEST_CLIENT_NAME = "ingestclientname";
    private static final String GCS_STREAMING_INGEST_CLIENT_KEY = "ingestclientkey";
    private int encryptionKeySize = 0;
    private StageInfo stageInfo;
    private RemoteStoreFileEncryptionMaterial encMat;
    private Storage gcsClient = null;
    private SFSession session = null;
    private static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeGCSClient.class);

    private SnowflakeGCSClient() {
    }

    public static SnowflakeGCSClient createSnowflakeGCSClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat, SFSession session) throws SnowflakeSQLException {
        SnowflakeGCSClient sfGcsClient = new SnowflakeGCSClient();
        sfGcsClient.setupGCSClient(stage, encMat, session);
        return sfGcsClient;
    }

    @Override
    public int getMaxRetries() {
        return 25;
    }

    @Override
    public int getRetryBackoffMaxExponent() {
        return 4;
    }

    @Override
    public int getRetryBackoffMin() {
        return 1000;
    }

    @Override
    public boolean isEncrypting() {
        return this.encryptionKeySize > 0 && this.stageInfo.getIsClientSideEncrypted();
    }

    @Override
    public int getEncryptionKeySize() {
        return this.encryptionKeySize;
    }

    @Override
    public boolean requirePresignedUrl() {
        Map<?, ?> credentialsMap = this.stageInfo.getCredentials();
        return credentialsMap == null || !credentialsMap.containsKey("GCS_ACCESS_TOKEN");
    }

    @Override
    public void renew(Map<?, ?> stageCredentials) throws SnowflakeSQLException {
        this.stageInfo.setCredentials(stageCredentials);
        this.setupGCSClient(this.stageInfo, this.encMat, this.session);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public StorageObjectSummaryCollection listObjects(String remoteStorageLocation, String prefix) throws StorageProviderException {
        try {
            Page<Blob> blobs = this.gcsClient.list(remoteStorageLocation, Storage.BlobListOption.prefix(prefix));
            return new StorageObjectSummaryCollection(blobs);
        }
        catch (Exception e) {
            logger.debug("Failed to list objects", false);
            throw new StorageProviderException(e);
        }
    }

    @Override
    public StorageObjectMetadata getObjectMetadata(String remoteStorageLocation, String prefix) throws StorageProviderException {
        try {
            BlobId blobId = BlobId.of(remoteStorageLocation, prefix);
            Blob blob = this.gcsClient.get(blobId);
            if (blob == null) {
                throw new StorageProviderException(new StorageException(404, "Blob" + blobId.getName() + " not found in bucket " + blobId.getBucket()));
            }
            return new CommonObjectMetadata(blob.getSize(), blob.getContentEncoding(), blob.getMetadata());
        }
        catch (StorageException ex) {
            throw new StorageProviderException(ex);
        }
    }

    @Override
    public void download(SFSession session, String command, String localLocation, String destFileName, int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion, String presignedUrl) throws SnowflakeSQLException {
        int retryCount = 0;
        String localFilePath = localLocation + localFileSep + destFileName;
        File localFile = new File(localFilePath);
        while (true) {
            try {
                String key = null;
                String iv = null;
                if (!Strings.isNullOrEmpty(presignedUrl)) {
                    logger.debug("Starting download with presigned URL", false);
                    URIBuilder uriBuilder = new URIBuilder(presignedUrl);
                    HttpGet httpRequest = new HttpGet(uriBuilder.build());
                    httpRequest.addHeader("accept-encoding", "GZIP");
                    logger.debug("Fetching result: {}", this.scrubPresignedUrl(presignedUrl));
                    CloseableHttpClient httpClient = HttpUtil.getHttpClientWithoutDecompression(session.getHttpClientKey());
                    CloseableHttpResponse response = RestRequest.execute(httpClient, httpRequest, session.getNetworkTimeoutInMilli() / 1000, session.getAuthTimeout(), session.getHttpClientSocketTimeout(), 0, 0, null, false, false, false, true);
                    logger.debug("Call returned for URL: {}", () -> this.scrubPresignedUrl(this.stageInfo.getPresignedUrl()));
                    if (SnowflakeGCSClient.isSuccessStatusCode(response.getStatusLine().getStatusCode())) {
                        try {
                            int bytesRead;
                            InputStream bodyStream = response.getEntity().getContent();
                            byte[] buffer = new byte[8192];
                            FileOutputStream outStream = new FileOutputStream(localFile);
                            while ((bytesRead = bodyStream.read(buffer)) != -1) {
                                ((OutputStream)outStream).write(buffer, 0, bytesRead);
                            }
                            outStream.flush();
                            ((OutputStream)outStream).close();
                            bodyStream.close();
                            if (this.isEncrypting()) {
                                for (Header header : response.getAllHeaders()) {
                                    if (!header.getName().equalsIgnoreCase("x-goog-meta-encryptiondata")) continue;
                                    AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData(header.getValue());
                                    key = encryptionData.getKey();
                                    iv = encryptionData.getValue();
                                    break;
                                }
                            }
                            logger.debug("Download successful", false);
                        }
                        catch (IOException ex) {
                            logger.debug("Download unsuccessful {}", ex);
                            this.handleStorageException(ex, ++retryCount, "download", session, command);
                        }
                    } else {
                        HttpResponseException ex = new HttpResponseException(response.getStatusLine().getStatusCode(), EntityUtils.toString(response.getEntity()));
                        this.handleStorageException(ex, ++retryCount, "download", session, command);
                    }
                } else {
                    BlobId blobId = BlobId.of(remoteStorageLocation, stageFilePath);
                    Blob blob = this.gcsClient.get(blobId);
                    if (blob == null) {
                        throw new StorageProviderException(new StorageException(404, "Blob" + blobId.getName() + " not found in bucket " + blobId.getBucket()));
                    }
                    logger.debug("Starting download without presigned URL", false);
                    blob.downloadTo(localFile.toPath(), Blob.BlobSourceOption.shouldReturnRawInputStream(true));
                    logger.debug("Download successful", false);
                    Map<String, String> userDefinedMetadata = blob.getMetadata();
                    if (this.isEncrypting() && userDefinedMetadata != null) {
                        AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData(userDefinedMetadata.get(GCS_ENCRYPTIONDATAPROP));
                        key = encryptionData.getKey();
                        iv = encryptionData.getValue();
                    }
                }
                if (!Strings.isNullOrEmpty(iv) && !Strings.isNullOrEmpty(key) && this.isEncrypting() && this.getEncryptionKeySize() <= 256) {
                    if (key == null || iv == null) {
                        throw new SnowflakeSQLLoggedException((SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "File metadata incomplete");
                    }
                    try {
                        EncryptionProvider.decrypt(localFile, key, iv, this.encMat);
                    }
                    catch (Exception ex) {
                        logger.error("Error decrypting file", ex);
                        throw new SnowflakeSQLLoggedException((SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Cannot decrypt file");
                    }
                }
                return;
            }
            catch (Exception ex) {
                logger.debug("Download unsuccessful {}", ex);
                this.handleStorageException(ex, ++retryCount, "download", session, command);
                if (retryCount <= this.getMaxRetries()) continue;
                throw new SnowflakeSQLLoggedException((SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected: download unsuccessful without exception!");
            }
            break;
        }
    }

    @Override
    public InputStream downloadToStream(SFSession session, String command, int parallelism, String remoteStorageLocation, String stageFilePath, String stageRegion, String presignedUrl) throws SnowflakeSQLException {
        int retryCount = 0;
        InputStream inputStream = null;
        do {
            try {
                String key = null;
                String iv = null;
                if (!Strings.isNullOrEmpty(presignedUrl)) {
                    logger.debug("Starting download with presigned URL", false);
                    URIBuilder uriBuilder = new URIBuilder(presignedUrl);
                    HttpGet httpRequest = new HttpGet(uriBuilder.build());
                    httpRequest.addHeader("accept-encoding", "GZIP");
                    logger.debug("Fetching result: {}", this.scrubPresignedUrl(presignedUrl));
                    CloseableHttpClient httpClient = HttpUtil.getHttpClientWithoutDecompression(session.getHttpClientKey());
                    CloseableHttpResponse response = RestRequest.execute(httpClient, httpRequest, session.getNetworkTimeoutInMilli() / 1000, session.getAuthTimeout(), session.getHttpClientSocketTimeout(), 0, 0, null, false, false, false, true);
                    logger.debug("Call returned for URL: {}", () -> this.scrubPresignedUrl(this.stageInfo.getPresignedUrl()));
                    if (SnowflakeGCSClient.isSuccessStatusCode(response.getStatusLine().getStatusCode())) {
                        try {
                            inputStream = response.getEntity().getContent();
                            if (this.isEncrypting()) {
                                for (Header header : response.getAllHeaders()) {
                                    if (!header.getName().equalsIgnoreCase("x-goog-meta-encryptiondata")) continue;
                                    AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData(header.getValue());
                                    key = encryptionData.getKey();
                                    iv = encryptionData.getValue();
                                    break;
                                }
                            }
                            logger.debug("Download successful", false);
                        }
                        catch (IOException ex) {
                            logger.debug("Download unsuccessful {}", ex);
                            this.handleStorageException(ex, ++retryCount, "download", session, command);
                        }
                    } else {
                        HttpResponseException ex = new HttpResponseException(response.getStatusLine().getStatusCode(), EntityUtils.toString(response.getEntity()));
                        this.handleStorageException(ex, ++retryCount, "download", session, command);
                    }
                } else {
                    BlobId blobId = BlobId.of(remoteStorageLocation, stageFilePath);
                    Blob blob = this.gcsClient.get(blobId);
                    if (blob == null) {
                        throw new StorageProviderException(new StorageException(404, "Blob" + blobId.getName() + " not found in bucket " + blobId.getBucket()));
                    }
                    inputStream = new ByteArrayInputStream(blob.getContent(new Blob.BlobSourceOption[0]));
                    if (this.isEncrypting()) {
                        Map<String, String> userDefinedMetadata = blob.getMetadata();
                        AbstractMap.SimpleEntry<String, String> encryptionData = this.parseEncryptionData(userDefinedMetadata.get(GCS_ENCRYPTIONDATAPROP));
                        key = encryptionData.getKey();
                        iv = encryptionData.getValue();
                    }
                }
                if (!this.isEncrypting() || this.getEncryptionKeySize() > 256) continue;
                if (key == null || iv == null) {
                    throw new SnowflakeSQLException("XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "File metadata incomplete");
                }
                try {
                    if (inputStream != null) {
                        inputStream = EncryptionProvider.decryptStream(inputStream, key, iv, this.encMat);
                        return inputStream;
                    }
                }
                catch (Exception ex) {
                    logger.error("Error decrypting file", ex);
                    throw new SnowflakeSQLLoggedException((SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Cannot decrypt file");
                }
            }
            catch (Exception ex) {
                logger.debug("Download unsuccessful {}", ex);
                this.handleStorageException(ex, ++retryCount, "download", session, command);
            }
        } while (retryCount <= this.getMaxRetries());
        throw new SnowflakeSQLLoggedException((SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected: download unsuccessful without exception!");
    }

    @Override
    public void uploadWithPresignedUrlWithoutConnection(int networkTimeoutInMilli, HttpClientSettingsKey ocspModeAndProxyKey, int parallelism, boolean uploadFromStream, String remoteStorageLocation, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, StorageObjectMetadata meta, String stageRegion, String presignedUrl) throws SnowflakeSQLException {
        ArrayList<FileInputStream> toClose = new ArrayList<FileInputStream>();
        long originalContentLength = meta.getContentLength();
        SFPair<InputStream, Boolean> uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, meta, originalContentLength, fileBackedOutputStream, toClose);
        if (!(meta instanceof CommonObjectMetadata)) {
            throw new IllegalArgumentException("Unexpected metadata object type");
        }
        if (Strings.isNullOrEmpty(presignedUrl)) {
            throw new IllegalArgumentException("pre-signed URL has to be specified");
        }
        logger.debug("Starting upload", new Object[0]);
        this.uploadWithPresignedUrl(networkTimeoutInMilli, 0, 300000, meta.getContentEncoding(), meta.getUserMetadata(), (InputStream)uploadStreamInfo.left, presignedUrl, ocspModeAndProxyKey);
        logger.debug("Upload successful", false);
        for (FileInputStream is : toClose) {
            IOUtils.closeQuietly(is);
        }
    }

    @Override
    public void upload(SFSession session, String command, int parallelism, boolean uploadFromStream, String remoteStorageLocation, File srcFile, String destFileName, InputStream inputStream, FileBackedOutputStream fileBackedOutputStream, StorageObjectMetadata meta, String stageRegion, String presignedUrl) throws SnowflakeSQLException {
        ArrayList<FileInputStream> toClose = new ArrayList<FileInputStream>();
        long originalContentLength = meta.getContentLength();
        SFPair<InputStream, Boolean> uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, meta, originalContentLength, fileBackedOutputStream, toClose);
        if (!(meta instanceof CommonObjectMetadata)) {
            throw new IllegalArgumentException("Unexpected metadata object type");
        }
        if (!Strings.isNullOrEmpty(presignedUrl)) {
            logger.debug("Starting upload", false);
            this.uploadWithPresignedUrl(session.getNetworkTimeoutInMilli(), session.getAuthTimeout(), session.getHttpClientSocketTimeout(), meta.getContentEncoding(), meta.getUserMetadata(), (InputStream)uploadStreamInfo.left, presignedUrl, session.getHttpClientKey());
            logger.debug("Upload successful", false);
            for (FileInputStream is : toClose) {
                IOUtils.closeQuietly(is);
            }
            return;
        }
        int retryCount = 0;
        while (true) {
            try {
                logger.debug("Starting upload", false);
                InputStream fileInputStream = (InputStream)uploadStreamInfo.left;
                BlobId blobId = BlobId.of(remoteStorageLocation, destFileName);
                BlobInfo blobInfo = BlobInfo.newBuilder(blobId).setContentEncoding(meta.getContentEncoding()).setMetadata(meta.getUserMetadata()).build();
                this.gcsClient.create(blobInfo, fileInputStream, new Storage.BlobWriteOption[0]);
                logger.debug("Upload successful", false);
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                return;
            }
            catch (Exception ex) {
                this.handleStorageException(ex, ++retryCount, "upload", session, command);
                if (uploadFromStream && fileBackedOutputStream == null) {
                    throw new SnowflakeSQLLoggedException((SFBaseSession)session, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), ex, "Encountered exception during upload: " + ex.getMessage() + "\nCannot retry upload from stream.");
                }
                uploadStreamInfo = this.createUploadStream(srcFile, uploadFromStream, inputStream, meta, originalContentLength, fileBackedOutputStream, toClose);
                if (retryCount <= this.getMaxRetries()) continue;
                for (FileInputStream is : toClose) {
                    IOUtils.closeQuietly(is);
                }
                throw new SnowflakeSQLLoggedException((SFBaseSession)session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected: upload unsuccessful without exception!");
            }
            break;
        }
    }

    private void uploadWithPresignedUrl(int networkTimeoutInMilli, int authTimeout, int httpClientSocketTimeout, String contentEncoding, Map<String, String> metadata, InputStream content, String presignedUrl, HttpClientSettingsKey ocspAndProxyKey) throws SnowflakeSQLException {
        try {
            URIBuilder uriBuilder = new URIBuilder(presignedUrl);
            HttpPut httpRequest = new HttpPut(uriBuilder.build());
            logger.debug("Fetching result: {}", this.scrubPresignedUrl(presignedUrl));
            if ("gzip".equals(contentEncoding)) {
                contentEncoding = "";
            }
            httpRequest.addHeader("content-encoding", contentEncoding);
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                httpRequest.addHeader(GCS_METADATA_PREFIX + entry.getKey(), entry.getValue());
            }
            InputStreamEntity contentEntity = new InputStreamEntity(content, -1L);
            httpRequest.setEntity(contentEntity);
            CloseableHttpClient httpClient = HttpUtil.getHttpClient(ocspAndProxyKey);
            CloseableHttpResponse response = RestRequest.execute(httpClient, httpRequest, networkTimeoutInMilli / 1000, authTimeout, httpClientSocketTimeout, 0, 0, null, false, false, false, true);
            logger.debug("Call returned for URL: {}", () -> this.scrubPresignedUrl(this.stageInfo.getPresignedUrl()));
            if (!SnowflakeGCSClient.isSuccessStatusCode(response.getStatusLine().getStatusCode())) {
                HttpResponseException ex = new HttpResponseException(response.getStatusLine().getStatusCode(), EntityUtils.toString(response.getEntity()));
                this.handleStorageException(ex, 0, "upload", this.session, null);
            }
        }
        catch (URISyntaxException e) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected: upload presigned URL invalid");
        }
        catch (Exception e) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected: upload with presigned url failed");
        }
    }

    private String scrubPresignedUrl(String presignedUrl) {
        if (Strings.isNullOrEmpty(presignedUrl)) {
            return "";
        }
        int indexOfQueryString = presignedUrl.lastIndexOf("?");
        indexOfQueryString = indexOfQueryString > 0 ? indexOfQueryString : presignedUrl.length() - 1;
        return presignedUrl.substring(0, indexOfQueryString);
    }

    private SFPair<InputStream, Boolean> createUploadStream(File srcFile, boolean uploadFromStream, InputStream inputStream, StorageObjectMetadata meta, long originalContentLength, FileBackedOutputStream fileBackedOutputStream, List<FileInputStream> toClose) throws SnowflakeSQLException {
        InputStream stream;
        block10: {
            logger.debug("createUploadStream({}, {}, {}, {}, {}, {})", this, srcFile, uploadFromStream, inputStream, fileBackedOutputStream, toClose);
            FileInputStream srcFileStream = null;
            try {
                if (this.isEncrypting() && this.getEncryptionKeySize() < 256) {
                    try {
                        InputStream inputStream2;
                        if (uploadFromStream) {
                            inputStream2 = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                        } else {
                            srcFileStream = new FileInputStream(srcFile);
                            inputStream2 = srcFileStream;
                        }
                        InputStream uploadStream = inputStream2;
                        toClose.add(srcFileStream);
                        stream = EncryptionProvider.encrypt(meta, originalContentLength, uploadStream, this.encMat, this);
                        uploadFromStream = true;
                        break block10;
                    }
                    catch (Exception ex) {
                        logger.error("Failed to encrypt input", ex);
                        throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Failed to encrypt input", ex.getMessage());
                    }
                }
                if (uploadFromStream) {
                    stream = fileBackedOutputStream != null ? fileBackedOutputStream.asByteSource().openStream() : inputStream;
                } else {
                    srcFileStream = new FileInputStream(srcFile);
                    toClose.add(srcFileStream);
                    stream = srcFileStream;
                }
            }
            catch (FileNotFoundException ex) {
                logger.error("Failed to open input file", ex);
                throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Failed to open input file", ex.getMessage());
            }
            catch (IOException ex) {
                logger.error("Failed to open input stream", ex);
                throw new SnowflakeSQLLoggedException((SFBaseSession)this.session, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), ex, "Failed to open input stream", ex.getMessage());
            }
        }
        return SFPair.of(stream, uploadFromStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleStorageException(Exception ex, int retryCount, String operation, SFSession session, String command) throws SnowflakeSQLException {
        if (ex.getCause() instanceof InvalidKeyException) {
            SnowflakeFileTransferAgent.throwJCEMissingError(operation, ex);
        }
        if (ex instanceof StorageException) {
            StorageException se = (StorageException)ex;
            if (retryCount > this.getMaxRetries()) {
                throw new SnowflakeSQLLoggedException((SFBaseSession)session, "58000", (int)ErrorCode.GCP_SERVICE_ERROR.getMessageCode(), se, operation, se.getCode(), se.getMessage(), se.getReason());
            }
            logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
            logger.debug("Stack trace: ", ex);
            int backoffInMillis = this.getRetryBackoffMin();
            if (retryCount > 1) {
                backoffInMillis <<= Math.min(retryCount - 1, this.getRetryBackoffMaxExponent());
            }
            try {
                logger.debug("Sleep for {} milliseconds before retry", backoffInMillis);
                Thread.sleep(backoffInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (se.getCode() != 401 || command == null) return;
            if (session == null) throw new SnowflakeSQLException(se.getMessage(), 240001, "GCS credentials have expired");
            SnowflakeFileTransferAgent.renewExpiredToken(session, command, this);
            return;
        }
        if (!(ex instanceof InterruptedException) && !(SnowflakeUtil.getRootCause(ex) instanceof SocketTimeoutException)) throw new SnowflakeSQLLoggedException((SFBaseSession)session, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), ex, "Encountered exception during " + operation + ": " + ex.getMessage());
        if (retryCount > this.getMaxRetries()) {
            throw new SnowflakeSQLLoggedException((SFBaseSession)session, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), ex, "Encountered exception during " + operation + ": " + ex.getMessage());
        }
        logger.debug("Encountered exception ({}) during {}, retry count: {}", ex.getMessage(), operation, retryCount);
    }

    @Override
    public String getMatdescKey() {
        return "matdesc";
    }

    @Override
    public void addEncryptionMetadata(StorageObjectMetadata meta, MatDesc matDesc, byte[] ivData, byte[] encKeK, long contentLength) {
        meta.addUserMetadata(this.getMatdescKey(), matDesc.toString());
        meta.addUserMetadata(GCS_ENCRYPTIONDATAPROP, this.buildEncryptionMetadataJSON(Base64.encodeAsString(ivData), Base64.encodeAsString(encKeK)));
        meta.setContentLength(contentLength);
    }

    private String buildEncryptionMetadataJSON(String iv64, String key64) {
        return String.format("{\"EncryptionMode\":\"FullBlob\",\"WrappedContentKey\":{\"KeyId\":\"symmKey1\",\"EncryptedKey\":\"%s\",\"Algorithm\":\"AES_CBC_256\"},\"EncryptionAgent\":{\"Protocol\":\"1.0\",\"EncryptionAlgorithm\":\"AES_CBC_256\"},\"ContentEncryptionIV\":\"%s\",\"KeyWrappingMetadata\":{\"EncryptionLibrary\":\"Java 5.3.0\"}}", key64, iv64);
    }

    private AbstractMap.SimpleEntry<String, String> parseEncryptionData(String jsonEncryptionData) throws SnowflakeSQLException {
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        JsonFactory factory = mapper.getFactory();
        try {
            JsonParser parser = factory.createParser(jsonEncryptionData);
            JsonNode encryptionDataNode = (JsonNode)mapper.readTree(parser);
            String iv = encryptionDataNode.get("ContentEncryptionIV").asText();
            String key = encryptionDataNode.get("WrappedContentKey").get("EncryptedKey").asText();
            return new AbstractMap.SimpleEntry<String, String>(key, iv);
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException((Throwable)ex, "58000", (int)ErrorCode.IO_ERROR.getMessageCode(), "Error parsing encryption data as json: " + ex.getMessage());
        }
    }

    @Override
    public void addDigestMetadata(StorageObjectMetadata meta, String digest) {
        if (!SnowflakeUtil.isBlank(digest)) {
            meta.addUserMetadata("sfc-digest", digest);
        }
    }

    @Override
    public String getDigestMetadata(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get("sfc-digest");
    }

    private void setupGCSClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat, SFSession session) throws IllegalArgumentException, SnowflakeSQLException {
        this.stageInfo = stage;
        this.encMat = encMat;
        this.session = session;
        logger.debug("Setting up the GCS client ", false);
        try {
            String accessToken = (String)stage.getCredentials().get("GCS_ACCESS_TOKEN");
            this.gcsClient = accessToken != null ? (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setHeaderProvider(FixedHeaderProvider.create("Authorization", "Bearer " + accessToken))).build().getService() : (Storage)StorageOptions.getUnauthenticatedInstance().getService();
            if (encMat != null) {
                byte[] decodedKey = Base64.decode(encMat.getQueryStageMasterKey());
                this.encryptionKeySize = decodedKey.length * 8;
                if (this.encryptionKeySize != 128 && this.encryptionKeySize != 192 && this.encryptionKeySize != 256) {
                    throw new SnowflakeSQLException("XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "unsupported key size", this.encryptionKeySize);
                }
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("invalid_gcs_credentials");
        }
    }

    private static boolean isSuccessStatusCode(int code) {
        return code < 300 && code >= 200;
    }

    @Override
    public void addStreamingIngestMetadata(StorageObjectMetadata meta, String clientName, String clientKey) {
        meta.addUserMetadata(GCS_STREAMING_INGEST_CLIENT_NAME, clientName);
        meta.addUserMetadata(GCS_STREAMING_INGEST_CLIENT_KEY, clientKey);
    }

    @Override
    public String getStreamingIngestClientName(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get(GCS_STREAMING_INGEST_CLIENT_NAME);
    }

    @Override
    public String getStreamingIngestClientKey(StorageObjectMetadata meta) {
        return meta.getUserMetadata().get(GCS_STREAMING_INGEST_CLIENT_KEY);
    }
}

