/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake.streaming;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import net.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import net.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.io.CloudStorage;
import net.snowflake.spark.snowflake.streaming.FailedFileList;
import net.snowflake.spark.snowflake.streaming.FailedFileList$;
import net.snowflake.spark.snowflake.streaming.IngestedFileList;
import net.snowflake.spark.snowflake.streaming.IngestedFileList$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class IngestContextManager$ {
    public static final IngestContextManager$ MODULE$ = new IngestContextManager$();
    private static final String CONTEXT_DIR = "context";
    private static final String INGEST_FILE_LIST_NAME = "ingested_file_list.json";
    private static final String FAILED_FILE_INDEX = "failed_file_index";
    private static final String LIST = "list";
    private static final String NAME = "name";
    private static final String TIME = "time";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Log logger = LogFactory.getLog(MODULE$.getClass());

    public String CONTEXT_DIR() {
        return CONTEXT_DIR;
    }

    public String INGEST_FILE_LIST_NAME() {
        return INGEST_FILE_LIST_NAME;
    }

    public String FAILED_FILE_INDEX() {
        return FAILED_FILE_INDEX;
    }

    public String LIST() {
        return LIST;
    }

    public String NAME() {
        return NAME;
    }

    public String TIME() {
        return TIME;
    }

    public ObjectMapper mapper() {
        return mapper;
    }

    public Log logger() {
        return logger;
    }

    public IngestedFileList readIngestList(CloudStorage storage, ServerConnection conn) {
        String fileName = new StringBuilder(1).append(this.CONTEXT_DIR()).append("/").append(this.INGEST_FILE_LIST_NAME()).toString();
        if (storage.fileExists(fileName)) {
            IngestedFileList ingestedFileList;
            InputStream inputStream = storage.download(fileName, false);
            ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
            int c = inputStream.read();
            while (c != -1) {
                buffer.append((Object)BoxesRunTime.boxToByte((byte)((byte)c)));
                c = inputStream.read();
            }
            try {
                JsonNode node = this.mapper().readTree(new String((byte[])buffer.toArray((ClassTag)ClassTag$.MODULE$.Byte()), Charset.forName("UTF-8")));
                int failedIndex = node.get(this.FAILED_FILE_INDEX()).asInt();
                FailedFileList failedList = this.readFailedFileList(failedIndex, storage, conn);
                ArrayNode arrNode = (ArrayNode)node.get(this.LIST());
                ObjectRef list = ObjectRef.create((Object)Nil$.MODULE$);
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), arrNode.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)arrNode.get(i).get(MODULE$.NAME()).asText()), (Object)BoxesRunTime.boxToLong((long)arrNode.get(i).get(MODULE$.TIME()).asLong()));
                    list$1.elem = ((List)list$1.elem).$colon$colon((Object)tuple2);
                });
                ingestedFileList = new IngestedFileList(storage, conn, (Option<FailedFileList>)new Some((Object)failedList), (Option<List<Tuple2<String, Object>>>)new Some((Object)((List)list.elem)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuilder(26).append("context file: ").append(fileName).append(" is broken: ").append(e).toString());
            }
            return ingestedFileList;
        }
        return new IngestedFileList(storage, conn, IngestedFileList$.MODULE$.apply$default$3(), IngestedFileList$.MODULE$.apply$default$4());
    }

    public FailedFileList readFailedFileList(int index, CloudStorage storage, ServerConnection conn) {
        String fileName = new StringBuilder(23).append(this.CONTEXT_DIR()).append("/failed_file_list_").append(index).append(".json").toString();
        if (storage.fileExists(fileName)) {
            FailedFileList failedFileList;
            InputStream inputStream = storage.download(fileName, false);
            ArrayBuffer buffer = ArrayBuffer$.MODULE$.empty();
            int c = inputStream.read();
            while (c != -1) {
                buffer.append((Object)BoxesRunTime.boxToByte((byte)((byte)c)));
                c = inputStream.read();
            }
            try {
                ArrayNode list = (ArrayNode)this.mapper().readTree(new String((byte[])buffer.toArray((ClassTag)ClassTag$.MODULE$.Byte()), Charset.forName("UTF-8")));
                ObjectRef set = ObjectRef.create((Object)HashSet$.MODULE$.empty());
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), list.size()).foreach((Function1 & Serializable)i -> IngestContextManager$.$anonfun$readFailedFileList$1(set, list, BoxesRunTime.unboxToInt((Object)i)));
                failedFileList = new FailedFileList(storage, conn, index, (Option<HashSet<String>>)new Some((Object)((HashSet)set.elem)));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(new StringBuilder(26).append("context file: ").append(fileName).append(" is broken: ").append(e).toString());
            }
            return failedFileList;
        }
        return new FailedFileList(storage, conn, index, FailedFileList$.MODULE$.apply$default$4());
    }

    public static final /* synthetic */ HashSet $anonfun$readFailedFileList$1(ObjectRef set$1, ArrayNode list$2, int i) {
        return (HashSet)((HashSet)set$1.elem).$plus$eq((Object)list$2.get(i).asText());
    }

    private IngestContextManager$() {
    }
}

