/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.spark.snowflake;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import net.snowflake.client.jdbc.SnowflakeDriver;
import net.snowflake.client.jdbc.SnowflakeResultSet;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3Client;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.AmazonS3URI;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.BucketLifecycleConfiguration;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ObjectNode;
import net.snowflake.spark.snowflake.ConstantString;
import net.snowflake.spark.snowflake.DefaultJDBCWrapper$;
import net.snowflake.spark.snowflake.FSType$;
import net.snowflake.spark.snowflake.JDBCWrapper;
import net.snowflake.spark.snowflake.Parameters;
import net.snowflake.spark.snowflake.Parameters$;
import net.snowflake.spark.snowflake.ServerConnection;
import net.snowflake.spark.snowflake.ServerConnection$;
import net.snowflake.spark.snowflake.SnowflakeSQLStatement;
import net.snowflake.spark.snowflake.SnowflakeTelemetry$;
import net.snowflake.spark.snowflake.TableName;
import net.snowflake.spark.snowflake.TelemetryClientInfoFields$;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;
import scala.util.control.NonFatal$;

public final class Utils$ {
    public static final Utils$ MODULE$ = new Utils$();
    private static String sparkAppName;
    private static String scalaVersion;
    private static String javaVersion;
    private static String jdbcVersion;
    private static final String SNOWFLAKE_SOURCE_NAME;
    private static final String SNOWFLAKE_SOURCE_SHORT_NAME;
    private static final String VERSION;
    private static final String CERTIFIED_JDBC_VERSION;
    private static final String PROPERTY_NAME_OF_CONNECTOR_VERSION;
    private static final ObjectMapper mapper;
    private static final String JDBC_DRIVER;
    private static final Logger log;
    private static String lastCopyUnload;
    private static String lastCopyLoad;
    private static String lastCopyLoadQueryId;
    private static String lastSelect;
    private static String lastSelectQueryId;
    private static String lastPutCommand;
    private static String lastGetCommand;
    private static volatile byte bitmap$0;

    static {
        SNOWFLAKE_SOURCE_NAME = "net.snowflake.spark.snowflake";
        SNOWFLAKE_SOURCE_SHORT_NAME = "snowflake";
        VERSION = "3.0.0";
        CERTIFIED_JDBC_VERSION = "3.17.0";
        PROPERTY_NAME_OF_CONNECTOR_VERSION = "spark.snowflakedb.version";
        mapper = new ObjectMapper();
        JDBC_DRIVER = "net.snowflake.client.jdbc.SnowflakeDriver";
        log = LoggerFactory.getLogger(MODULE$.getClass());
    }

    public String SNOWFLAKE_SOURCE_NAME() {
        return SNOWFLAKE_SOURCE_NAME;
    }

    public String SNOWFLAKE_SOURCE_SHORT_NAME() {
        return SNOWFLAKE_SOURCE_SHORT_NAME;
    }

    public String VERSION() {
        return VERSION;
    }

    public String CERTIFIED_JDBC_VERSION() {
        return CERTIFIED_JDBC_VERSION;
    }

    public String PROPERTY_NAME_OF_CONNECTOR_VERSION() {
        return PROPERTY_NAME_OF_CONNECTOR_VERSION;
    }

    private String sparkAppName$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                sparkAppName = SparkEnv$.MODULE$.get() != null ? SparkEnv$.MODULE$.get().conf().get("spark.app.name", "") : "";
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return sparkAppName;
    }

    public String sparkAppName() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.sparkAppName$lzycompute();
        }
        return sparkAppName;
    }

    private String scalaVersion$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                scalaVersion = Properties$.MODULE$.versionNumberString();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return scalaVersion;
    }

    public String scalaVersion() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.scalaVersion$lzycompute();
        }
        return scalaVersion;
    }

    private String javaVersion$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                javaVersion = System.getProperty("java.version", "UNKNOWN");
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return javaVersion;
    }

    public String javaVersion() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.javaVersion$lzycompute();
        }
        return javaVersion;
    }

    private String jdbcVersion$lzycompute() {
        Utils$ utils$ = this;
        synchronized (utils$) {
            if ((byte)(bitmap$0 & 8) == 0) {
                jdbcVersion = SnowflakeDriver.implementVersion;
                bitmap$0 = (byte)(bitmap$0 | 8);
            }
        }
        return jdbcVersion;
    }

    public String jdbcVersion() {
        if ((byte)(bitmap$0 & 8) == 0) {
            return this.jdbcVersion$lzycompute();
        }
        return jdbcVersion;
    }

    private ObjectMapper mapper() {
        return mapper;
    }

    public String JDBC_DRIVER() {
        return JDBC_DRIVER;
    }

    private Logger log() {
        return log;
    }

    public Class<?> classForName(String className) {
        ClassLoader classLoader = (ClassLoader)Option$.MODULE$.apply((Object)Thread.currentThread().getContextClassLoader()).getOrElse((Function0 & Serializable)() -> MODULE$.getClass().getClassLoader());
        return Class.forName(className, true, classLoader);
    }

    public String joinUrls(String a, String b) {
        return new java.lang.StringBuilder(2).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(a), "/")).append("/").append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(b), "/")), "/")).append("/").toString();
    }

    public String fixS3Url(String url) {
        return url.replaceAll("s3[an]://", "s3://");
    }

    public String fixUrlForCopyCommand(String url) {
        if (url.startsWith("wasb://") || url.startsWith("wasbs://")) {
            URI pathUri = URI.create(url);
            return new java.lang.StringBuilder(9).append("azure://").append(pathUri.getHost()).append("/").append(pathUri.getUserInfo()).append(pathUri.getPath()).toString();
        }
        return this.fixS3Url(url);
    }

    public URI removeCredentialsFromURI(URI uri) {
        return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
    }

    public String makeTempPath(String tempRoot) {
        return this.joinUrls(tempRoot, UUID.randomUUID().toString());
    }

    public void checkThatBucketHasObjectLifecycleConfiguration(String tempDir, Enumeration.Value tempDirStorageType, AmazonS3Client s3Client) {
        Enumeration.Value value = tempDirStorageType;
        Enumeration.Value value2 = FSType$.MODULE$.S3();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            BoxedUnit boxedUnit;
            try {
                AmazonS3URI s3URI = new AmazonS3URI(this.fixS3Url(tempDir));
                String bucket = s3URI.getBucket();
                BucketLifecycleConfiguration bucketLifecycleConfiguration = s3Client.getBucketLifecycleConfiguration(bucket);
                String key = (String)Option$.MODULE$.apply((Object)s3URI.getKey()).getOrElse((Function0 & Serializable)() -> "");
                boolean someRuleMatchesTempDir = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(bucketLifecycleConfiguration.getRules()).asScala()).exists((Function1 & Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$checkThatBucketHasObjectLifecycleConfiguration$2(key, rule)));
                if (!someRuleMatchesTempDir) {
                    this.log().warn(new java.lang.StringBuilder(346).append("The S3 bucket ").append(bucket).append(" does not have an object lifecycle configuration to ").append("ensure cleanup of temporary files. Consider configuring `tempdir` ").append("to point to a bucket with an object lifecycle policy that automatically ").append("deletes files after an expiration period. For more information, see ").append("https://docs.aws.amazon.com/AmazonS3/latest/dev/object-lifecycle-mgmt.html").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option.get();
                this.log().warn("An error occurred while trying to read the S3 bucket lifecycle configuration", e);
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void checkFileSystem(URI uri, Configuration hadoopConfig) {
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)hadoopConfig);
        String string = fs.getClass().getCanonicalName();
        String string2 = "org.apache.hadoop.fs.s3.S3FileSystem";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new IllegalArgumentException("spark-snowflakedb does not support the S3 Block FileSystem. Please reconfigure `tempdir` to use a s3n:// or s3a:// scheme.");
        }
    }

    public scala.collection.immutable.Map<String, String> readMapFromFile(SparkContext sc, String file) {
        FileSystem fs = FileSystem.get((URI)URI.create(file), (Configuration)sc.hadoopConfiguration());
        FSDataInputStream is = fs.open(Path.getPathWithoutSchemeAndAuthority((Path)new Path(file)));
        BufferedSource src = Source$.MODULE$.fromInputStream((InputStream)is, Codec$.MODULE$.fallbackSystemCodec());
        return this.mapFromSource((Source)src);
    }

    public scala.collection.immutable.Map<String, String> readMapFromString(String string) {
        Source src = Source$.MODULE$.fromString(string);
        return this.mapFromSource(src);
    }

    private scala.collection.immutable.Map<String, String> mapFromSource(Source src) {
        ObjectRef map = ObjectRef.create((Object)new HashMap());
        src.getLines().foreach((Function1 & Serializable)line -> {
            int index = line.indexOf(61);
            if (index < 1) {
                throw new Exception(new java.lang.StringBuilder(46).append("Can't parse the line of ").append((String)line).append(". The index of '=' is ").append(index).toString());
            }
            String key = line.substring(0, index).trim().toLowerCase();
            String value = line.substring(index + 1).trim();
            if (!key.startsWith("#")) {
                return ((HashMap)map$1.elem).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
            }
            return BoxedUnit.UNIT;
        });
        return ((HashMap)map.elem).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Parameters.MergedParameters getMergedParameters(scala.collection.immutable.Map<String, String> params) {
        scala.collection.immutable.Map lcParams = (scala.collection.immutable.Map)params.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                return new Tuple2((Object)key.toLowerCase(), (Object)value);
            }
            throw new MatchError((Object)tuple2);
        });
        return new Parameters.MergedParameters((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Parameters$.MODULE$.DEFAULT_PARAMETERS().$plus$plus((IterableOnce)lcParams)));
    }

    public Connection getJDBCConnection(scala.collection.immutable.Map<String, String> params) {
        Parameters.MergedParameters mergedParams = this.getMergedParameters(params);
        return ServerConnection$.MODULE$.getServerConnection(mergedParams, false).jdbcConnection();
    }

    public Connection getJDBCConnection(Map<String, String> params) {
        scala.collection.immutable.Map m2 = ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(params).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return this.getJDBCConnection((scala.collection.immutable.Map<String, String>)m2);
    }

    private String lastCopyUnload() {
        return lastCopyUnload;
    }

    private void lastCopyUnload_$eq(String x$1) {
        lastCopyUnload = x$1;
    }

    private String lastCopyLoad() {
        return lastCopyLoad;
    }

    private void lastCopyLoad_$eq(String x$1) {
        lastCopyLoad = x$1;
    }

    private String lastCopyLoadQueryId() {
        return lastCopyLoadQueryId;
    }

    private void lastCopyLoadQueryId_$eq(String x$1) {
        lastCopyLoadQueryId = x$1;
    }

    private String lastSelect() {
        return lastSelect;
    }

    private void lastSelect_$eq(String x$1) {
        lastSelect = x$1;
    }

    private String lastSelectQueryId() {
        return lastSelectQueryId;
    }

    private void lastSelectQueryId_$eq(String x$1) {
        lastSelectQueryId = x$1;
    }

    private String lastPutCommand() {
        return lastPutCommand;
    }

    private void lastPutCommand_$eq(String x$1) {
        lastPutCommand = x$1;
    }

    private String lastGetCommand() {
        return lastGetCommand;
    }

    private void lastGetCommand_$eq(String x$1) {
        lastGetCommand = x$1;
    }

    public void setLastCopyUnload(String select) {
        this.lastCopyUnload_$eq(select);
    }

    public String getLastCopyUnload() {
        return this.lastCopyUnload();
    }

    public void setLastSelect(String select) {
        this.lastSelect_$eq(select);
    }

    public String getLastSelect() {
        return this.lastSelect();
    }

    public void setLastSelectQueryId(String queryId) {
        this.lastSelectQueryId_$eq(queryId);
    }

    public String getLastSelectQueryId() {
        return this.lastSelectQueryId();
    }

    public void setLastCopyLoad(String select) {
        this.lastCopyLoad_$eq(select);
    }

    public String getLastCopyLoad() {
        return this.lastCopyLoad();
    }

    public void setLastCopyLoadQueryId(String queryId) {
        this.lastCopyLoadQueryId_$eq(queryId);
    }

    public String getLastCopyLoadQueryId() {
        return this.lastCopyLoadQueryId();
    }

    public void setLastPutCommand(String set) {
        this.lastPutCommand_$eq(set);
    }

    public String getLastPutCommand() {
        return this.lastPutCommand();
    }

    public void setLastGetCommand(String get) {
        this.lastGetCommand_$eq(get);
    }

    public String getLastGetCommand() {
        return this.lastGetCommand();
    }

    public Option<SnowflakeSQLStatement> genPrologueSql(Parameters.MergedParameters params) {
        Option<String> tz = params.sfTimezone();
        String timezoneSetString = "";
        if (params.isTimezoneSpark()) {
            String tzStr = TimeZone.getDefault().getID();
            timezoneSetString = new java.lang.StringBuilder(13).append("timezone = '").append(tzStr).append("'").toString();
        } else if (!params.isTimezoneSnowflake()) {
            timezoneSetString = params.isTimezoneSnowflakeDefault() ? "timezone = default" : new java.lang.StringBuilder(13).append("timezone = '").append(tz.get()).append("'").toString();
        }
        this.log().debug(new java.lang.StringBuilder(37).append("sfTimezone: '").append(tz).append("'   timezoneSetString '").append(timezoneSetString).append("'").toString());
        .colon.colon timestampFormats = new .colon.colon((Object)new Tuple2((Object)"timestamp_ntz_output_format", params.sfTimestampNTZOutputFormat().get()), (List)new .colon.colon((Object)new Tuple2((Object)"timestamp_ltz_output_format", params.sfTimestampLTZOutputFormat().get()), (List)new .colon.colon((Object)new Tuple2((Object)"timestamp_tz_output_format", params.sfTimestampTZOutputFormat().get()), (List)Nil$.MODULE$)));
        Seq timestampSettings = (Seq)timestampFormats.filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$genPrologueSql$1(params, x)));
        String timestampSetString = ((IterableOnceOps)timestampSettings.map((Function1 & Serializable)x -> new java.lang.StringBuilder(5).append(x._1()).append(" = '").append(x._2()).append("'").toString())).mkString(", ");
        if (timezoneSetString.isEmpty() && timestampSetString.isEmpty()) {
            this.log().info("Timezone and timestamp output formats are sf_current, so skip setting them.");
            return None$.MODULE$;
        }
        if (timezoneSetString.isEmpty()) {
            return new Some((Object)new ConstantString(new java.lang.StringBuilder(20).append("alter session set ").append(timestampSetString).append(" ;").toString()).$bang());
        }
        if (timestampSettings.isEmpty()) {
            return new Some((Object)new ConstantString(new java.lang.StringBuilder(20).append("alter session set ").append(timezoneSetString).append(" ;").toString()).$bang());
        }
        return new Some((Object)new ConstantString(new java.lang.StringBuilder(23).append("alter session set ").append(timezoneSetString).append(" , ").append(timestampSetString).append(" ;").toString()).$bang());
    }

    public SnowflakeSQLStatement genEpilogueSql(Parameters.MergedParameters params) {
        String timezoneUnsetString = "";
        if (!params.isTimezoneSnowflake()) {
            timezoneUnsetString = "timezone,";
        }
        return new ConstantString("alter session unset").$plus(timezoneUnsetString).$plus(new ConstantString(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |date_output_format,\n         |timestamp_ntz_output_format,\n         |timestamp_ltz_output_format,\n         |timestamp_tz_output_format;\n       "))));
    }

    public void executePreActions(JDBCWrapper jdbcWrapper, ServerConnection conn, Parameters.MergedParameters params, Option<TableName> table) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])params.preActions()), (Function1 & Serializable)action -> {
            if (action != null && !action.trim().isEmpty()) {
                String actionSql = action.contains("%s") ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(action), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{table.get()})) : action;
                MODULE$.log().info(new java.lang.StringBuilder(21).append("Executing preAction: ").append(actionSql).toString());
                return BoxesRunTime.boxToBoolean((boolean)jdbcWrapper.executePreparedInterruptibly(conn.prepareStatement(actionSql)));
            }
            return BoxedUnit.UNIT;
        });
    }

    public void executePostActions(JDBCWrapper jdbcWrapper, ServerConnection conn, Parameters.MergedParameters params, Option<TableName> table) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])params.postActions()), (Function1 & Serializable)action -> {
            if (action != null && !action.trim().isEmpty()) {
                String actionSql = action.contains("%s") ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(action), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{table.get()})) : action;
                MODULE$.log().info(new java.lang.StringBuilder(22).append("Executing postAction: ").append(actionSql).toString());
                return BoxesRunTime.boxToBoolean((boolean)jdbcWrapper.executePreparedInterruptibly(conn.prepareStatement(actionSql)));
            }
            return BoxedUnit.UNIT;
        });
    }

    public ResultSet runQuery(scala.collection.immutable.Map<String, String> params, String query) {
        java.util.List list;
        try (Connection conn = this.getJDBCConnection(params);){
            list = ((SnowflakeResultSet)conn.createStatement().executeQuery(query)).getResultSetSerializables(Long.MAX_VALUE);
        }
        java.util.List resultSerializables = list;
        Parameters.MergedParameters mergedParams = this.getMergedParameters(params);
        Properties jdbcProperties = new Properties();
        mergedParams.setJDBCProxyIfNecessary(jdbcProperties);
        return ((SnowflakeResultSetSerializable)resultSerializables.get(0)).getResultSet(SnowflakeResultSetSerializable.ResultSetRetrieveConfig.Builder.newInstance().setProxyProperties(jdbcProperties).setSfFullURL(mergedParams.sfFullURL()).build());
    }

    public ResultSet runQuery(Map<String, String> params, String query) {
        return this.runQuery((scala.collection.immutable.Map<String, String>)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(params).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), query);
    }

    public void printQuery(scala.collection.immutable.Map<String, String> params, String query) {
        System.out.println(new java.lang.StringBuilder(9).append("Running: ").append(query).toString());
        ResultSet res = this.runQuery(params, query);
        int columnCount = res.getMetaData().getColumnCount();
        int rowCnt = 0;
        while (res.next()) {
            ++rowCnt;
            StringBuilder s = package$.MODULE$.StringBuilder().newBuilder();
            s.append("| ");
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), columnCount).foreach((Function1 & Serializable)i -> Utils$.$anonfun$printQuery$1(s, res, BoxesRunTime.unboxToInt((Object)i)));
            s.append(" |");
            System.out.println(s);
        }
        System.out.println(new java.lang.StringBuilder(12).append("TOTAL: ").append(rowCnt).append(" rows").toString());
    }

    public String sanitizeQueryText(String q) {
        return new java.lang.StringBuilder(12).append("<SANITIZED> ").append(q.replaceAll("(AWS_KEY_ID|AWS_SECRET_KEY|AZURE_SAS_TOKEN)='[^']+'", "$1='\u2744\u2603\u2744\u263a\u2744\u2603\u2744'").replaceAll("(sfaccount|sfurl|sfuser|sfpassword|sfwarehouse|sfdatabase|sfschema|sfrole|awsaccesskey|awssecretkey) \"[^\"]+\"", "$1 \"\u2744\u2603\u2744\u263a\u2744\u2603\u2744\"")).toString();
    }

    public scala.collection.immutable.Map<String, String> parseMap(String source) {
        if (source == null || source.length() < 5 || !source.startsWith("Map(") || !source.endsWith(")")) {
            throw new UnsupportedOperationException("input map format is incorrect!");
        }
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])source.substring(4, source.length() - 1).split(",")), (Function1 & Serializable)x -> {
            String[] names = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x.split("->")), (Function1 & Serializable)x$8 -> x$8.trim(), ClassTag$.MODULE$.apply(String.class));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)names[0]), (Object)names[1]);
        }, ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String ensureQuoted(String name) {
        if (this.isQuoted(name)) {
            return name;
        }
        return this.quotedName(name);
    }

    public boolean isQuoted(String name) {
        return name.startsWith("\"") && name.endsWith("\"");
    }

    public String quotedName(String name) {
        if (name.matches("[_a-zA-Z]([_0-9a-zA-Z])*")) {
            return new java.lang.StringBuilder(2).append("\"").append(name.toUpperCase()).append("\"").toString();
        }
        return new java.lang.StringBuilder(2).append("\"").append(name).append("\"").toString();
    }

    public String quotedNameIgnoreCase(String name) {
        if (this.isQuoted(name)) {
            return name;
        }
        return new java.lang.StringBuilder(2).append("\"").append(name).append("\"").toString();
    }

    public boolean containVariant(StructType schema) {
        return ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> DefaultJDBCWrapper$.MODULE$.schemaConversion((StructField)field), ClassTag$.MODULE$.apply(String.class))), (Object)"VARIANT");
    }

    public scala.collection.immutable.Map<String, String> generateColumnMap(StructType from, StructType to, boolean reportError) {
        HashMap result = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap fromNameMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap toNameMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        from.foreach((Function1 & Serializable)field -> {
            Utils$.$anonfun$generateColumnMap$2(fromNameMap, to, field);
            return BoxedUnit.UNIT;
        });
        to.foreach((Function1 & Serializable)field -> {
            Utils$.$anonfun$generateColumnMap$3(toNameMap, from, field);
            return BoxedUnit.UNIT;
        });
        if (reportError && fromNameMap.size() != toNameMap.size()) {
            throw new UnsupportedOperationException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(127).append("\n             |column number of Spark Dataframe (").append(fromNameMap.size()).append(")\n             | doesn't match column number of Snowflake Table (").append(toNameMap.size()).append(")\n           ").toString())));
        }
        fromNameMap.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String index = (String)tuple2._1();
                String name = (String)tuple2._2();
                if (toNameMap.contains((Object)index)) {
                    return result.put((Object)name, toNameMap.apply((Object)index));
                }
                if (reportError) {
                    throw new UnsupportedOperationException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(64).append("\n             |can't find column ").append(name).append(" in Snowflake Table\n           ").toString())));
                }
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        return result.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public StructType removeQuote(StructType schema) {
        return new StructType((StructField[])((IterableOnceOps)schema.map((Function1 & Serializable)field -> new StructField(field.name().startsWith("\"") && field.name().endsWith("\"") ? field.name().substring(1, field.name().length() - 1) : field.name(), field.dataType(), field.nullable(), StructField$.MODULE$.apply$default$4()))).toArray(ClassTag$.MODULE$.apply(StructField.class)));
    }

    public String getSizeString(long size) {
        if (size < (long)1024) {
            return new java.lang.StringBuilder(6).append(size).append(" Bytes").toString();
        }
        if (size < (long)1024 * 1024L) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f KB"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)size / (double)1024))}));
        }
        if (size < (long)1024 * 1024L * 1024L) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f MB"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)size / (double)1024 / (double)1024))}));
        }
        if (size < (long)1024 * 1024L * 1024L * 1024L) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f GB"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)size / (double)1024 / (double)1024 / (double)1024))}));
        }
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f TB"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)size / (double)1024 / (double)1024 / (double)1024 / (double)1024))}));
    }

    public String getTimeString(long milliSeconds) {
        if (milliSeconds < 1000L) {
            return new java.lang.StringBuilder(3).append(milliSeconds).append(" ms").toString();
        }
        if (milliSeconds < 60000L) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f seconds"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)milliSeconds / (double)1000))}));
        }
        if (milliSeconds < 3600000L) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f minutes"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)milliSeconds / (double)1000 / (double)60))}));
        }
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2f hours"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)milliSeconds / (double)1000 / (double)60 / (double)60))}));
    }

    private String esc(String s) {
        return s.replace("\"", "").replace("\\", "");
    }

    public String getClientInfoString() {
        String snowflakeClientInfo = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(209).append(" {\n         | \"spark.version\" : \"").append(this.esc(org.apache.spark.package$.MODULE$.SPARK_VERSION())).append("\",\n         | \"").append(this.PROPERTY_NAME_OF_CONNECTOR_VERSION()).append("\" : \"").append(this.esc(this.VERSION())).append("\",\n         | \"spark.app.name\" : \"").append(this.esc(this.sparkAppName())).append("\",\n         | \"scala.version\" : \"").append(this.esc(this.scalaVersion())).append("\",\n         | \"java.version\" : \"").append(this.esc(this.javaVersion())).append("\",\n         | \"snowflakedb.jdbc.version\" : \"").append(this.esc(this.jdbcVersion())).append("\"\n         |}").toString()));
        return snowflakeClientInfo;
    }

    public ObjectNode getClientInfoJson() {
        return SnowflakeTelemetry$.MODULE$.getClientConfig();
    }

    public ObjectNode addVersionInfo(ObjectNode metric) {
        metric.put(TelemetryClientInfoFields$.MODULE$.SPARK_CONNECTOR_VERSION(), this.esc(this.VERSION()));
        metric.put(TelemetryClientInfoFields$.MODULE$.SPARK_VERSION(), this.esc(org.apache.spark.package$.MODULE$.SPARK_VERSION()));
        metric.put(TelemetryClientInfoFields$.MODULE$.APPLICATION_NAME(), this.esc(this.sparkAppName()));
        metric.put(TelemetryClientInfoFields$.MODULE$.SCALA_VERSION(), this.esc(this.scalaVersion()));
        metric.put(TelemetryClientInfoFields$.MODULE$.JAVA_VERSION(), this.esc(this.javaVersion()));
        metric.put(TelemetryClientInfoFields$.MODULE$.JDBC_VERSION(), this.esc(this.jdbcVersion()));
        metric.put(TelemetryClientInfoFields$.MODULE$.CERTIFIED_JDBC_VERSION(), this.esc(this.CERTIFIED_JDBC_VERSION()));
        return metric;
    }

    public void printResultSet(ResultSet rs) {
        try {
            int columnCount = rs.getMetaData().getColumnCount();
            StringBuilder sb = new StringBuilder();
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), columnCount).foreach((Function1 & Serializable)i -> sb.append(new java.lang.StringBuilder(5).append(rs.getMetaData().getColumnName(BoxesRunTime.unboxToInt((Object)i))).append("(").append(rs.getMetaData().getColumnTypeName(BoxesRunTime.unboxToInt((Object)i))).append(") | ").toString()));
            Predef$.MODULE$.println((Object)sb.toString());
            while (rs.next()) {
                sb.clear();
                RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), columnCount).foreach((Function1 & Serializable)i -> Utils$.$anonfun$printResultSet$2(sb, rs, BoxesRunTime.unboxToInt((Object)i)));
                Predef$.MODULE$.println((Object)sb.toString());
            }
        }
        catch (Throwable th) {
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(26).append("Fail to print result set: ").append(th.getMessage()).toString());
        }
    }

    public String getTableNameForExistenceCheck(String database, String schema, String name) {
        String unQuotedIdPattern = "([a-zA-Z_][\\w$]*)";
        String quotedIdPattern = "(\"([^\"]|\"\")+\")";
        String idPattern = new java.lang.StringBuilder(3).append("(").append(unQuotedIdPattern).append("|").append(quotedIdPattern).append(")").toString();
        if (name.matches(idPattern)) {
            return new java.lang.StringBuilder(2).append(this.ensureQuoted(database)).append(".").append(this.ensureQuoted(schema)).append(".").append(name).toString();
        }
        if (name.matches(new java.lang.StringBuilder(2).append(idPattern).append("\\.").append(idPattern).toString())) {
            return new java.lang.StringBuilder(1).append(this.ensureQuoted(database)).append(".").append(name).toString();
        }
        return name;
    }

    public static final /* synthetic */ boolean $anonfun$checkThatBucketHasObjectLifecycleConfiguration$2(String key$1, BucketLifecycleConfiguration.Rule rule) {
        String string = rule.getStatus();
        String string2 = "Enabled";
        return !(string != null ? !string.equals(string2) : string2 != null) && key$1.startsWith(rule.getPrefix());
    }

    public static final /* synthetic */ boolean $anonfun$genPrologueSql$1(Parameters.MergedParameters params$1, Tuple2 x) {
        return !params$1.isTimestampSnowflake((String)x._2());
    }

    public static final /* synthetic */ StringBuilder $anonfun$printQuery$1(StringBuilder s$1, ResultSet res$1, int i) {
        Object object = i > 1 ? s$1.append(" | ") : BoxedUnit.UNIT;
        return s$1.append(res$1.getString(i));
    }

    public static final /* synthetic */ boolean $anonfun$generateColumnMap$1(String name$1, StructField x$9) {
        return x$9.name().equalsIgnoreCase(name$1);
    }

    private static final boolean containsColumn$1(String name, StructType list) {
        return list.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)Utils$.$anonfun$generateColumnMap$1(name, x$9)));
    }

    public static final /* synthetic */ void $anonfun$generateColumnMap$2(HashMap fromNameMap$1, StructType to$1, StructField field) {
        Option option = fromNameMap$1.put((Object)field.name().toLowerCase(), (Object)field.name());
        if (option instanceof Some) {
            if (Utils$.containsColumn$1(field.name(), to$1)) {
                throw new UnsupportedOperationException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(81).append("\n                   |Duplicated column names in Spark DataFrame: ").append(fromNameMap$1.apply((Object)field.name().toLowerCase())).append(", ").append(field.name()).append("\n             ").toString())));
            }
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$generateColumnMap$3(HashMap toNameMap$1, StructType from$1, StructField field) {
        Option option = toNameMap$1.put((Object)field.name().toLowerCase(), (Object)field.name());
        if (option instanceof Some) {
            if (Utils$.containsColumn$1(field.name(), from$1)) {
                throw new UnsupportedOperationException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(81).append("\n                   |Duplicated column names in Snowflake table: ").append(toNameMap$1.apply((Object)field.name().toLowerCase())).append(", ").append(field.name()).append("\n             ").toString())));
            }
            return;
        }
    }

    public static final /* synthetic */ StringBuilder $anonfun$printResultSet$2(StringBuilder sb$1, ResultSet rs$1, int i) {
        return sb$1.append(rs$1.getString(i)).append(" | ");
    }

    private Utils$() {
    }
}

