/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.dom;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.css.dom.CSSStyleDeclarationImpl;
import com.gargoylesoftware.css.dom.CSSStyleSheetImpl;
import com.gargoylesoftware.css.dom.DOMExceptionImpl;
import com.gargoylesoftware.css.parser.CSSException;
import com.gargoylesoftware.css.parser.CSSOMParser;
import com.gargoylesoftware.css.parser.selector.SelectorList;
import com.gargoylesoftware.css.util.LangUtils;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class CSSStyleRuleImpl
extends AbstractCSSRuleImpl {
    private SelectorList selectors_;
    private CSSStyleDeclarationImpl style_;

    public CSSStyleRuleImpl(CSSStyleSheetImpl parentStyleSheet, AbstractCSSRuleImpl parentRule, SelectorList selectors) {
        super(parentStyleSheet, parentRule);
        this.setSelectors(selectors);
    }

    public SelectorList getSelectors() {
        return this.selectors_;
    }

    public void setSelectors(SelectorList selectors) {
        this.selectors_ = selectors;
    }

    @Override
    public String getCssText() {
        CSSStyleDeclarationImpl style = this.getStyle();
        if (null == style) {
            return "";
        }
        String selectorText = this.selectors_.toString();
        String styleText = style.toString();
        if (null == styleText || styleText.length() == 0) {
            return selectorText + " { }";
        }
        return selectorText + " { " + styleText + " }";
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            AbstractCSSRuleImpl r = parser.parseRule(cssText);
            if (!(r instanceof CSSStyleRuleImpl)) {
                throw new DOMExceptionImpl(13, 3);
            }
            this.selectors_ = ((CSSStyleRuleImpl)r).selectors_;
            this.style_ = ((CSSStyleRuleImpl)r).style_;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public String getSelectorText() {
        return this.selectors_.toString();
    }

    public void setSelectorText(String selectorText) throws DOMException {
        try {
            CSSOMParser parser = new CSSOMParser();
            this.selectors_ = parser.parseSelectors(selectorText);
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleDeclarationImpl getStyle() {
        return this.style_;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this.style_ = style;
    }

    public String toString() {
        return this.getCssText();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSStyleRuleImpl)) {
            return false;
        }
        CSSStyleRuleImpl csr = (CSSStyleRuleImpl)obj;
        return super.equals(obj) && LangUtils.equals(this.getSelectorText(), csr.getSelectorText()) && LangUtils.equals(this.getStyle(), csr.getStyle());
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = LangUtils.hashCode(hash, this.selectors_);
        hash = LangUtils.hashCode(hash, this.style_);
        return hash;
    }
}

