/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.ExpressionNode;

public class XPathException
extends TransformerException {
    protected Exception m_exception;

    public XPathException(String message, ExpressionNode ex) {
        super(message);
        this.setLocator(ex);
    }

    public XPathException(String message) {
        super(message);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (s == null) {
            s = System.err;
        }
        try {
            super.printStackTrace(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Throwable exception = this.m_exception;
        for (int i = 0; i < 10 && null != exception; ++i) {
            s.println("---------");
            exception.printStackTrace(s);
            if (exception instanceof TransformerException) {
                Exception prev = exception;
                TransformerException se = (TransformerException)exception;
                if (prev != (exception = se.getException())) continue;
                break;
            }
            exception = null;
        }
    }

    @Override
    public String getMessage() {
        String lastMessage = super.getMessage();
        Throwable exception = this.m_exception;
        while (null != exception) {
            String nextMessage = exception.getMessage();
            if (null != nextMessage) {
                lastMessage = nextMessage;
            }
            if (exception instanceof TransformerException) {
                Exception prev = exception;
                TransformerException se = (TransformerException)exception;
                if (prev != (exception = se.getException())) continue;
                break;
            }
            exception = null;
        }
        return null != lastMessage ? lastMessage : "";
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (s == null) {
            s = new PrintWriter(System.err);
        }
        try {
            super.printStackTrace(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Throwable getException() {
        return this.m_exception;
    }
}

