/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.patterns;

import javax.xml.transform.TransformerException;
import net.sourceforge.htmlunit.xpath.Expression;
import net.sourceforge.htmlunit.xpath.ExpressionOwner;
import net.sourceforge.htmlunit.xpath.XPathContext;
import net.sourceforge.htmlunit.xpath.XPathVisitor;
import net.sourceforge.htmlunit.xpath.objects.XNumber;
import net.sourceforge.htmlunit.xpath.objects.XObject;
import net.sourceforge.htmlunit.xpath.xml.dtm.DTM;

public class NodeTest
extends Expression {
    public static final String WILD = "*";
    protected int m_whatToShow;
    public static final int SHOW_BYFUNCTION = 65536;
    String m_namespace;
    protected String m_name;
    XNumber m_score;
    public static final XNumber SCORE_NODETEST = new XNumber(-0.5);
    public static final XNumber SCORE_NSWILD = new XNumber(-0.25);
    public static final XNumber SCORE_QNAME = new XNumber(0.0);
    public static final XNumber SCORE_OTHER = new XNumber(0.5);
    public static final XNumber SCORE_NONE = new XNumber(Double.NEGATIVE_INFINITY);
    private boolean m_isTotallyWild;

    public int getWhatToShow() {
        return this.m_whatToShow;
    }

    public void setWhatToShow(int what) {
        this.m_whatToShow = what;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public void setNamespace(String ns) {
        this.m_namespace = ns;
    }

    public String getLocalName() {
        return null == this.m_name ? "" : this.m_name;
    }

    public void setLocalName(String name) {
        this.m_name = name;
    }

    public NodeTest(int whatToShow, String namespace, String name) {
        this.initNodeTest(whatToShow, namespace, name);
    }

    public NodeTest(int whatToShow) {
        this.initNodeTest(whatToShow);
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        NodeTest nt = (NodeTest)expr;
        if (null != nt.m_name) {
            if (null == this.m_name) {
                return false;
            }
            if (!nt.m_name.equals(this.m_name)) {
                return false;
            }
        } else if (null != this.m_name) {
            return false;
        }
        if (null != nt.m_namespace) {
            if (null == this.m_namespace) {
                return false;
            }
            if (!nt.m_namespace.equals(this.m_namespace)) {
                return false;
            }
        } else if (null != this.m_namespace) {
            return false;
        }
        if (this.m_whatToShow != nt.m_whatToShow) {
            return false;
        }
        return this.m_isTotallyWild == nt.m_isTotallyWild;
    }

    public NodeTest() {
    }

    public void initNodeTest(int whatToShow) {
        this.m_whatToShow = whatToShow;
        this.calcScore();
    }

    public void initNodeTest(int whatToShow, String namespace, String name) {
        this.m_whatToShow = whatToShow;
        this.m_namespace = namespace;
        this.m_name = name;
        this.calcScore();
    }

    public XNumber getStaticScore() {
        return this.m_score;
    }

    public void setStaticScore(XNumber score) {
        this.m_score = score;
    }

    protected void calcScore() {
        this.m_score = this.m_namespace == null && this.m_name == null ? SCORE_NODETEST : ((this.m_namespace == WILD || this.m_namespace == null) && this.m_name == WILD ? SCORE_NODETEST : (this.m_namespace != WILD && this.m_name == WILD ? SCORE_NSWILD : SCORE_QNAME));
        this.m_isTotallyWild = this.m_namespace == null && this.m_name == WILD;
    }

    public static int getNodeTypeTest(int whatToShow) {
        if (0 != (whatToShow & 1)) {
            return 1;
        }
        if (0 != (whatToShow & 2)) {
            return 2;
        }
        if (0 != (whatToShow & 4)) {
            return 3;
        }
        if (0 != (whatToShow & 0x100)) {
            return 9;
        }
        if (0 != (whatToShow & 0x400)) {
            return 11;
        }
        if (0 != (whatToShow & 0x1000)) {
            return 13;
        }
        if (0 != (whatToShow & 0x80)) {
            return 8;
        }
        if (0 != (whatToShow & 0x40)) {
            return 7;
        }
        if (0 != (whatToShow & 0x200)) {
            return 10;
        }
        if (0 != (whatToShow & 0x20)) {
            return 6;
        }
        if (0 != (whatToShow & 0x10)) {
            return 5;
        }
        if (0 != (whatToShow & 0x800)) {
            return 12;
        }
        if (0 != (whatToShow & 8)) {
            return 4;
        }
        return 0;
    }

    private static boolean subPartMatch(String p, String t) {
        return p == t || null != p && (t == WILD || p.equals(t));
    }

    private static boolean subPartMatchNS(String p, String t) {
        return p == t || null != p && (p.length() > 0 ? t == WILD || p.equals(t) : null == t);
    }

    @Override
    public XObject execute(XPathContext xctxt, int context) throws TransformerException {
        DTM dtm = xctxt.getDTM(context);
        short nodeType = dtm.getNodeType(context);
        if (this.m_whatToShow == -1) {
            return this.m_score;
        }
        int nodeBit = this.m_whatToShow & 1 << nodeType - 1;
        switch (nodeBit) {
            case 256: 
            case 1024: {
                return SCORE_OTHER;
            }
            case 128: {
                return this.m_score;
            }
            case 4: 
            case 8: {
                return this.m_score;
            }
            case 64: {
                return NodeTest.subPartMatch(dtm.getNodeName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 4096: {
                String ns = dtm.getLocalName(context);
                return NodeTest.subPartMatch(ns, this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 1: 
            case 2: {
                return this.m_isTotallyWild || NodeTest.subPartMatchNS(dtm.getNamespaceURI(context), this.m_namespace) && NodeTest.subPartMatch(dtm.getLocalName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
        }
        return SCORE_NONE;
    }

    @Override
    public XObject execute(XPathContext xctxt, int context, DTM dtm, int expType) throws TransformerException {
        if (this.m_whatToShow == -1) {
            return this.m_score;
        }
        int nodeBit = this.m_whatToShow & 1 << dtm.getNodeType(context) - 1;
        switch (nodeBit) {
            case 256: 
            case 1024: {
                return SCORE_OTHER;
            }
            case 128: {
                return this.m_score;
            }
            case 4: 
            case 8: {
                return this.m_score;
            }
            case 64: {
                return NodeTest.subPartMatch(dtm.getNodeName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 4096: {
                String ns = dtm.getLocalName(context);
                return NodeTest.subPartMatch(ns, this.m_name) ? this.m_score : SCORE_NONE;
            }
            case 1: 
            case 2: {
                return this.m_isTotallyWild || NodeTest.subPartMatchNS(dtm.getNamespaceURI(context), this.m_namespace) && NodeTest.subPartMatch(dtm.getLocalName(context), this.m_name) ? this.m_score : SCORE_NONE;
            }
        }
        return SCORE_NONE;
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        return this.execute(xctxt, xctxt.getCurrentNode());
    }

    @Override
    public void callVisitors(ExpressionOwner owner, XPathVisitor visitor) {
        this.assertion(false, "callVisitors should not be called for this object!!!");
    }
}

