/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.Cell;
import jxl.CellFeatures;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.biff.XFRecord;
import jxl.format.CellFormat;
import jxl.read.biff.CellFeaturesAccessor;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.Record;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SheetImpl;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public abstract class CellValue
extends RecordData
implements Cell,
CellFeaturesAccessor {
    private static Log logger = Logging.getLog(CellValue.class);
    private int row;
    private int column;
    private int xfIndex;
    private FormattingRecords formattingRecords;
    private boolean initialized;
    private XFRecord format;
    private SheetImpl sheet;
    private CellFeatures features;

    protected CellValue(Record t, FormattingRecords fr, SheetImpl si) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.row = IntegerHelper.getInt(data[0], data[1]);
        this.column = IntegerHelper.getInt(data[2], data[3]);
        this.xfIndex = IntegerHelper.getInt(data[4], data[5]);
        this.sheet = si;
        this.formattingRecords = fr;
        this.initialized = false;
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public final int getXFIndex() {
        return this.xfIndex;
    }

    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.format = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.format;
    }

    public boolean isHidden() {
        ColumnInfoRecord cir = this.sheet.getColumnInfo(this.column);
        if (cir != null && (cir.getWidth() == 0 || cir.getHidden())) {
            return true;
        }
        RowRecord rr = this.sheet.getRowInfo(this.row);
        return rr != null && (rr.getRowHeight() == 0 || rr.isCollapsed());
    }

    protected SheetImpl getSheet() {
        return this.sheet;
    }

    public CellFeatures getCellFeatures() {
        return this.features;
    }

    public void setCellFeatures(CellFeatures cf) {
        if (this.features != null) {
            logger.warn((Object)"current cell features not null - overwriting", new Object[0]);
        }
        this.features = cf;
    }
}

