/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.ErrorFormulaCell;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.FormulaErrorCode;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.write.biff.ReadFormulaRecord;
import jxl.write.biff.WritableWorkbookImpl;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

class ReadErrorFormulaRecord
extends ReadFormulaRecord
implements ErrorFormulaCell {
    private static Log logger = Logging.getLog(ReadErrorFormulaRecord.class);

    public ReadErrorFormulaRecord(FormulaData f) {
        super(f);
    }

    public int getErrorCode() {
        return ((ErrorFormulaCell)((Object)this.getReadFormula())).getErrorCode();
    }

    protected byte[] handleFormulaException() {
        byte[] expressiondata = null;
        byte[] celldata = super.getCellData();
        int errorCode = this.getErrorCode();
        String formulaString = null;
        formulaString = errorCode == FormulaErrorCode.DIV0.getCode() ? "1/0" : (errorCode == FormulaErrorCode.VALUE.getCode() ? "\"\"/0" : (errorCode == FormulaErrorCode.REF.getCode() ? "\"#REF!\"" : "\"ERROR\""));
        WritableWorkbookImpl w = this.getSheet().getWorkbook();
        FormulaParser parser = new FormulaParser(formulaString, w, w, w.getSettings());
        try {
            parser.parse();
        }
        catch (FormulaException e2) {
            logger.warn((Object)e2.getMessage(), new Object[0]);
        }
        byte[] formulaBytes = parser.getBytes();
        expressiondata = new byte[formulaBytes.length + 16];
        IntegerHelper.getTwoBytes(formulaBytes.length, expressiondata, 14);
        System.arraycopy(formulaBytes, 0, expressiondata, 16, formulaBytes.length);
        expressiondata[8] = (byte)(expressiondata[8] | 2);
        byte[] data = new byte[celldata.length + expressiondata.length];
        System.arraycopy(celldata, 0, data, 0, celldata.length);
        System.arraycopy(expressiondata, 0, data, celldata.length, expressiondata.length);
        data[6] = 2;
        data[12] = -1;
        data[13] = -1;
        data[8] = (byte)errorCode;
        return data;
    }
}

