/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameters;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.Dimensionable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;

public class DumpFacade
extends JavaParserVisitorAdapter {
    private PrintWriter writer;
    private boolean recurse;

    public void initializeWith(Writer writer, String prefix, boolean recurse, JavaNode node) {
        this.writer = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        this.recurse = recurse;
        this.visit(node, (Object)prefix);
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem flushing PrintWriter.", e);
        }
    }

    @Override
    public Object visit(JavaNode node, Object data) {
        this.dump(node, (String)data);
        if (this.recurse) {
            return super.visit(node, (Object)(data + " "));
        }
        return data;
    }

    private void dump(JavaNode node, String prefix) {
        Dimensionable dimensionable;
        ASTPrimarySuffix primarySuffix;
        this.writer.print(prefix);
        this.writer.print(node.toString());
        String image = node.getImage();
        if (node instanceof ASTBooleanLiteral) {
            image = String.valueOf(((ASTBooleanLiteral)node).isTrue());
        } else if (node instanceof ASTPrimaryPrefix) {
            ASTPrimaryPrefix primaryPrefix = (ASTPrimaryPrefix)node;
            String result = null;
            if (primaryPrefix.usesSuperModifier()) {
                result = "super";
            } else if (primaryPrefix.usesThisModifier()) {
                result = "this";
            }
            if (image != null) {
                result = result + "." + image;
            }
            image = result;
        } else if (node instanceof ASTPrimarySuffix && (primarySuffix = (ASTPrimarySuffix)node).isArrayDereference()) {
            image = image == null ? "[" : "[" + image;
        }
        ArrayList<String> extras = new ArrayList<String>();
        this.collectModifiers(node, extras);
        if (node instanceof Dimensionable && (dimensionable = (Dimensionable)((Object)node)).isArray()) {
            StringBuilder stringBuilder = new StringBuilder("array");
            for (int i = 0; i < dimensionable.getArrayDepth(); ++i) {
                stringBuilder.append('[');
            }
            extras.add(stringBuilder.toString());
        }
        if (node instanceof ASTArguments) {
            extras.add(String.valueOf(((ASTArguments)node).getArgumentCount()));
        } else if (node instanceof ASTAssignmentOperator) {
            extras.add(((ASTAssignmentOperator)node).isCompound() ? "compound" : "simple");
        } else if (node instanceof ASTClassOrInterfaceBodyDeclaration) {
            if (((ASTClassOrInterfaceBodyDeclaration)node).isAnonymousInnerClass()) {
                extras.add("anonymous inner class");
            }
            if (((ASTClassOrInterfaceBodyDeclaration)node).isEnumChild()) {
                extras.add("enum child");
            }
        } else if (node instanceof ASTBlock) {
            if (((ASTBlock)node).containsComment()) {
                extras.add("contains comment");
            }
        } else if (node instanceof ASTClassOrInterfaceDeclaration) {
            extras.add(((ASTClassOrInterfaceDeclaration)node).isInterface() ? "interface" : "class");
            if (((ASTClassOrInterfaceDeclaration)node).isNested()) {
                extras.add("nested");
            }
        } else if (node instanceof ASTConditionalExpression) {
            if (((ASTConditionalExpression)node).isTernary()) {
                extras.add("ternary");
            }
        } else if (node instanceof ASTConstructorDeclaration) {
            extras.add(String.valueOf(((ASTConstructorDeclaration)node).getParameterCount()));
            if (((ASTConstructorDeclaration)node).containsComment()) {
                extras.add("contains comment");
            }
        } else if (node instanceof ASTExplicitConstructorInvocation) {
            extras.add(String.valueOf(((ASTExplicitConstructorInvocation)node).getArgumentCount()));
            if (((ASTExplicitConstructorInvocation)node).isThis()) {
                extras.add("this");
            }
            if (((ASTExplicitConstructorInvocation)node).isSuper()) {
                extras.add("super");
            }
        } else if (node instanceof ASTFormalParameter) {
            if (((ASTFormalParameter)node).isVarargs()) {
                extras.add("varargs");
            }
        } else if (node instanceof ASTFormalParameters) {
            extras.add(String.valueOf(((ASTFormalParameters)node).getParameterCount()));
        } else if (node instanceof ASTIfStatement) {
            if (((ASTIfStatement)node).hasElse()) {
                extras.add("has else");
            }
        } else if (node instanceof ASTImportDeclaration) {
            if (((ASTImportDeclaration)node).isImportOnDemand()) {
                extras.add("on demand");
            }
            if (((ASTImportDeclaration)node).isStatic()) {
                extras.add("static");
            }
        } else if (node instanceof ASTInitializer) {
            extras.add(((ASTInitializer)node).isStatic() ? "static" : "nonstatic");
        } else if (node instanceof ASTLiteral) {
            ASTLiteral literal = (ASTLiteral)node;
            if (literal.isCharLiteral()) {
                extras.add("char style");
            }
            if (literal.isIntLiteral()) {
                extras.add("int style");
            }
            if (literal.isFloatLiteral()) {
                extras.add("float style");
            }
            if (literal.isStringLiteral()) {
                extras.add("String style");
            }
            if (literal.isDoubleLiteral()) {
                extras.add("double style");
            }
            if (literal.isLongLiteral()) {
                extras.add("long style");
            }
        } else if (node instanceof ASTResultType) {
            if (((ASTResultType)node).isVoid()) {
                extras.add("void");
            }
            if (((ASTResultType)node).returnsArray()) {
                extras.add("returns array");
            }
        } else if (node instanceof ASTSwitchLabel) {
            if (((ASTSwitchLabel)node).isDefault()) {
                extras.add("default");
            }
        } else if (node instanceof ASTTryStatement && ((ASTTryStatement)node).hasFinally()) {
            extras.add("has finally");
        }
        if (image != null || !extras.isEmpty()) {
            this.writer.print(':');
            if (image != null) {
                this.writer.print(image);
            }
            for (String string : extras) {
                this.writer.print('(');
                this.writer.print(string);
                this.writer.print(')');
            }
        }
        this.writer.println();
    }

    private void collectModifiers(JavaNode node, List<String> extras) {
        if (node instanceof AccessNode) {
            AccessNode accessNode = (AccessNode)((Object)node);
            if (accessNode.isPackagePrivate()) {
                extras.add("package private");
            }
            if (accessNode.isPrivate()) {
                extras.add("private");
            }
            if (accessNode.isPublic()) {
                extras.add("public");
            }
            if (accessNode.isProtected()) {
                extras.add("protected");
            }
            if (accessNode.isAbstract()) {
                extras.add("abstract");
            }
            if (accessNode.isStatic()) {
                extras.add("static");
            }
            if (accessNode.isFinal()) {
                extras.add("final");
            }
            if (accessNode.isSynchronized()) {
                extras.add("synchronized");
            }
            if (accessNode.isNative()) {
                extras.add("native");
            }
            if (accessNode.isStrictfp()) {
                extras.add("strict");
            }
            if (accessNode.isTransient()) {
                extras.add("transient");
            }
            if (accessNode.isDefault()) {
                extras.add("default");
            }
        }
    }
}

