/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symboltable;

import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.symboltable.NameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import net.sourceforge.pmd.util.SearchFunction;

public class DeclarationFinderFunction
implements SearchFunction<NameDeclaration> {
    private NameOccurrence occurrence;
    private NameDeclaration decl;

    public DeclarationFinderFunction(NameOccurrence occurrence) {
        this.occurrence = occurrence;
    }

    public boolean applyTo(NameDeclaration nameDeclaration) {
        if (this.occurrence.getLocation() instanceof ASTMethodReference) {
            return false;
        }
        if (this.isDeclaredBefore(nameDeclaration) && this.isSameName(nameDeclaration)) {
            this.decl = nameDeclaration;
            return false;
        }
        return true;
    }

    private boolean isDeclaredBefore(NameDeclaration nameDeclaration) {
        if (nameDeclaration.getNode() != null && this.occurrence.getLocation() != null) {
            return nameDeclaration.getNode().getBeginLine() <= this.occurrence.getLocation().getBeginLine();
        }
        return true;
    }

    private boolean isSameName(NameDeclaration nameDeclaration) {
        return this.occurrence.getImage().equals(nameDeclaration.getName());
    }

    public NameDeclaration getDecl() {
        return this.decl;
    }
}

