/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAdditiveExpression;
import net.sourceforge.pmd.lang.java.ast.ASTAllocationExpression;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArguments;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTMultiplicativeExpression;
import net.sourceforge.pmd.lang.java.ast.ASTName;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimarySuffix;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabeledBlock;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabeledExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitorAdapter;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.rule.performance.ConsecutiveLiteralAppendsRule;
import net.sourceforge.pmd.lang.java.rule.performance.InefficientStringBufferingRule;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;
import org.apache.commons.lang3.mutable.MutableInt;

public class InsufficientStringBufferDeclarationRule
extends AbstractJavaRule {
    private static final Set<Class<? extends Node>> BLOCK_PARENTS = new HashSet<Class<? extends Node>>();
    public static final int DEFAULT_BUFFER_SIZE = 16;

    public InsufficientStringBufferDeclarationRule() {
        this.addRuleChainVisit(ASTVariableDeclaratorId.class);
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (node.getNameDeclaration() == null || !ConsecutiveLiteralAppendsRule.isStringBuilderOrBuffer(node)) {
            return data;
        }
        JavaNode rootNode = node;
        int anticipatedLength = 0;
        int constructorLength = 16;
        constructorLength = this.getConstructorLength((Node)node, constructorLength);
        anticipatedLength = this.getInitialLength((Node)node);
        if (anticipatedLength > 0) {
            constructorLength = anticipatedLength + 16;
        }
        anticipatedLength += this.getConstructorAppendsLength((Node)node);
        List<NameOccurrence> usage = node.getUsages();
        HashMap<Node, Map<Node, Integer>> blocks = new HashMap<Node, Map<Node, Integer>>();
        for (NameOccurrence no : usage) {
            JavaNameOccurrence jno = (JavaNameOccurrence)no;
            JavaNode n = jno.getLocation();
            if (!InefficientStringBufferingRule.isInStringBufferOperationChain((Node)n, "append")) {
                if (!jno.isOnLeftHandSide() && !InefficientStringBufferingRule.isInStringBufferOperationChain((Node)n, "setLength") && !InefficientStringBufferingRule.isInStringBufferOperationChain((Node)n, "ensureCapacity")) continue;
                if (n.getImage().endsWith("setLength")) {
                    int newLength = this.getConstructorLength((Node)n, 0);
                    if (newLength > constructorLength) {
                        constructorLength = newLength;
                        rootNode = n;
                    }
                    anticipatedLength = newLength;
                } else if (n.getImage().endsWith("ensureCapacity")) {
                    int newCapacity = this.getConstructorLength((Node)n, 0);
                    if (newCapacity > constructorLength) {
                        constructorLength = newCapacity;
                        rootNode = n;
                    }
                } else {
                    if (constructorLength != -1 && anticipatedLength > constructorLength) {
                        this.reportViolation(data, node, (Node)rootNode, constructorLength, anticipatedLength += this.processBlocks(blocks));
                    }
                    constructorLength = this.getConstructorLength((Node)n, 16);
                    rootNode = n;
                    anticipatedLength = this.getInitialLength((Node)n);
                    if (anticipatedLength > 0) {
                        constructorLength = anticipatedLength + 16;
                    }
                    anticipatedLength += this.getConstructorAppendsLength((Node)n);
                }
                if (constructorLength == -1 || anticipatedLength <= constructorLength) continue;
                this.reportViolation(data, node, (Node)rootNode, constructorLength, anticipatedLength += this.processBlocks(blocks));
                continue;
            }
            ASTPrimaryExpression s = (ASTPrimaryExpression)n.getFirstParentOfType(ASTPrimaryExpression.class);
            int numChildren = s.getNumChildren();
            for (int jx = 0; jx < numChildren; ++jx) {
                Node sn = s.getChild(jx);
                if (!(sn instanceof ASTPrimarySuffix) || sn.getImage() != null) continue;
                int thisSize = 0;
                Node block = this.getFirstParentBlock(sn);
                thisSize = this.isAdditive(sn) ? this.processAdditive(sn) : this.processNode(sn);
                if (block != null) {
                    this.storeBlockStatistics(blocks, thisSize, block);
                    continue;
                }
                anticipatedLength += thisSize;
            }
        }
        if (constructorLength != -1 && (anticipatedLength += this.processBlocks(blocks)) > constructorLength) {
            this.reportViolation(data, node, (Node)rootNode, constructorLength, anticipatedLength);
        }
        return data;
    }

    private void reportViolation(Object data, ASTVariableDeclaratorId instance, Node reportNode, int capacity, int anticipatedLength) {
        String typeName = "StringBuilder";
        if (instance.getType() != null) {
            typeName = instance.getType().getSimpleName();
        }
        this.addViolation(data, reportNode, new Object[]{typeName, capacity, anticipatedLength});
    }

    private void storeBlockStatistics(Map<Node, Map<Node, Integer>> blocks, int thisSize, Node block) {
        Integer x;
        Map<Node, Integer> thisBranch;
        Node statement = block.getParent();
        if (block.getParent() instanceof ASTIfStatement) {
            Node possibleStatement = (Node)statement.getFirstParentOfType(ASTIfStatement.class);
            while (possibleStatement instanceof ASTIfStatement) {
                statement = possibleStatement;
                possibleStatement = (Node)possibleStatement.getFirstParentOfType(ASTIfStatement.class);
            }
        }
        if ((thisBranch = blocks.get(statement)) == null) {
            thisBranch = new HashMap<Node, Integer>();
            blocks.put(statement, thisBranch);
        }
        if ((x = thisBranch.get(block)) != null) {
            thisSize += x.intValue();
        }
        thisBranch.put(statement, thisSize);
    }

    private int processBlocks(Map<Node, Map<Node, Integer>> blocks) {
        int anticipatedLength = 0;
        int ifLength = 0;
        for (Map.Entry<Node, Map<Node, Integer>> entry : blocks.entrySet()) {
            ifLength = 0;
            for (Map.Entry<Node, Integer> entry2 : entry.getValue().entrySet()) {
                Integer value = entry2.getValue();
                ifLength = Math.max(ifLength, value);
            }
            anticipatedLength += ifLength;
        }
        return anticipatedLength;
    }

    private int processAdditive(Node sn) {
        ASTAdditiveExpression additive = (ASTAdditiveExpression)sn.getFirstDescendantOfType(ASTAdditiveExpression.class);
        if (additive == null) {
            return 0;
        }
        int anticipatedLength = 0;
        for (int ix = 0; ix < additive.getNumChildren(); ++ix) {
            Node childNode = additive.getChild(ix);
            ASTLiteral literal = (ASTLiteral)childNode.getFirstDescendantOfType(ASTLiteral.class);
            if (literal == null || literal.getImage() == null) continue;
            anticipatedLength += literal.getImage().length() - 2;
        }
        return anticipatedLength;
    }

    private static boolean isStringOrCharLiteral(ASTLiteral literal) {
        return literal.isStringLiteral() || literal.isCharLiteral();
    }

    private int processNode(Node sn) {
        ASTPrimaryPrefix xn;
        int anticipatedLength = 0;
        if (sn != null && (xn = (ASTPrimaryPrefix)sn.getFirstDescendantOfType(ASTPrimaryPrefix.class)) != null && xn.getNumChildren() != 0 && xn.getChild(0) instanceof ASTLiteral) {
            ASTLiteral literal = (ASTLiteral)xn.getChild(0);
            String str = ((JavaNode)xn.getChild(0)).getImage();
            if (str != null) {
                JavaNode parentNode;
                anticipatedLength = literal.isStringLiteral() ? (anticipatedLength += str.length() - 2) : (literal.isCharLiteral() ? ++anticipatedLength : (literal.isIntLiteral() ? ((parentNode = ((JavaNode)literal.getParent()).getParent().getParent()) instanceof ASTCastExpression && ((ASTCastExpression)parentNode).getType() == Character.TYPE ? ++anticipatedLength : (anticipatedLength += String.valueOf(literal.getValueAsLong()).length())) : (literal.isLongLiteral() ? (anticipatedLength += String.valueOf(literal.getValueAsLong()).length()) : (anticipatedLength += str.length()))));
            }
        }
        return anticipatedLength;
    }

    private int getConstructorLength(Node node, int constructorLength) {
        ASTArgumentList argumentList;
        int iConstructorLength = constructorLength;
        Node block = (Node)node.getFirstParentOfType(ASTBlockStatement.class);
        if (block == null) {
            block = (Node)node.getFirstParentOfType(ASTFieldDeclaration.class);
        }
        if (block == null) {
            block = (Node)node.getFirstParentOfType(ASTFormalParameter.class);
            if (block != null) {
                iConstructorLength = -1;
            } else {
                return 16;
            }
        }
        if ((argumentList = (ASTArgumentList)block.getFirstDescendantOfType(ASTArgumentList.class)) != null) {
            List name = argumentList.findDescendantsOfType(ASTName.class);
            iConstructorLength = !name.isEmpty() ? -1 : this.calculateExpression(argumentList);
        }
        if (iConstructorLength == 0) {
            iConstructorLength = constructorLength == -1 ? 16 : constructorLength;
        }
        return iConstructorLength;
    }

    private int calculateExpression(ASTArgumentList argumentList) {
        if (argumentList == null) {
            return -1;
        }
        ASTExpression expr = (ASTExpression)argumentList.getFirstChildOfType(ASTExpression.class);
        if (expr == null) {
            return -1;
        }
        MutableInt result = new MutableInt(0);
        class ExpressionVisitor
        extends JavaParserVisitorAdapter {
            ExpressionVisitor() {
            }

            @Override
            public Object visit(ASTExpression node, Object data) {
                ((JavaNode)node.getChild(0)).jjtAccept(this, data);
                return data;
            }

            @Override
            public Object visit(ASTAdditiveExpression node, Object data) {
                MutableInt partSum = new MutableInt(0);
                for (JavaNode child : node.children()) {
                    MutableInt part = new MutableInt();
                    child.jjtAccept(this, part);
                    partSum.add((Number)part.getValue());
                }
                ((MutableInt)data).setValue((Number)partSum.getValue());
                return data;
            }

            @Override
            public Object visit(ASTMultiplicativeExpression node, Object data) {
                MutableInt partResult = new MutableInt(1);
                for (JavaNode child : node.children()) {
                    MutableInt part = new MutableInt(0);
                    child.jjtAccept(this, part);
                    partResult.setValue(partResult.getValue() * part.getValue());
                }
                ((MutableInt)data).setValue((Number)partResult.getValue());
                return data;
            }

            @Override
            public Object visit(ASTLiteral node, Object data) {
                ((MutableInt)data).setValue(node.getValueAsInt());
                return data;
            }
        }
        expr.jjtAccept(new ExpressionVisitor(), result);
        return result.getValue();
    }

    private int getInitialLength(Node node) {
        ASTLiteral literal;
        String str;
        ASTAllocationExpression allocation;
        Node block = (Node)node.getFirstParentOfType(ASTBlockStatement.class);
        if (block == null && (block = (Node)node.getFirstParentOfType(ASTFieldDeclaration.class)) == null) {
            block = (Node)node.getFirstParentOfType(ASTFormalParameter.class);
        }
        if ((allocation = (ASTAllocationExpression)block.getFirstDescendantOfType(ASTAllocationExpression.class)) == null) {
            return 0;
        }
        List literals = allocation.findDescendantsOfType(ASTLiteral.class);
        if (literals.size() == 1 && (str = (literal = (ASTLiteral)literals.get(0)).getImage()) != null && InsufficientStringBufferDeclarationRule.isStringOrCharLiteral(literal)) {
            return str.length() - 2;
        }
        return 0;
    }

    private int getConstructorAppendsLength(Node node) {
        Node block = (Node)node.getFirstParentOfType(ASTBlockStatement.class);
        if (block == null && (block = (Node)node.getFirstParentOfType(ASTFieldDeclaration.class)) == null) {
            block = (Node)node.getFirstParentOfType(ASTFormalParameter.class);
        }
        int size = 0;
        List arguments = block.findDescendantsOfType(ASTArguments.class);
        for (ASTArguments arg : arguments) {
            if (arg.getParent() instanceof ASTAllocationExpression) continue;
            size += this.processNode((Node)arg);
        }
        return size;
    }

    private boolean isAdditive(Node n) {
        ASTAdditiveExpression add = (ASTAdditiveExpression)n.getFirstDescendantOfType(ASTAdditiveExpression.class);
        return add != null && add.getNthParent(4) == n;
    }

    private Node getFirstParentBlock(Node node) {
        Node parentNode;
        Node lastNode = node;
        for (parentNode = node.getParent(); parentNode != null && !BLOCK_PARENTS.contains(parentNode.getClass()); parentNode = parentNode.getParent()) {
            lastNode = parentNode;
        }
        if (parentNode instanceof ASTIfStatement) {
            parentNode = lastNode;
        } else if (parentNode instanceof ASTSwitchStatement) {
            parentNode = InsufficientStringBufferDeclarationRule.getSwitchParent(parentNode, lastNode);
        }
        return parentNode;
    }

    private static Node getSwitchParent(Node parentNode, Node lastNode) {
        int allChildren = parentNode.getNumChildren();
        ASTSwitchLabel label = null;
        for (int ix = 0; ix < allChildren; ++ix) {
            Node n = parentNode.getChild(ix);
            if (n instanceof ASTSwitchLabel) {
                label = (ASTSwitchLabel)n;
                continue;
            }
            if (!n.equals(lastNode)) continue;
            parentNode = label;
            break;
        }
        return parentNode;
    }

    static {
        BLOCK_PARENTS.add(ASTIfStatement.class);
        BLOCK_PARENTS.add(ASTSwitchStatement.class);
        BLOCK_PARENTS.add(ASTSwitchLabeledBlock.class);
        BLOCK_PARENTS.add(ASTSwitchLabeledExpression.class);
    }
}

