/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.internal.ImportWrapper;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

@Deprecated
public class DuplicateImportsRule
extends AbstractJavaRule {
    private static final Logger LOG = Logger.getLogger(DuplicateImportsRule.class.getName());
    private Set<ImportWrapper> singleTypeImports;
    private Set<ImportWrapper> importOnDemandImports;

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.singleTypeImports = new HashSet<ImportWrapper>();
        this.importOnDemandImports = new HashSet<ImportWrapper>();
        super.visit(node, data);
        for (ImportWrapper thisImportOnDemand : this.importOnDemandImports) {
            for (ImportWrapper thisSingleTypeImport : this.singleTypeImports) {
                String singleTypeFullName = thisSingleTypeImport.getFullName();
                String singleTypePkg = thisSingleTypeImport.getPackageName();
                String singleTypeName = thisSingleTypeImport.getName();
                if (!thisImportOnDemand.getFullName().equals(singleTypePkg) || this.isDisambiguationImport(node, singleTypePkg, singleTypeName)) continue;
                this.addViolation(data, (Node)thisSingleTypeImport.getNode(), singleTypeFullName);
            }
        }
        this.singleTypeImports.clear();
        this.importOnDemandImports.clear();
        return data;
    }

    private boolean isDisambiguationImport(ASTCompilationUnit node, String singleTypePkg, String singleTypeName) {
        for (ImportWrapper thisImportOnDemand : this.importOnDemandImports) {
            if (thisImportOnDemand.getFullName().equals(singleTypePkg)) continue;
            if (!thisImportOnDemand.isStaticOnDemand()) {
                String fullyQualifiedClassName = thisImportOnDemand.getFullName() + "." + singleTypeName;
                if (!node.getClassTypeResolver().classNameExists(fullyQualifiedClassName)) continue;
                return true;
            }
            Class<?> importClass = node.getClassTypeResolver().loadClassOrNull(thisImportOnDemand.getFullName());
            if (importClass == null) continue;
            try {
                for (Method m : importClass.getMethods()) {
                    if (!Modifier.isStatic(m.getModifiers()) || !m.getName().equals(singleTypeName)) continue;
                    return true;
                }
            }
            catch (LinkageError e) {
                LOG.log(Level.FINE, "Possible incomplete auxclasspath: Error while processing methods", e);
            }
        }
        String fullyQualifiedClassName = "java.lang." + singleTypeName;
        return node.getClassTypeResolver().classNameExists(fullyQualifiedClassName);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object data) {
        ImportWrapper wrapper = new ImportWrapper(node);
        if (node.isImportOnDemand()) {
            if (this.importOnDemandImports.contains(wrapper)) {
                this.addViolation(data, (Node)node, node.getImportedName());
            } else {
                this.importOnDemandImports.add(wrapper);
            }
        } else if (this.singleTypeImports.contains(wrapper)) {
            this.addViolation(data, (Node)node, node.getImportedName());
        } else {
            this.singleTypeImports.add(wrapper);
        }
        return data;
    }
}

