/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBody;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractLombokAwareRule;
import net.sourceforge.pmd.lang.java.symboltable.JavaNameOccurrence;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class ImmutableFieldRule
extends AbstractLombokAwareRule {
    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Object result = super.visit(node, data);
        Map vars = node.getScope().getDeclarations(VariableNameDeclaration.class);
        Set<ASTConstructorDeclaration> constructors = Collections.unmodifiableSet(new HashSet<ASTConstructorDeclaration>(this.findAllConstructors(node)));
        for (Map.Entry entry : vars.entrySet()) {
            List usages;
            VariableNameDeclaration field = (VariableNameDeclaration)entry.getKey();
            AccessNode accessNodeParent = field.getAccessNodeParent();
            if (accessNodeParent.isStatic() || !accessNodeParent.isPrivate() || accessNodeParent.isFinal() || accessNodeParent.isVolatile() || this.hasLombokAnnotation(node) || this.hasIgnoredAnnotation((Annotatable)((Object)accessNodeParent)) || !this.isImmutableField(field, usages = (List)entry.getValue(), constructors)) continue;
            this.addViolation(data, (Node)field.getNode(), field.getImage());
        }
        return result;
    }

    private boolean initializedWhenDeclared(VariableNameDeclaration field) {
        return field.getAccessNodeParent().hasDescendantOfType(ASTVariableInitializer.class);
    }

    private boolean isImmutableField(VariableNameDeclaration field, List<NameOccurrence> usages, Set<ASTConstructorDeclaration> allConstructors) {
        HashSet<ASTConstructorDeclaration> consSet = new HashSet<ASTConstructorDeclaration>();
        for (NameOccurrence occ : usages) {
            JavaNameOccurrence jocc = (JavaNameOccurrence)occ;
            if (!jocc.isOnLeftHandSide() && !jocc.isSelfAssignment()) continue;
            JavaNode node = jocc.getLocation();
            ASTConstructorDeclaration constructor = (ASTConstructorDeclaration)node.getFirstParentOfType(ASTConstructorDeclaration.class);
            if (constructor != null && this.isSameClass(field, constructor)) {
                if (this.inLoopOrTry((Node)node)) {
                    return false;
                }
                if (this.inAnonymousInnerClass((Node)node) || this.isInLambda((Node)node)) {
                    return false;
                }
                consSet.add(constructor);
                continue;
            }
            return false;
        }
        return (allConstructors.equals(consSet) && !allConstructors.isEmpty()) ^ this.initializedWhenDeclared(field);
    }

    private boolean isInLambda(Node node) {
        return node.getFirstParentOfType(ASTLambdaExpression.class) != null;
    }

    private boolean isSameClass(VariableNameDeclaration field, ASTConstructorDeclaration constructor) {
        return constructor.getFirstParentOfType(ASTClassOrInterfaceBody.class) == field.getNode().getFirstParentOfType(ASTClassOrInterfaceBody.class);
    }

    private boolean inLoopOrTry(Node node) {
        return node.getFirstParentOfType(ASTTryStatement.class) != null || node.getFirstParentOfType(ASTForStatement.class) != null || node.getFirstParentOfType(ASTWhileStatement.class) != null || node.getFirstParentOfType(ASTDoStatement.class) != null;
    }

    private boolean inAnonymousInnerClass(Node node) {
        ASTClassOrInterfaceBodyDeclaration parent = (ASTClassOrInterfaceBodyDeclaration)node.getFirstParentOfType(ASTClassOrInterfaceBodyDeclaration.class);
        return parent != null && parent.isAnonymousInnerClass();
    }

    private List<ASTConstructorDeclaration> findAllConstructors(ASTClassOrInterfaceDeclaration node) {
        return ((ASTClassOrInterfaceBody)node.getFirstChildOfType(ASTClassOrInterfaceBody.class)).findDescendantsOfType(ASTConstructorDeclaration.class);
    }
}

