/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.TestFrameworksUtil;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class JUnitTestContainsTooManyAssertsRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Integer> MAX_ASSERTS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"maximumAsserts").desc("Maximum number of assert calls in a test method")).require(NumericConstraints.positive())).defaultValue((Object)1)).build();
    private static final PropertyDescriptor<Set<String>> EXTRA_ASSERT_METHOD_NAMES = ((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"extraAssertMethodNames").desc("Extra valid assertion methods names")).map(Collectors.toSet()).emptyDefaultValue().build();

    public JUnitTestContainsTooManyAssertsRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(MAX_ASSERTS);
        this.definePropertyDescriptor(EXTRA_ASSERT_METHOD_NAMES);
    }

    public Object visit(ASTMethodDeclaration method, Object data) {
        ASTBlock body = method.getBody();
        if (body != null && TestFrameworksUtil.isTestMethod(method)) {
            Set extraAsserts = (Set)this.getProperty(EXTRA_ASSERT_METHOD_NAMES);
            int assertCount = body.descendants(ASTMethodCall.class).filter(call -> TestFrameworksUtil.isProbableAssertCall(call) || extraAsserts.contains(call.getMethodName())).count();
            if (assertCount > (Integer)this.getProperty(MAX_ASSERTS)) {
                this.asCtx(data).addViolation((Node)method);
            }
        }
        return data;
    }
}

