/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer.ast;

import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.Infer;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.ConditionalMirrorImpl;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.CtorInvocMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.LambdaMirrorImpl;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.MethodInvocMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.MethodRefMirrorImpl;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.StandaloneExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.SwitchMirror;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JavaExprMirrors {
    final Infer infer;
    final TypeSystem ts;
    private final boolean mayMutateAst;
    private final MirrorMaker defaultSubexprMaker = this::makeSubexprDefault;

    private JavaExprMirrors(Infer infer, boolean mayMutateAst) {
        this.infer = infer;
        this.ts = infer.getTypeSystem();
        this.mayMutateAst = mayMutateAst;
    }

    public MirrorMaker defaultMirrorMaker() {
        return this.defaultSubexprMaker;
    }

    public static JavaExprMirrors forTypeResolution(Infer infer) {
        return new JavaExprMirrors(infer, true);
    }

    public static JavaExprMirrors forObservation(Infer infer) {
        return new JavaExprMirrors(infer, false);
    }

    boolean mayMutateAst() {
        return this.mayMutateAst;
    }

    ExprMirror makeSubexprDefault(ASTExpression e, @Nullable ExprMirror parent, MirrorMaker subexprMaker) {
        if (e instanceof InvocationNode) {
            return this.getInvocationMirror((InvocationNode)((Object)e), parent, subexprMaker);
        }
        if (e instanceof ASTLambdaExpression || e instanceof ASTMethodReference) {
            return this.getFunctionalMirror(e, parent, subexprMaker);
        }
        if (e instanceof ASTConditionalExpression) {
            return new ConditionalMirrorImpl(this, (ASTConditionalExpression)e, false, parent, subexprMaker);
        }
        if (e instanceof ASTSwitchExpression) {
            return new SwitchMirror(this, (ASTSwitchExpression)e, false, parent, subexprMaker);
        }
        return new StandaloneExprMirror(this, e, parent);
    }

    ExprMirror getBranchMirrorSubexpression(ASTExpression e, boolean isStandalone, @NonNull ExprMirror.BranchingMirror parent, MirrorMaker subexprMaker) {
        if (e instanceof ASTConditionalExpression) {
            return new ConditionalMirrorImpl(this, (ASTConditionalExpression)e, isStandalone, parent, subexprMaker);
        }
        if (e instanceof ASTSwitchExpression) {
            return new SwitchMirror(this, (ASTSwitchExpression)e, isStandalone, parent, subexprMaker);
        }
        return subexprMaker.createMirrorForSubexpression(e, parent, subexprMaker);
    }

    public ExprMirror.InvocationMirror getTopLevelInvocationMirror(InvocationNode e) {
        return this.getInvocationMirror(e, this.defaultMirrorMaker());
    }

    public ExprMirror.InvocationMirror getInvocationMirror(InvocationNode e, MirrorMaker subexprMaker) {
        return this.getInvocationMirror(e, null, subexprMaker);
    }

    private ExprMirror.InvocationMirror getInvocationMirror(InvocationNode e, @Nullable ExprMirror parent, MirrorMaker subexprMaker) {
        if (e instanceof ASTMethodCall) {
            return new MethodInvocMirror(this, (ASTMethodCall)e, parent, subexprMaker);
        }
        if (e instanceof ASTConstructorCall) {
            return new CtorInvocMirror(this, (ASTConstructorCall)e, parent, subexprMaker);
        }
        if (e instanceof ASTExplicitConstructorInvocation) {
            return new CtorInvocMirror.ExplicitCtorInvocMirror(this, (ASTExplicitConstructorInvocation)e, parent, subexprMaker);
        }
        if (e instanceof ASTEnumConstant) {
            return new CtorInvocMirror.EnumCtorInvocMirror(this, (ASTEnumConstant)e, parent, subexprMaker);
        }
        throw AssertionUtil.shouldNotReachHere((String)("Unhandled InvocationNode:" + e));
    }

    public ExprMirror.BranchingMirror getStandaloneBranchingMirror(ASTExpression e) {
        if (e instanceof ASTConditionalExpression) {
            return new ConditionalMirrorImpl(this, (ASTConditionalExpression)e, true, null, this.defaultMirrorMaker());
        }
        if (e instanceof ASTSwitchExpression) {
            return new SwitchMirror(this, (ASTSwitchExpression)e, true, null, this.defaultMirrorMaker());
        }
        throw AssertionUtil.shouldNotReachHere((String)("Unhandled expression: " + e));
    }

    public ExprMirror.BranchingMirror getPolyBranchingMirror(ASTExpression e) {
        if (e instanceof ASTConditionalExpression) {
            return new ConditionalMirrorImpl(this, (ASTConditionalExpression)e, false, null, this.defaultMirrorMaker());
        }
        if (e instanceof ASTSwitchExpression) {
            return new SwitchMirror(this, (ASTSwitchExpression)e, false, null, this.defaultMirrorMaker());
        }
        throw AssertionUtil.shouldNotReachHere((String)("Unhandled expression: " + e));
    }

    public ExprMirror.FunctionalExprMirror getTopLevelFunctionalMirror(ASTExpression e) {
        return this.getFunctionalMirror(e, null, this.defaultMirrorMaker());
    }

    ExprMirror.FunctionalExprMirror getFunctionalMirror(ASTExpression e, @Nullable ExprMirror parent, MirrorMaker subexprMaker) {
        if (e instanceof ASTLambdaExpression) {
            return new LambdaMirrorImpl(this, (ASTLambdaExpression)e, parent, subexprMaker);
        }
        if (e instanceof ASTMethodReference) {
            return new MethodRefMirrorImpl(this, (ASTMethodReference)e, parent, subexprMaker);
        }
        throw AssertionUtil.shouldNotReachHere((String)("Unhandled expression: " + e));
    }

    @FunctionalInterface
    public static interface MirrorMaker {
        public ExprMirror createMirrorForSubexpression(ASTExpression var1, ExprMirror var2, MirrorMaker var3);
    }
}

