/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.ErrorListener;
import net.sf.saxon.query.ModuleURIResolver;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.trans.XPathException;

public class XQueryCompiler {
    private Processor processor;
    private StaticQueryContext env;
    private ItemType requiredContextItemType;
    private String encoding;

    protected XQueryCompiler(Processor processor) {
        this.processor = processor;
        this.env = processor.getUnderlyingConfiguration().newStaticQueryContext();
    }

    public void setBaseURI(URI baseURI) {
        if (!baseURI.isAbsolute()) {
            throw new IllegalArgumentException("Base URI must be an absolute URI");
        }
        this.env.setBaseURI(baseURI.toString());
    }

    public URI getBaseURI() {
        try {
            return new URI(this.env.getBaseURI());
        }
        catch (URISyntaxException err) {
            throw new IllegalStateException(err);
        }
    }

    public void setErrorListener(ErrorListener listener) {
        this.env.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.env.getErrorListener();
    }

    public void setCompileWithTracing(boolean option) {
        this.env.setCompileWithTracing(option);
    }

    public boolean isCompileWithTracing() {
        return this.env.isCompileWithTracing();
    }

    public void setModuleURIResolver(ModuleURIResolver resolver) {
        this.env.setModuleURIResolver(resolver);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.env.getModuleURIResolver();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setUpdatingEnabled(boolean updating) {
        this.env.setUpdatingEnabled(updating);
    }

    public boolean isUpdatingEnabled() {
        return this.env.isUpdatingEnabled();
    }

    public void setSchemaAware(boolean schemaAware) {
        this.env.setSchemaAware(schemaAware);
    }

    public boolean isSchemaAware() {
        return this.env.isSchemaAware();
    }

    public void setLanguageVersion(String version) {
        if (!"1.0".equals(version) && !"1.1".equals(version)) {
            throw new IllegalArgumentException("LanguageVersion " + version);
        }
        this.env.setLanguageVersion(version);
    }

    public String getLanguageVersion() {
        return this.env.getLanguageVersion();
    }

    public void declareNamespace(String prefix, String uri) {
        this.env.declareNamespace(prefix, uri);
    }

    public void setRequiredContextItemType(ItemType type) {
        this.requiredContextItemType = type;
        this.env.setRequiredContextItemType(type.getUnderlyingItemType());
    }

    public ItemType getRequiredContextItemType() {
        return this.requiredContextItemType;
    }

    public void compileLibrary(String query) throws SaxonApiException {
        try {
            this.env.compileLibrary(query);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public void compileLibrary(File query) throws SaxonApiException, IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(query);
            String savedBaseUri = this.env.getBaseURI();
            this.env.setBaseURI(query.toURI().toString());
            this.env.compileLibrary(stream, this.encoding);
            this.env.setBaseURI(savedBaseUri);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public void compileLibrary(Reader query) throws SaxonApiException {
        try {
            this.env.compileLibrary(query);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        catch (IOException e) {
            throw new SaxonApiException(e);
        }
    }

    public void compileLibrary(InputStream query) throws SaxonApiException {
        try {
            this.env.compileLibrary(query, this.encoding);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        catch (IOException e) {
            throw new SaxonApiException(e);
        }
    }

    public XQueryExecutable compile(String query) throws SaxonApiException {
        try {
            return new XQueryExecutable(this.processor, this.env.compileQuery(query));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XQueryExecutable compile(File query) throws SaxonApiException, IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(query);
            String savedBaseUri = this.env.getBaseURI();
            this.env.setBaseURI(query.toURI().toString());
            XQueryExecutable exec = new XQueryExecutable(this.processor, this.env.compileQuery(stream, this.encoding));
            this.env.setBaseURI(savedBaseUri);
            XQueryExecutable xQueryExecutable = exec;
            return xQueryExecutable;
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public XQueryExecutable compile(InputStream query) throws SaxonApiException, IOException {
        try {
            return new XQueryExecutable(this.processor, this.env.compileQuery(query, this.encoding));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XQueryExecutable compile(Reader query) throws SaxonApiException, IOException {
        try {
            return new XQueryExecutable(this.processor, this.env.compileQuery(query));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public StaticQueryContext getUnderlyingStaticContext() {
        return this.env;
    }
}

