/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.math.BigDecimal;
import java.math.RoundingMode;
import net.time4j.PlainTime;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;

final class ProportionalFunction
implements ChronoFunction<ChronoEntity<?>, BigDecimal> {
    private final ChronoElement<? extends Number> element;
    private final boolean extendedRange;

    ProportionalFunction(ChronoElement<? extends Number> chronoElement, boolean bl) {
        this.element = chronoElement;
        this.extendedRange = bl;
    }

    @Override
    public BigDecimal apply(ChronoEntity<?> chronoEntity) {
        long l = chronoEntity.get(this.element).longValue();
        long l2 = chronoEntity.getMinimum(this.element).longValue();
        long l3 = chronoEntity.getMaximum(this.element).longValue();
        if (l > l3) {
            l = l3;
        }
        if (l == l2) {
            return BigDecimal.ZERO;
        }
        if (this.extendedRange && chronoEntity instanceof PlainTime && !((PlainTime)PlainTime.class.cast(chronoEntity)).hasReducedRange(this.element)) {
            if (l == l3) {
                return BigDecimal.ONE;
            }
            --l3;
        }
        BigDecimal bigDecimal = new BigDecimal(l - l2).setScale(15, RoundingMode.UNNECESSARY);
        BigDecimal bigDecimal2 = new BigDecimal(l3 - l2 + 1L);
        return bigDecimal.divide(bigDecimal2, RoundingMode.HALF_UP).stripTrailingZeros();
    }
}

