/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Locale;
import java.util.Map;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.NumberSystem;
import net.time4j.format.internal.DualFormatElement;

public final class EastAsianMonth
implements Comparable<EastAsianMonth>,
Serializable {
    public static final AttributeKey<Character> LEAP_MONTH_INDICATOR = Attributes.createKey("LEAP_MONTH_INDICATOR", Character.class);
    public static final AttributeKey<Boolean> LEAP_MONTH_IS_TRAILING = Attributes.createKey("LEAP_MONTH_IS_TRAILING", Boolean.class);
    private static final EastAsianMonth[] CACHE;
    private static final long serialVersionUID = 7544059597266533279L;
    private final int index;
    private final boolean leap;

    private EastAsianMonth(int n, boolean bl) {
        this.index = n;
        this.leap = bl;
    }

    public static EastAsianMonth valueOf(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return CACHE[n - 1];
    }

    public int getNumber() {
        return this.index + 1;
    }

    public boolean isLeap() {
        return this.leap;
    }

    public EastAsianMonth withLeap() {
        return CACHE[this.index + 12];
    }

    public String getOldJapaneseName(Locale locale) {
        Map<String, String> map = CalendarText.getInstance("japanese", locale).getTextForms();
        return map.get("t" + this.getNumber());
    }

    public String getDisplayName(Locale locale, NumberSystem numberSystem) {
        String string = this.getDisplayName(locale, numberSystem, Attributes.empty());
        String string2 = locale.getLanguage();
        if (string2.equals("zh")) {
            string = string + "\u6708";
        } else if (string2.equals("ko")) {
            string = string + "\uc6d4";
        } else if (string2.equals("ja")) {
            string = string + "\u6708";
        }
        return string;
    }

    @Override
    public int compareTo(EastAsianMonth eastAsianMonth) {
        if (this.index < eastAsianMonth.index) {
            return -1;
        }
        if (this.index > eastAsianMonth.index) {
            return 1;
        }
        if (this.leap) {
            return eastAsianMonth.leap ? 0 : 1;
        }
        return eastAsianMonth.leap ? -1 : 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof EastAsianMonth) {
            EastAsianMonth eastAsianMonth = (EastAsianMonth)object;
            return this.index == eastAsianMonth.index && this.leap == eastAsianMonth.leap;
        }
        return false;
    }

    public int hashCode() {
        return this.index + (this.leap ? 12 : 0);
    }

    public String toString() {
        String string = String.valueOf(this.index + 1);
        return this.leap ? "*" + string : string;
    }

    String getDisplayName(Locale locale, NumberSystem numberSystem, AttributeQuery attributeQuery) {
        Map<String, String> map = CalendarText.getInstance("generic", locale).getTextForms();
        char c = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(numberSystem.getDigits().charAt(0))).charValue();
        String string = DualFormatElement.toNumeral(numberSystem, c, this.getNumber());
        if (this.leap) {
            boolean bl = attributeQuery.get(LEAP_MONTH_IS_TRAILING, "R".equals(map.get("leap-alignment")));
            char c2 = attributeQuery.get(LEAP_MONTH_INDICATOR, Character.valueOf(map.get("leap-indicator").charAt(0))).charValue();
            string = bl ? string + c2 : c2 + string;
        }
        return string;
    }

    private Object readResolve() throws ObjectStreamException {
        try {
            return CACHE[this.index + (this.leap ? 12 : 0)];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new StreamCorruptedException();
        }
    }

    static {
        EastAsianMonth[] eastAsianMonthArray = new EastAsianMonth[24];
        for (int i = 0; i < 12; ++i) {
            eastAsianMonthArray[i] = new EastAsianMonth(i, false);
            eastAsianMonthArray[i + 12] = new EastAsianMonth(i, true);
        }
        CACHE = eastAsianMonthArray;
    }
}

