/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.calendar.JulianCalendar;
import net.time4j.history.HistoricEra;

final class SPX7
implements Externalizable {
    private static final int JULIAN = 7;
    private static final long serialVersionUID = 1L;
    private transient Object obj;

    public SPX7() {
    }

    SPX7(Object object) {
        this.obj = object;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(7);
        JulianCalendar julianCalendar = (JulianCalendar)this.obj;
        objectOutput.writeInt(julianCalendar.getProlepticYear());
        objectOutput.writeInt(julianCalendar.getMonth().getValue());
        objectOutput.writeInt(julianCalendar.getDayOfMonth());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        if (by != 7) {
            throw new InvalidObjectException("Unknown calendar type.");
        }
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        int n3 = objectInput.readInt();
        HistoricEra historicEra = n >= 1 ? HistoricEra.AD : HistoricEra.BC;
        int n4 = n >= 1 ? n : Math.subtractExact(1, n);
        this.obj = JulianCalendar.of(historicEra, n4, n2, n3);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }
}

