/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.util.Collections;
import java.util.List;
import net.time4j.calendar.hindu.HinduCS;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduDay;
import net.time4j.calendar.hindu.HinduEra;
import net.time4j.calendar.hindu.HinduMonth;
import net.time4j.calendar.hindu.HinduVariant;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.EpochDays;

public enum AryaSiddhanta {
    SOLAR{

        @Override
        public HinduCS getCalendarSystem() {
            return new OldCS(true);
        }
    }
    ,
    LUNAR{

        @Override
        public HinduCS getCalendarSystem() {
            return new OldCS(false);
        }
    };

    static final String PREFIX = "AryaSiddhanta@";

    public HinduVariant variant() {
        return this == SOLAR ? HinduVariant.VAR_OLD_SOLAR : HinduVariant.VAR_OLD_LUNAR;
    }

    abstract HinduCS getCalendarSystem();

    private static class OldCS
    extends HinduCS {
        private static final double ARYA_SOLAR_YEAR = 365.25868055555554;
        private static final double ARYA_SOLAR_MONTH = 30.43822337962963;
        private static final double ARYA_LUNAR_MONTH = 29.530581807581694;

        OldCS(boolean bl) {
            super(bl ? HinduVariant.VAR_OLD_SOLAR : HinduVariant.VAR_OLD_LUNAR);
        }

        @Override
        public List<CalendarEra> getEras() {
            return Collections.singletonList(HinduEra.KALI_YUGA);
        }

        @Override
        HinduCalendar create(long l) {
            double d = (double)(EpochDays.RATA_DIE.transform(l, EpochDays.UTC) - -1132959L) + 0.25;
            if (this.isSolar()) {
                int n = (int)Math.floor(d / 365.25868055555554);
                int n2 = (int)OldCS.modulo(Math.floor(d / 30.43822337962963), 12.0) + 1;
                int n3 = (int)Math.floor(OldCS.modulo(d, 30.43822337962963)) + 1;
                return new HinduCalendar(this.variant, n, HinduMonth.ofSolar(n2), HinduDay.valueOf(n3), l);
            }
            double d2 = d - OldCS.modulo(d, 29.530581807581694);
            double d3 = OldCS.modulo(d2, 30.43822337962963);
            boolean bl = 0.907641572047936 >= d3 && d3 > 0.0;
            int n = (int)(Math.ceil((d2 + 30.43822337962963) / 365.25868055555554) - 1.0);
            int n4 = (int)(OldCS.modulo(Math.ceil(d2 / 30.43822337962963), 12.0) + 1.0);
            int n5 = (int)(OldCS.modulo(Math.floor(d * 30.0 / 29.530581807581694), 30.0) + 1.0);
            HinduMonth hinduMonth = HinduMonth.ofLunisolar(n4);
            return new HinduCalendar(this.variant, n, bl ? hinduMonth.withLeap() : hinduMonth, HinduDay.valueOf(n5), l);
        }

        @Override
        HinduCalendar create(int n, HinduMonth hinduMonth, HinduDay hinduDay) {
            double d;
            if (this.isSolar()) {
                d = (double)n * 365.25868055555554 + (double)(hinduMonth.getRasi() - 1) * 30.43822337962963 + (double)hinduDay.getValue() - 1.25;
            } else {
                double d2 = (double)(12 * n - 1) * 30.43822337962963;
                double d3 = 29.530581807581694 * (Math.floor(d2 / 29.530581807581694) + 1.0);
                int n2 = hinduMonth.getValue().getValue();
                if (hinduMonth.isLeap() || Math.ceil((d3 - d2) / 0.907641572047936) > (double)n2) {
                    --n2;
                }
                d = d3 + 29.530581807581694 * (double)n2 + (double)(hinduDay.getValue() - 1) * 0.9843527269193898 - 0.25;
            }
            return new HinduCalendar(this.variant, n, hinduMonth, hinduDay, EpochDays.UTC.transform((long)Math.ceil(-1132959.0 + d), EpochDays.RATA_DIE));
        }

        @Override
        boolean isValid(int n, HinduMonth hinduMonth, HinduDay hinduDay) {
            if (n < 0 || n > 5999 || hinduMonth == null || hinduDay == null) {
                return false;
            }
            if (this.isSolar() && (hinduMonth.isLeap() || hinduDay.isLeap())) {
                return false;
            }
            if (hinduDay.getValue() > (this.isSolar() ? 31 : 30)) {
                return false;
            }
            return !this.isExpunged(n, hinduMonth, hinduDay);
        }

        @Override
        public long getMinimumSinceUTC() {
            long l = this.isSolar() ? -1132959L : -1132988L;
            return EpochDays.UTC.transform(l, EpochDays.RATA_DIE);
        }

        @Override
        public long getMaximumSinceUTC() {
            return this.isSolar() ? 338699L : 338671L;
        }

        private boolean isSolar() {
            return this.variant == HinduVariant.VAR_OLD_SOLAR;
        }
    }
}

