/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.text.ParseException;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;
import net.time4j.engine.Chronology;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeLine;
import net.time4j.engine.VariantSource;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.range.Boundary;
import net.time4j.range.CalendarMonth;
import net.time4j.range.CalendarQuarter;
import net.time4j.range.CalendarWeek;
import net.time4j.range.CalendarYear;
import net.time4j.range.ChronoInterval;
import net.time4j.range.FixedCalendarInterval;
import net.time4j.range.FixedCalendarTimeLine;
import net.time4j.range.IntervalCreator;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;

public class CalendarPeriod<T>
implements ChronoInterval<T>,
Serializable {
    private static final long serialVersionUID = -1570485272742024241L;
    private final T t1;
    private final T t2;

    private CalendarPeriod(T t, T t2) {
        if (t == null || t2 == null) {
            throw new NullPointerException("Missing start or end.");
        }
        this.t1 = t;
        this.t2 = t2;
    }

    public static CalendarPeriod<CalendarYear> between(CalendarYear calendarYear, CalendarYear calendarYear2) {
        return new FixedCalendarPeriod<CalendarYear>(calendarYear, calendarYear2, FixedCalendarTimeLine.forYears());
    }

    public static CalendarPeriod<CalendarQuarter> between(CalendarQuarter calendarQuarter, CalendarQuarter calendarQuarter2) {
        return new FixedCalendarPeriod<CalendarQuarter>(calendarQuarter, calendarQuarter2, FixedCalendarTimeLine.forQuarters());
    }

    public static CalendarPeriod<CalendarMonth> between(CalendarMonth calendarMonth, CalendarMonth calendarMonth2) {
        return new FixedCalendarPeriod<CalendarMonth>(calendarMonth, calendarMonth2, FixedCalendarTimeLine.forMonths());
    }

    public static CalendarPeriod<CalendarWeek> between(CalendarWeek calendarWeek, CalendarWeek calendarWeek2) {
        return new FixedCalendarPeriod<CalendarWeek>(calendarWeek, calendarWeek2, FixedCalendarTimeLine.forWeeks());
    }

    public static Parser<CalendarYear> onYears() {
        return new FixedParser<CalendarYear>(FixedCalendarTimeLine.forYears());
    }

    public static Parser<CalendarQuarter> onQuarters() {
        return new FixedParser<CalendarQuarter>(FixedCalendarTimeLine.forQuarters());
    }

    public static Parser<CalendarMonth> onMonths() {
        return new FixedParser<CalendarMonth>(FixedCalendarTimeLine.forMonths());
    }

    public static Parser<CalendarWeek> onWeeks() {
        return new FixedParser<CalendarWeek>(FixedCalendarTimeLine.forWeeks());
    }

    public static <U, D extends Calendrical<U, D>> Factory<D> on(TimeAxis<U, D> timeAxis) {
        Class clazz = timeAxis.getChronoType();
        CalendarSystem<D> calendarSystem = timeAxis.getCalendarSystem();
        return new Factory(clazz, "", timeAxis, calendarSystem);
    }

    public static <D extends CalendarVariant<D>> Factory<D> on(CalendarFamily<D> calendarFamily, String string) {
        Class clazz = calendarFamily.getChronoType();
        TimeLine<D> timeLine = calendarFamily.getTimeLine(string);
        CalendarSystem<D> calendarSystem = calendarFamily.getCalendarSystem(string);
        return new Factory(clazz, string, timeLine, calendarSystem);
    }

    public static <D extends CalendarVariant<D>> Factory<D> on(CalendarFamily<D> calendarFamily, VariantSource variantSource) {
        String string = variantSource.getVariant();
        Class clazz = calendarFamily.getChronoType();
        TimeLine<D> timeLine = calendarFamily.getTimeLine(string);
        CalendarSystem<D> calendarSystem = calendarFamily.getCalendarSystem(string);
        return new Factory(clazz, string, timeLine, calendarSystem);
    }

    @Override
    public Boundary<T> getStart() {
        return Boundary.ofClosed(this.t1);
    }

    @Override
    public Boundary<T> getEnd() {
        return Boundary.ofClosed(this.t2);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isFinite() {
        return true;
    }

    @Override
    public boolean contains(T t) {
        return this.getTimeLine().compare(this.t1, t) <= 0 && this.getTimeLine().compare(t, this.t2) <= 0;
    }

    @Override
    public boolean contains(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.isFinite()) {
            long l = this.toProlepticNumber(chronoInterval.getStart().getTemporal());
            long l2 = this.toProlepticNumber(chronoInterval.getEnd().getTemporal());
            if (chronoInterval.getStart().isOpen()) {
                ++l;
            }
            if (chronoInterval.getEnd().isOpen()) {
                --l2;
            }
            return this.toProlepticNumber(this.t1) <= l && l2 <= this.toProlepticNumber(this.t2);
        }
        return false;
    }

    @Override
    public boolean isAfter(T t) {
        return this.getTimeLine().compare(this.t1, t) > 0;
    }

    @Override
    public boolean isBefore(T t) {
        return this.getTimeLine().compare(this.t2, t) < 0;
    }

    @Override
    public boolean isBefore(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.getStart().isInfinite()) {
            return false;
        }
        T t = chronoInterval.getStart().getTemporal();
        if (chronoInterval.getStart().isOpen()) {
            t = this.getTimeLine().stepForward(t);
        }
        if (t == null) {
            return true;
        }
        return this.getTimeLine().compare(this.t2, t) < 0;
    }

    @Override
    public boolean abuts(ChronoInterval<T> chronoInterval) {
        if (chronoInterval.isEmpty()) {
            return false;
        }
        if (chronoInterval.isFinite()) {
            long l = this.toProlepticNumber(chronoInterval.getStart().getTemporal());
            long l2 = this.toProlepticNumber(chronoInterval.getEnd().getTemporal());
            if (chronoInterval.getStart().isOpen()) {
                ++l;
            }
            if (chronoInterval.getEnd().isOpen()) {
                --l2;
            }
            return this.toProlepticNumber(this.t2) + 1L == l || l2 + 1L == this.toProlepticNumber(this.t1);
        }
        if (!chronoInterval.getStart().isInfinite()) {
            long l = this.toProlepticNumber(chronoInterval.getStart().getTemporal());
            if (chronoInterval.getStart().isOpen()) {
                ++l;
            }
            return this.toProlepticNumber(this.t2) + 1L == l;
        }
        if (!chronoInterval.getEnd().isInfinite()) {
            long l = this.toProlepticNumber(chronoInterval.getEnd().getTemporal());
            if (chronoInterval.getEnd().isOpen()) {
                --l;
            }
            return l + 1L == this.toProlepticNumber(this.t1);
        }
        return false;
    }

    public Optional<CalendarPeriod<T>> findIntersection(ChronoInterval<T> chronoInterval) {
        Object object;
        Boundary<T> boundary;
        T t;
        Object object2;
        Boundary<T> boundary2;
        if (this.isEmpty() || chronoInterval.isEmpty()) {
            return Optional.empty();
        }
        if (chronoInterval.getStart().isInfinite()) {
            boundary2 = this.getStart();
        } else {
            object2 = this.t1;
            t = chronoInterval.getStart().getTemporal();
            if (chronoInterval.getStart().isOpen()) {
                t = this.getTimeLine().stepForward(t);
            }
            if (t == null) {
                return Optional.empty();
            }
            Boundary<T> boundary3 = boundary2 = this.getTimeLine().compare(object2, t) < 0 ? Boundary.ofClosed(t) : Boundary.ofClosed(object2);
        }
        if (chronoInterval.getEnd().isInfinite()) {
            boundary = this.getEnd();
        } else {
            object2 = this.t2;
            t = chronoInterval.getEnd().getTemporal();
            if (chronoInterval.getEnd().isOpen()) {
                t = this.getTimeLine().stepBackwards(t);
            }
            Boundary<T> boundary4 = boundary = this.getTimeLine().compare(object2, t) < 0 ? Boundary.ofClosed(object2) : Boundary.ofClosed(t);
        }
        if (this.toProlepticNumber(boundary2.getTemporal()) > this.toProlepticNumber(boundary.getTemporal())) {
            return Optional.empty();
        }
        t = this.getTimeLine().getMaximum();
        if (t instanceof FixedCalendarInterval) {
            object = (FixedCalendarInterval)FixedCalendarInterval.class.cast(boundary2.getTemporal());
            FixedCalendarInterval fixedCalendarInterval = (FixedCalendarInterval)FixedCalendarInterval.class.cast(boundary.getTemporal());
            FixedCalendarTimeLine fixedCalendarTimeLine = (FixedCalendarTimeLine)FixedCalendarTimeLine.class.cast(this.getTimeLine());
            object2 = new FixedCalendarPeriod<FixedCalendarInterval>((FixedCalendarInterval)object, fixedCalendarInterval, fixedCalendarTimeLine);
        } else {
            object = (CalendarDate)CalendarDate.class.cast(boundary2.getTemporal());
            CalendarDate calendarDate = (CalendarDate)CalendarDate.class.cast(boundary.getTemporal());
            GenericCalendarPeriod genericCalendarPeriod = (GenericCalendarPeriod)GenericCalendarPeriod.class.cast(this);
            object2 = genericCalendarPeriod.with((CalendarDate)object, calendarDate);
        }
        object = object2;
        return ((CalendarPeriod)object).isEmpty() ? Optional.empty() : Optional.of(object);
    }

    public Stream<T> stream() {
        return LongStream.rangeClosed(this.toProlepticNumber(this.t1), this.toProlepticNumber(this.t2)).mapToObj(this::fromProlepticNumber);
    }

    public long delta() {
        return this.toProlepticNumber(this.t2) - this.toProlepticNumber(this.t1);
    }

    public T random() {
        long l = ThreadLocalRandom.current().nextLong(this.toProlepticNumber(this.t1), this.toProlepticNumber(this.t2) + 1L);
        return this.fromProlepticNumber(l);
    }

    public String print(ChronoPrinter<T> chronoPrinter) {
        return this.print(chronoPrinter, IsoInterval.getIntervalPattern(chronoPrinter));
    }

    public String print(ChronoPrinter<T> chronoPrinter, String string) {
        AttributeQuery attributeQuery = chronoPrinter.getAttributes();
        StringBuilder stringBuilder = new StringBuilder(32);
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c == '{' && n + 2 < n2 && string.charAt(n + 2) == '}') {
                char c2 = string.charAt(n + 1);
                if (c2 == '0') {
                    chronoPrinter.print(this.t1, stringBuilder, attributeQuery);
                    n += 3;
                    continue;
                }
                if (c2 == '1') {
                    chronoPrinter.print(this.t2, stringBuilder, attributeQuery);
                    n += 3;
                    continue;
                }
            }
            stringBuilder.append(c);
            ++n;
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CalendarPeriod) {
            CalendarPeriod calendarPeriod = (CalendarPeriod)CalendarPeriod.class.cast(object);
            return this.t1.equals(calendarPeriod.t1) && this.t2.equals(calendarPeriod.t2) && this.getTimeLine().equals(calendarPeriod.getTimeLine());
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.t1.hashCode() ^ 31 * this.t2.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.t1);
        stringBuilder.append('/');
        stringBuilder.append(this.t2);
        return stringBuilder.toString();
    }

    TimeLine<T> getTimeLine() {
        throw new AbstractMethodError();
    }

    long toProlepticNumber(T t) {
        throw new AbstractMethodError();
    }

    T fromProlepticNumber(long l) {
        throw new AbstractMethodError();
    }

    final T start() {
        return this.t1;
    }

    final T end() {
        return this.t2;
    }

    static <T> void checkStartNotAfterEnd(T t, T t2, TimeLine<T> timeLine) {
        if (timeLine.compare(t, t2) > 0) {
            throw new IllegalArgumentException("Start after end: " + t + "/" + t2);
        }
    }

    private static class FixedCalendarPeriod<T extends FixedCalendarInterval<T>>
    extends CalendarPeriod<T> {
        private FixedCalendarTimeLine<T> timeLine;

        FixedCalendarPeriod(T t, T t2, FixedCalendarTimeLine<T> fixedCalendarTimeLine) {
            super(t, t2);
            this.timeLine = fixedCalendarTimeLine;
            FixedCalendarPeriod.checkStartNotAfterEnd(t, t2, fixedCalendarTimeLine);
        }

        @Override
        TimeLine<T> getTimeLine() {
            return this.timeLine;
        }

        @Override
        long toProlepticNumber(T t) {
            return ((FixedCalendarInterval)t).toProlepticNumber();
        }

        @Override
        T fromProlepticNumber(long l) {
            return (T)((FixedCalendarInterval)this.timeLine.mapper().apply(l));
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                FixedCalendarPeriod.checkStartNotAfterEnd((FixedCalendarInterval)this.start(), (FixedCalendarInterval)this.end(), this.timeLine);
                return this;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new StreamCorruptedException();
            }
        }
    }

    private static class FixedParser<T extends FixedCalendarInterval<T>>
    extends Parser<T> {
        private final FixedCalendarTimeLine<T> timeLine;

        private FixedParser(FixedCalendarTimeLine<T> fixedCalendarTimeLine) {
            this.timeLine = fixedCalendarTimeLine;
        }

        @Override
        public CalendarPeriod<T> parse(CharSequence charSequence, ChronoParser<T> chronoParser, String string) throws ParseException {
            IntervalCreator intervalCreator = new IntervalCreator<T, CalendarPeriod<T>>(){

                @Override
                public CalendarPeriod<T> between(Boundary<T> boundary, Boundary<T> boundary2) {
                    if (boundary.isInfinite() || boundary2.isInfinite()) {
                        throw new IllegalArgumentException("Infinite calendar periods are not supported.");
                    }
                    if (boundary.isOpen() || boundary2.isOpen()) {
                        throw new IllegalArgumentException("Calendar periods must be closed.");
                    }
                    return new FixedCalendarPeriod<FixedCalendarInterval>((FixedCalendarInterval)boundary.getTemporal(), (FixedCalendarInterval)boundary2.getTemporal(), timeLine);
                }

                @Override
                public boolean isCalendrical() {
                    return true;
                }
            };
            return (CalendarPeriod)IntervalParser.parsePattern(charSequence, intervalCreator, chronoParser, string);
        }
    }

    public static class Factory<T>
    extends Parser<T> {
        private final Class<T> chronoType;
        private final String variant;
        private final TimeLine<T> timeLine;
        private final CalendarSystem<T> calsys;

        private Factory(Class<T> clazz, String string, TimeLine<T> timeLine, CalendarSystem<T> calendarSystem) {
            this.chronoType = clazz;
            this.variant = string;
            this.timeLine = timeLine;
            this.calsys = calendarSystem;
        }

        public CalendarPeriod<T> between(T t, T t2) {
            if (t == null) {
                throw new NullPointerException("Missing start.");
            }
            if (t2 == null) {
                throw new NullPointerException("Missing end.");
            }
            return new GenericCalendarPeriod<T>(t, t2, this.chronoType, this.variant, this.timeLine, this.calsys);
        }

        @Override
        public CalendarPeriod<T> parse(CharSequence charSequence, ChronoParser<T> chronoParser, String string) throws ParseException {
            IntervalCreator intervalCreator = new IntervalCreator<T, CalendarPeriod<T>>(){

                @Override
                public CalendarPeriod<T> between(Boundary<T> boundary, Boundary<T> boundary2) {
                    if (boundary.isInfinite() || boundary2.isInfinite()) {
                        throw new IllegalArgumentException("Infinite calendar periods are not supported.");
                    }
                    if (boundary.isOpen() || boundary2.isOpen()) {
                        throw new IllegalArgumentException("Calendar periods must be closed.");
                    }
                    return this.between(boundary.getTemporal(), boundary2.getTemporal());
                }

                @Override
                public boolean isCalendrical() {
                    return true;
                }
            };
            return (CalendarPeriod)IntervalParser.parsePattern(charSequence, intervalCreator, chronoParser, string);
        }
    }

    private static class GenericCalendarPeriod<T>
    extends CalendarPeriod<T> {
        private Class<T> chronoType;
        private String variant;
        private transient TimeLine<T> timeLine;
        private transient CalendarSystem<T> calsys;

        GenericCalendarPeriod(T t, T t2, Class<T> clazz, String string, TimeLine<T> timeLine, CalendarSystem<T> calendarSystem) {
            super(t, t2);
            this.chronoType = clazz;
            this.variant = string;
            this.timeLine = timeLine;
            this.calsys = calendarSystem;
            GenericCalendarPeriod.checkStartNotAfterEnd(t, t2, timeLine);
        }

        @Override
        TimeLine<T> getTimeLine() {
            return this.timeLine;
        }

        @Override
        long toProlepticNumber(T t) {
            return this.calsys.transform(t);
        }

        @Override
        T fromProlepticNumber(long l) {
            return this.calsys.transform(l);
        }

        CalendarPeriod<T> with(CalendarDate calendarDate, CalendarDate calendarDate2) {
            CalendarDate calendarDate3 = calendarDate;
            CalendarDate calendarDate4 = calendarDate2;
            return new GenericCalendarPeriod<CalendarDate>(calendarDate3, calendarDate4, this.chronoType, this.variant, this.timeLine, this.calsys);
        }

        private Object readResolve() throws ObjectStreamException {
            Object t = this.start();
            Object t2 = this.end();
            if (this.chronoType.isInstance(t) && this.chronoType.isInstance(t2)) {
                Chronology<T> chronology = Chronology.lookup(this.chronoType);
                if (this.variant.isEmpty() && Calendrical.class.isAssignableFrom(this.chronoType)) {
                    return new GenericCalendarPeriod(t, t2, this.chronoType, "", (TimeLine)TimeLine.class.cast(chronology), chronology.getCalendarSystem());
                }
                return new GenericCalendarPeriod(t, t2, this.chronoType, this.variant, ((CalendarFamily)CalendarFamily.class.cast(chronology)).getTimeLine(this.variant), chronology.getCalendarSystem(this.variant));
            }
            throw new StreamCorruptedException();
        }
    }

    public static class Parser<T> {
        Parser() {
        }

        public CalendarPeriod<T> parse(CharSequence charSequence, ChronoParser<T> chronoParser) throws ParseException {
            return this.parse(charSequence, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
        }

        public CalendarPeriod<T> parse(CharSequence charSequence, ChronoParser<T> chronoParser, String string) throws ParseException {
            throw new AbstractMethodError();
        }
    }
}

