/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.other;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import net.time4j.format.internal.FormatUtils;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.spi.WinZoneProviderSPI;

public final class WindowsZone
implements Comparable<WindowsZone>,
Serializable {
    private static final Locale WORLDWIDE = new Locale("", "001");
    private static final long serialVersionUID = -6071278077083785308L;
    private final String name;

    private WindowsZone(String string) {
        this.name = string;
    }

    public static Set<String> getAvailableNames() {
        return WinZoneProviderSPI.NAME_BASED_MAP.keySet();
    }

    public static WindowsZone of(String string) {
        WindowsZone.check(string);
        return new WindowsZone(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WindowsZone) {
            WindowsZone windowsZone = (WindowsZone)object;
            return this.name.equals(windowsZone.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public static String toString(TZID tZID, Locale locale) {
        return WindowsZone.toString(tZID.canonical(), locale);
    }

    public static String toString(String string, Locale locale) {
        WinZoneProviderSPI winZoneProviderSPI = new WinZoneProviderSPI();
        String string2 = Timezone.normalize(string).canonical();
        String string3 = winZoneProviderSPI.getDisplayName(string2, NameStyle.LONG_STANDARD_TIME, locale);
        if (string3.isEmpty()) {
            string3 = winZoneProviderSPI.getDisplayName(string2, NameStyle.LONG_STANDARD_TIME, WORLDWIDE);
        }
        return string3;
    }

    @Override
    public int compareTo(WindowsZone windowsZone) {
        return this.name.compareTo(windowsZone.name);
    }

    public Set<TZID> resolve(Locale locale) {
        Set<TZID> set = WinZoneProviderSPI.NAME_BASED_MAP.get(this.name).get(FormatUtils.getRegion(locale));
        if (set == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(set);
    }

    public Optional<TZID> resolveSmart(Locale locale) {
        String string;
        Set<TZID> set = this.resolve(locale);
        if (set.size() != 1 && !(string = locale.getCountry()).isEmpty() && !string.equals("001")) {
            set = WinZoneProviderSPI.NAME_BASED_MAP.get(this.name).get("001");
        }
        if (set.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(set.iterator().next());
    }

    static String getVersion() {
        return WinZoneProviderSPI.WIN_NAME_VERSION;
    }

    private static void check(String string) {
        if (string.isEmpty() || !WinZoneProviderSPI.NAME_BASED_MAP.keySet().contains(string)) {
            throw new IllegalArgumentException("Unknown windows zone: " + string);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        WindowsZone.check(this.name);
    }
}

