/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.pim.contact.io.vcard;

import net.wimpi.pim.Pim;
import net.wimpi.pim.contact.io.vcard.ItemHandler;
import net.wimpi.pim.contact.model.Contact;
import net.wimpi.pim.contact.model.PersonalIdentity;
import net.wimpi.pim.util.StringUtil;
import net.wimpi.pim.util.versitio.versitItem;

class NItemHandler
implements ItemHandler {
    NItemHandler() {
    }

    public void handleItem(Contact ct, versitItem item) {
        PersonalIdentity pid = ct.getPersonalIdentity();
        if (pid == null) {
            pid = Pim.getContactModelFactory().createPersonalIdentity();
            ct.setPersonalIdentity(pid);
        }
        String[] names = StringUtil.split(item.getDecodedValue(), ";");
        String[] multi = null;
        block7: for (int i = 0; i < names.length; ++i) {
            switch (i) {
                case 0: {
                    pid.setLastname(names[0]);
                    continue block7;
                }
                case 1: {
                    pid.setFirstname(names[1]);
                    continue block7;
                }
                case 2: {
                    int n;
                    multi = StringUtil.split(names[2], ",");
                    for (n = 0; n < multi.length; ++n) {
                        pid.addAdditionalName(multi[n]);
                    }
                    continue block7;
                }
                case 3: {
                    int n;
                    multi = StringUtil.split(names[3], ",");
                    for (n = 0; n < multi.length; ++n) {
                        pid.addPrefix(multi[n]);
                    }
                    continue block7;
                }
                case 4: {
                    int n;
                    multi = StringUtil.split(names[4], ",");
                    for (n = 0; n < multi.length; ++n) {
                        pid.addSuffix(multi[n]);
                    }
                    continue block7;
                }
            }
        }
    }

    public versitItem[] createItems(Contact ct) {
        if (!ct.hasPersonalIdentity()) {
            return new versitItem[0];
        }
        versitItem[] items = new versitItem[1];
        PersonalIdentity pid = ct.getPersonalIdentity();
        String firstname = pid.getFirstname();
        String lastname = pid.getLastname();
        String[] addnames = pid.listAdditionalNames();
        String[] suffixes = pid.listSuffixes();
        String[] prefixes = pid.listPrefixes();
        if (pid == null || !StringUtil.isValidString(firstname) || !StringUtil.isValidString(lastname)) {
            return new versitItem[0];
        }
        versitItem item = new versitItem("N");
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(lastname).append(";");
        sbuf.append(firstname).append(";");
        if (StringUtil.isValidStringArray(addnames)) {
            sbuf.append(StringUtil.joinList(addnames));
        }
        sbuf.append(";");
        if (StringUtil.isValidStringArray(prefixes)) {
            sbuf.append(StringUtil.joinList(pid.listPrefixes()));
        }
        sbuf.append(";");
        if (StringUtil.isValidStringArray(suffixes)) {
            sbuf.append(StringUtil.joinList(pid.listSuffixes()));
        }
        item.setValue(sbuf.toString());
        items[0] = item;
        return items;
    }
}

