/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io.toolkit;

import java.io.IOException;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.terminal.ColorHelper;
import net.wimpi.telnetd.io.toolkit.InertComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Titlebar
extends InertComponent {
    private static Log log = LogFactory.getLog((Class)(class$net$wimpi$telnetd$io$toolkit$Titlebar == null ? (class$net$wimpi$telnetd$io$toolkit$Titlebar = Titlebar.class$("net.wimpi.telnetd.io.toolkit.Titlebar")) : class$net$wimpi$telnetd$io$toolkit$Titlebar));
    private String m_Title;
    private int m_Align;
    private String m_BgColor;
    private String m_FgColor;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_LEFT = 2;
    public static final int ALIGN_CENTER = 3;
    static /* synthetic */ Class class$net$wimpi$telnetd$io$toolkit$Titlebar;

    public Titlebar(BasicTerminalIO io, String name) {
        super(io, name);
    }

    public void setTitleText(String text) {
        this.m_Title = text;
    }

    public String getTitleText() {
        return this.m_Title;
    }

    public void setAlignment(int alignment) {
        if (alignment < 1 || alignment > 3) {
            alignment = 2;
        } else {
            this.m_Align = alignment;
        }
    }

    public void setForegroundColor(String color) {
        this.m_FgColor = color;
    }

    public void setBackgroundColor(String color) {
        this.m_BgColor = color;
    }

    public void draw() throws IOException {
        this.m_IO.storeCursor();
        this.m_IO.homeCursor();
        this.m_IO.write(this.getBar());
        this.m_IO.restoreCursor();
    }

    private String getBar() {
        String ttitle = this.m_Title;
        int width = this.m_IO.getColumns() - 1;
        int textwidth = (int)ColorHelper.getVisibleLength(this.m_Title);
        if (textwidth > width) {
            ttitle = this.m_Title.substring(0, width);
        }
        textwidth = (int)ColorHelper.getVisibleLength(ttitle);
        StringBuffer bar = new StringBuffer(width + textwidth);
        switch (this.m_Align) {
            case 2: {
                bar.append(ttitle);
                this.appendSpaceString(bar, width - textwidth);
                break;
            }
            case 1: {
                this.appendSpaceString(bar, width - textwidth);
                bar.append(ttitle);
                break;
            }
            case 3: {
                int left = width - textwidth != 0 ? (width - textwidth) / 2 : 0;
                int right = width - textwidth - left;
                this.appendSpaceString(bar, left);
                bar.append(ttitle);
                this.appendSpaceString(bar, right);
            }
        }
        return ColorHelper.boldcolorizeText(bar.toString(), this.m_FgColor, this.m_BgColor);
    }

    private void appendSpaceString(StringBuffer sbuf, int length) {
        for (int i = 0; i < length; ++i) {
            sbuf.append(" ");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

