/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.annotate;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateBuilder;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateLine;

public class AnnotateInformation
extends FileInfoContainer {
    private File file;
    private List linesList;
    private Iterator iterator;
    private File tempFile;
    private File tempDir;
    private BufferedOutputStream tempOutStream;

    public AnnotateInformation() {
        this.tempDir = null;
    }

    public AnnotateInformation(File tempDir) {
        this.tempDir = tempDir;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(30);
        buf.append("\nFile: " + (this.file != null ? this.file.getAbsolutePath() : "null"));
        return buf.toString();
    }

    public AnnotateLine createAnnotateLine() {
        return new AnnotateLine();
    }

    public void addLine(AnnotateLine line) {
        this.linesList.add(line);
    }

    public AnnotateLine getFirstLine() {
        if (this.linesList == null) {
            this.linesList = this.createLinesList();
        }
        this.iterator = this.linesList.iterator();
        return this.getNextLine();
    }

    public AnnotateLine getNextLine() {
        if (this.iterator == null) {
            return null;
        }
        if (!this.iterator.hasNext()) {
            return null;
        }
        return (AnnotateLine)this.iterator.next();
    }

    protected void addToTempFile(String line) throws IOException {
        if (this.tempOutStream == null) {
            try {
                this.tempFile = File.createTempFile("ann", ".cvs", this.tempDir);
                this.tempFile.deleteOnExit();
                this.tempOutStream = new BufferedOutputStream(new FileOutputStream(this.tempFile));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.tempOutStream.write(line.getBytes());
        this.tempOutStream.write(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeTempFile() throws IOException {
        if (this.tempOutStream == null) {
            return;
        }
        try {
            this.tempOutStream.flush();
        }
        finally {
            this.tempOutStream.close();
        }
    }

    public File getTempFile() {
        return this.tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List createLinesList() {
        LinkedList<AnnotateLine> toReturn;
        block14: {
            toReturn = new LinkedList<AnnotateLine>();
            BufferedReader reader = null;
            if (this.tempFile == null) {
                return toReturn;
            }
            reader = new BufferedReader(new FileReader(this.tempFile));
            String line = reader.readLine();
            int lineNum = 1;
            while (line != null) {
                AnnotateLine annLine = AnnotateBuilder.processLine(line);
                if (annLine != null) {
                    annLine.setLineNum(lineNum);
                    toReturn.add(annLine);
                    ++lineNum;
                }
                line = reader.readLine();
            }
            Object var7_7 = null;
            try {
                if (reader != null) {
                    reader.close();
                }
                break block14;
            }
            catch (IOException ex2) {}
            break block14;
            {
                catch (IOException iOException) {
                    Object var7_8 = null;
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                        break block14;
                    }
                    catch (IOException ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return toReturn;
    }
}

