/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.httpdlog.dissectors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nl.basjes.parse.core.Casts;
import nl.basjes.parse.core.Dissector;
import nl.basjes.parse.core.Parsable;
import nl.basjes.parse.core.ParsedField;
import nl.basjes.parse.core.exceptions.DissectionFailure;
import nl.basjes.parse.httpdlog.Utils;

public class QueryStringFieldDissector
extends Dissector {
    private static final String INPUT_TYPE = "HTTP.QUERYSTRING";
    private final Set<String> requestedParameters = new HashSet<String>(16);
    private boolean wantAllFields = false;

    public String getInputType() {
        return INPUT_TYPE;
    }

    public List<String> getPossibleOutput() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("STRING:*");
        return result;
    }

    public boolean initializeFromSettingsParameter(String settings) {
        return true;
    }

    protected void initializeNewInstance(Dissector newInstance) {
    }

    public EnumSet<Casts> prepareForDissect(String inputname, String outputname) {
        this.requestedParameters.add(outputname.substring(inputname.length() + 1));
        return Casts.STRING_ONLY;
    }

    public void prepareForRun() {
        this.wantAllFields = this.requestedParameters.contains("*");
    }

    public void dissect(Parsable<?> parsable, String inputname) throws DissectionFailure {
        String[] allValues;
        ParsedField field = parsable.getParsableField(INPUT_TYPE, inputname);
        String fieldValue = field.getValue().getString();
        if (fieldValue == null || fieldValue.isEmpty()) {
            return;
        }
        for (String value : allValues = fieldValue.split("&")) {
            String name;
            int equalPos = value.indexOf(61);
            if (equalPos == -1) {
                if ("".equals(value)) continue;
                name = value.toLowerCase();
                if (!this.wantAllFields && !this.requestedParameters.contains(name)) continue;
                parsable.addDissection(inputname, this.getDissectionType(inputname, value), name, "");
                continue;
            }
            name = value.substring(0, equalPos).toLowerCase();
            if (!this.wantAllFields && !this.requestedParameters.contains(name)) continue;
            try {
                parsable.addDissection(inputname, this.getDissectionType(inputname, name), name, Utils.resilientUrlDecode(value.substring(equalPos + 1, value.length())));
            }
            catch (IllegalArgumentException e) {
                throw new DissectionFailure(e.getMessage());
            }
        }
    }

    public String getDissectionType(String basename, String name) {
        return "STRING";
    }
}

