/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.lexemmens.podman.config.image.batch.BatchImageConfiguration;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;
import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.config.skopeo.SkopeoConfiguration;
import nl.lexemmens.podman.helper.ImageNameHelper;
import nl.lexemmens.podman.service.ServiceHub;
import nl.lexemmens.podman.service.ServiceHubFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.shared.filtering.MavenFileFilter;

public abstract class AbstractPodmanMojo
extends AbstractMojo {
    protected static final String PODMAN_DIRECTORY = "podman";
    protected static final String CATALOG_ARTIFACT_NAME = "container-catalog";
    protected static final String CATALOG_HEADER = "[containers]";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(property="podman.registries")
    protected String[] registries;
    @Parameter(property="podman.push.registry")
    protected String pushRegistry;
    @Parameter
    protected List<SingleImageConfiguration> images;
    @Parameter
    protected BatchImageConfiguration batch;
    @Parameter
    protected PodmanConfiguration podman;
    @Parameter
    protected SkopeoConfiguration skopeo;
    @Parameter(property="podman.skip.auth", defaultValue="false")
    protected boolean skipAuth;
    @Parameter(property="podman.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="podman.fail.on.missing.containerfile", defaultValue="true")
    protected boolean failOnMissingContainerfile;
    @Component
    private MavenFileFilter mavenFileFilter;
    @Component
    private ServiceHubFactory serviceHubFactory;
    @Component
    private SettingsDecrypter settingsDecrypter;
    @Component
    private MavenProjectHelper mavenProjectHelper;
    protected final List<SingleImageConfiguration> resolvedImages = new ArrayList<SingleImageConfiguration>();

    protected AbstractPodmanMojo() {
    }

    public final void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"The execution of the podman-maven-plugin is skipped.");
            return;
        }
        if (this.skipGoal()) {
            this.getLog().info((CharSequence)"The execution of this goal is skipped.");
            return;
        }
        this.initConfigurations();
        ServiceHub hub = this.serviceHubFactory.createServiceHub(this.getLog(), this.project, this.mavenFileFilter, this.podman, this.skopeo, this.settings, this.settingsDecrypter, this.mavenProjectHelper);
        this.printPodmanVersion(hub);
        this.executeInternal(hub);
    }

    private void printPodmanVersion(ServiceHub hub) throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            hub.getPodmanExecutorService().version();
        }
    }

    private void initConfigurations() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"Initializing configurations.");
        if (this.podman == null) {
            this.getLog().debug((CharSequence)"Using default Podman configuration.");
            this.podman = new PodmanConfiguration();
        }
        this.podman.initAndValidate(this.project, this.getLog());
        if (this.skopeo == null) {
            this.getLog().debug((CharSequence)"Using default skopeo configuration.");
            this.skopeo = new SkopeoConfiguration();
        }
        if (this.requireImageConfiguration()) {
            this.initImageConfigurations();
        } else {
            this.getLog().debug((CharSequence)"Validating image configuration is skipped.");
        }
    }

    protected final void initImageConfigurations() throws MojoExecutionException {
        this.resolveImages();
        if (this.resolvedImages.isEmpty()) {
            throw new MojoExecutionException("Cannot invoke plugin while there is no image configuration present!");
        }
        ImageNameHelper imageNameHelper = new ImageNameHelper(this.project);
        for (SingleImageConfiguration image : this.resolvedImages) {
            image.initAndValidate(this.project, this.getLog(), this.failOnMissingContainerfile);
            imageNameHelper.adaptReplacemeents(image);
            imageNameHelper.formatImageName(image);
        }
    }

    private void resolveImages() throws MojoExecutionException {
        if (this.batch != null) {
            this.getLog().warn((CharSequence)"NOTE: Batch mode enabled.");
            this.batch.initAndValidate(this.getLog(), this.project);
            this.resolvedImages.addAll(this.batch.resolve(this.getLog()));
        }
        if (this.images != null && !this.images.isEmpty()) {
            this.resolvedImages.addAll(this.images);
        }
    }

    protected void checkAuthentication(ServiceHub hub) throws MojoExecutionException {
        if (this.skipAuth) {
            this.getLog().info((CharSequence)"Registry authentication is skipped.");
        } else {
            hub.getAuthenticationService().authenticate(this.registries);
        }
    }

    protected String getFullImageNameWithPushRegistry(String imageNameWithTag) {
        String fullImageName = imageNameWithTag;
        if (this.pushRegistry != null) {
            fullImageName = String.format("%s/%s", this.pushRegistry, imageNameWithTag);
        }
        return fullImageName;
    }

    public abstract void executeInternal(ServiceHub var1) throws MojoExecutionException;

    protected abstract boolean skipGoal();

    protected boolean requireImageConfiguration() {
        return true;
    }

    protected List<String> singleImageConfigurationToFullImageList(SingleImageConfiguration singleImageConfiguration) {
        ArrayList<String> fullImages = new ArrayList<String>();
        if (singleImageConfiguration.getBuild().isMultistageContainerFile() && singleImageConfiguration.useCustomImageNameForMultiStageContainerfile()) {
            for (Map.Entry<String, String> stageImage : singleImageConfiguration.getImageHashPerStage().entrySet()) {
                List<String> imageNamesByStage = singleImageConfiguration.getImageNamesByStage(stageImage.getKey());
                if (imageNamesByStage.isEmpty()) {
                    this.getLog().warn((CharSequence)("No image name configured for build stage: " + stageImage.getKey() + ".Image " + stageImage.getValue() + " not added to container-catalog.txt!"));
                    continue;
                }
                for (String imageName : imageNamesByStage) {
                    String fullImageName = this.getFullImageNameWithPushRegistry(imageName);
                    fullImages.add(fullImageName);
                }
            }
        } else {
            if (singleImageConfiguration.getBuild().isMultistageContainerFile()) {
                this.getLog().warn((CharSequence)"Detected multistage Containerfile, but no custom image names have been specified. Falling back to final image.");
            }
            for (String imageNameWithTag : singleImageConfiguration.getImageNames()) {
                String fullImageName = this.getFullImageNameWithPushRegistry(imageNameWithTag);
                fullImages.add(fullImageName);
            }
        }
        return fullImages;
    }
}

