/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import nl.lexemmens.podman.AbstractPodmanMojo;
import nl.lexemmens.podman.config.image.AbstractImageConfiguration;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;
import nl.lexemmens.podman.helper.MultiStageBuildOutputHelper;
import nl.lexemmens.podman.service.ServiceHub;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="build", defaultPhase=LifecyclePhase.INSTALL)
public class BuildMojo
extends AbstractPodmanMojo {
    private final MultiStageBuildOutputHelper buildOutputHelper = new MultiStageBuildOutputHelper();
    @Parameter(property="podman.skip.build", defaultValue="false")
    boolean skipBuild;
    @Parameter(property="podman.skip.tag", defaultValue="false")
    boolean skipTag;
    @Parameter(property="podman.skip.catalog", defaultValue="false")
    boolean skipCatalog;

    @Override
    public void executeInternal(ServiceHub hub) throws MojoExecutionException {
        this.checkAuthentication(hub);
        for (SingleImageConfiguration image : this.resolvedImages) {
            if (!image.isValid()) {
                this.getLog().warn((CharSequence)("Skipping build of container image with name " + image.getImageName() + ". Configuration is not valid for this module!"));
                continue;
            }
            this.decorateContainerfile(image, hub);
            this.buildContainerImage(image, hub);
            this.tagContainerImage(image, hub);
            this.getLog().info((CharSequence)"Built container image.");
        }
        this.catalogContainers(this.resolvedImages, hub);
    }

    @Override
    protected boolean skipGoal() {
        return this.skipBuild;
    }

    private void decorateContainerfile(SingleImageConfiguration image, ServiceHub hub) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Filtering Containerfile...");
        hub.getContainerfileDecorator().decorateContainerfile(image);
    }

    private void buildContainerImage(SingleImageConfiguration image, ServiceHub hub) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Setting security context...");
        hub.getSecurityContextService().setSecurityContext();
        this.getLog().info((CharSequence)"Building container image...");
        List<String> processOutput = hub.getPodmanExecutorService().build(image);
        String finalImageHash = processOutput.get(processOutput.size() - 1);
        this.getLog().debug((CharSequence)("Determined final image hash as " + finalImageHash));
        image.setFinalImageHash(finalImageHash);
        if (image.getBuild().isMultistageContainerFile()) {
            this.getLog().info((CharSequence)"Detected multistage Containerfile...");
            this.buildOutputHelper.recordImageHashes(this.getLog(), image, processOutput);
        }
    }

    private void tagContainerImage(SingleImageConfiguration image, ServiceHub hub) throws MojoExecutionException {
        if (this.skipTag) {
            this.getLog().info((CharSequence)"Tagging container images is skipped.");
            return;
        }
        if (image.getBuild().getAllTags().isEmpty()) {
            this.getLog().info((CharSequence)"No tags specified. Skipping tagging of container images.");
            return;
        }
        if (image.getBuild().isMultistageContainerFile() && image.useCustomImageNameForMultiStageContainerfile()) {
            this.tagImagesOfMultiStageContainerfile(image, hub);
        } else if (image.getBuild().isMultistageContainerFile()) {
            this.getLog().warn((CharSequence)"Missing container names for multistage Containerfile. Falling back to tagging the final container image.");
            this.tagFinalImage(image, hub);
        } else {
            this.tagFinalImage(image, hub);
        }
    }

    private void tagImagesOfMultiStageContainerfile(SingleImageConfiguration image, ServiceHub hub) throws MojoExecutionException {
        for (Map.Entry<String, String> stageImage : image.getImageHashPerStage().entrySet()) {
            List<String> imageNamesByStage = image.getImageNamesByStage(stageImage.getKey());
            if (imageNamesByStage.isEmpty()) {
                this.getLog().warn((CharSequence)("No image name configured for build stage: " + stageImage.getKey() + ". Image " + stageImage.getValue() + " not tagged!"));
                continue;
            }
            for (String imageName : imageNamesByStage) {
                String fullImageName = this.getFullImageNameWithPushRegistry(imageName);
                this.getLog().info((CharSequence)("Tagging container image " + stageImage.getValue() + " from stage " + stageImage.getKey() + " as " + fullImageName));
                hub.getPodmanExecutorService().tag(stageImage.getValue(), fullImageName);
            }
        }
    }

    private void tagFinalImage(SingleImageConfiguration image, ServiceHub hub) throws MojoExecutionException {
        if (image.getFinalImageHash().isPresent()) {
            String imageHash = image.getFinalImageHash().get();
            for (String imageNameWithTag : image.getImageNames()) {
                String fullImageName = this.getFullImageNameWithPushRegistry(imageNameWithTag);
                this.getLog().info((CharSequence)("Tagging container image " + imageHash + " as " + fullImageName));
                hub.getPodmanExecutorService().tag(imageHash, fullImageName);
            }
        } else {
            this.getLog().info((CharSequence)"No image hash available. Skipping tagging container image.");
        }
    }

    private void catalogContainers(List<SingleImageConfiguration> images, ServiceHub hub) throws MojoExecutionException {
        if (this.skipCatalog) {
            this.getLog().info((CharSequence)"Skipping attaching of catalog artifact.");
        } else {
            List<String> containerCatalog = this.getContainerCatalog(images);
            if (containerCatalog.isEmpty()) {
                this.getLog().info((CharSequence)"No containers were catalogued.");
                return;
            }
            containerCatalog.add(0, "[containers]");
            String catalogFileName = String.format("%s.txt", "container-catalog");
            Path catalogPath = Paths.get(this.project.getBuild().getDirectory(), catalogFileName);
            try {
                Files.write(catalogPath, containerCatalog, new OpenOption[0]);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Failed to write catalog file! Caught: " + e.getMessage()));
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            this.getLog().info((CharSequence)("Attaching catalog artifact: " + catalogPath));
            hub.getMavenProjectHelper().attachArtifact(this.project, "txt", "container-catalog", catalogPath.toFile());
        }
    }

    private List<String> getContainerCatalog(List<SingleImageConfiguration> images) {
        return images.stream().filter(AbstractImageConfiguration::isValid).map(this::singleImageConfigurationToFullImageList).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

