/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.command.podman;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import nl.lexemmens.podman.command.AbstractCommand;
import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.enumeration.CGroupManager;
import nl.lexemmens.podman.enumeration.TlsVerify;
import nl.lexemmens.podman.executor.CommandExecutorDelegate;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractPodmanCommand
extends AbstractCommand {
    private static final String BASE_COMMAND = "podman";
    private static final String ROOT_CMD = "--root=";
    private static final String RUNROOT_CMD = "--runroot=";
    private final boolean redirectError;
    private final List<String> command;
    private final TlsVerify tlsVerify;
    private final CGroupManager cGroupManager;
    private final File podmanRoot;
    private final File podmanRunRoot;

    protected AbstractPodmanCommand(Log log, PodmanConfiguration podmanConfig, CommandExecutorDelegate delegate, String subCommand, boolean redirectError) {
        super(log, delegate, podmanConfig.getRunDirectory());
        this.tlsVerify = podmanConfig.getTlsVerify();
        this.cGroupManager = podmanConfig.getCgroupManager();
        this.podmanRoot = podmanConfig.getRoot();
        this.podmanRunRoot = podmanConfig.getRunRoot();
        this.redirectError = redirectError;
        this.command = this.createBaseCommand(subCommand);
    }

    @Override
    protected List<String> getCommand() {
        return this.command;
    }

    @Override
    protected boolean redirectError() {
        return this.redirectError;
    }

    protected void withOption(String option, String optionValue) {
        String subCommand = optionValue == null ? option : String.format("%s=%s", option, optionValue);
        this.command.add(subCommand);
    }

    private List<String> createBaseCommand(String subCommand) {
        ArrayList<String> baseCommand = new ArrayList<String>();
        baseCommand.add(BASE_COMMAND);
        if (this.podmanRoot != null) {
            baseCommand.add(ROOT_CMD + this.podmanRoot.getAbsolutePath());
        }
        if (this.podmanRunRoot != null) {
            baseCommand.add(RUNROOT_CMD + this.podmanRunRoot.getAbsolutePath());
        }
        if (this.cGroupManager != null) {
            baseCommand.add(this.cGroupManager.getCommand());
        }
        baseCommand.add(subCommand);
        if (this.isTlsSupported(subCommand) && this.tlsVerify != null && !TlsVerify.NOT_SPECIFIED.equals((Object)this.tlsVerify)) {
            baseCommand.add(this.tlsVerify.getCommand());
        }
        return baseCommand;
    }

    private boolean isTlsSupported(String subCommand) {
        return !"version".equals(subCommand) && !"tag".equals(subCommand) && !"save".equals(subCommand) && !"rmi".equals(subCommand);
    }
}

