/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.config.image;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.lexemmens.podman.enumeration.ContainerFormat;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractImageBuildConfiguration {
    protected static final Pattern MULTISTAGE_CONTAINERFILE_REGEX = Pattern.compile("(FROM\\s[a-zA-Z0-9./:_\\-${}]{0,255}\\s)([ASas]{2}\\s)([a-zA-Z0-9./:_\\-]{1,128})");
    protected static final String DEFAULT_CONTAINERFILE = "Containerfile";
    @Parameter
    protected File containerFileDir;
    @Parameter
    protected boolean noCache;
    @Parameter
    protected Boolean pull;
    @Parameter
    protected Boolean pullAlways;
    @Parameter
    protected String[] tags;
    @Parameter
    protected String containerFile;
    @Parameter
    private Map<String, String> args;
    @Parameter
    protected Map<String, String> labels;
    @Parameter
    protected boolean tagWithMavenProjectVersion;
    protected String mavenProjectVersion;
    @Parameter
    protected boolean createLatestTag;
    @Parameter
    protected ContainerFormat format;
    @Parameter
    protected Boolean squash;
    @Parameter
    protected Boolean squashAll;
    @Parameter
    protected Boolean layers;
    @Parameter
    protected String platform;
    @Parameter
    protected String targetStage;
    protected File outputDirectory;
    private boolean isMultistageContainerFile;
    protected boolean valid;

    public boolean isNoCache() {
        return this.noCache;
    }

    public Optional<Boolean> getPull() {
        return Optional.ofNullable(this.pull);
    }

    public Optional<Boolean> getPullAlways() {
        return Optional.ofNullable(this.pullAlways);
    }

    public void validate(MavenProject project) {
        if (this.containerFile == null) {
            this.containerFile = DEFAULT_CONTAINERFILE;
        }
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        if (this.format == null) {
            this.format = ContainerFormat.OCI;
        }
        this.mavenProjectVersion = project.getVersion();
        this.outputDirectory = new File(project.getBuild().getDirectory());
        if (this.containerFileDir == null) {
            this.containerFileDir = project.getBasedir();
        }
        if (this.args == null) {
            this.args = new HashMap<String, String>();
        }
    }

    public List<String> getAllTags() {
        ArrayList<String> allTags = new ArrayList<String>();
        if (this.tags != null) {
            allTags.addAll(Arrays.asList(this.tags));
        }
        if (this.createLatestTag) {
            allTags.add("latest");
        }
        if (this.tagWithMavenProjectVersion) {
            allTags.add(this.mavenProjectVersion);
        }
        return allTags;
    }

    public Path getTargetContainerFile() {
        return Paths.get(this.outputDirectory.toURI()).resolve(this.containerFile);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public ContainerFormat getFormat() {
        return this.format;
    }

    public boolean isMultistageContainerFile() {
        return this.isMultistageContainerFile;
    }

    public Pattern getMultistageContainerfilePattern() {
        return MULTISTAGE_CONTAINERFILE_REGEX;
    }

    public Boolean getSquash() {
        return this.squash;
    }

    public Boolean getSquashAll() {
        return this.squashAll;
    }

    public Boolean getLayers() {
        return this.layers;
    }

    public Optional<String> getPlatform() {
        return Optional.ofNullable(this.platform);
    }

    public Optional<String> getTargetStage() {
        return Optional.ofNullable(this.targetStage);
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isCreateLatestTag() {
        return this.createLatestTag;
    }

    protected boolean isContainerFileEmpty(Log log, Path fullContainerFilePath) throws MojoExecutionException {
        try {
            return 0L == Files.size(fullContainerFilePath);
        }
        catch (IOException e) {
            String msg = "Unable to determine if Containerfile is empty.";
            log.error((CharSequence)msg, (Throwable)e);
            throw new MojoExecutionException(msg, (Exception)e);
        }
    }

    protected void determineBuildStages(Log log, Path fullContainerFilePath) throws MojoExecutionException {
        boolean foundTargetStage = false;
        try (Stream<String> containerFileStream = Files.lines(fullContainerFilePath);){
            List content = containerFileStream.filter(c -> !c.matches("^\\s*#.*")).collect(Collectors.toList());
            for (String line : content) {
                Matcher matcher = MULTISTAGE_CONTAINERFILE_REGEX.matcher(line);
                if (!matcher.find()) continue;
                this.isMultistageContainerFile = true;
                String stage = matcher.group(3);
                if (Objects.equals(stage, this.targetStage)) {
                    foundTargetStage = true;
                }
                log.debug((CharSequence)("Found a stage named: " + stage));
            }
        }
        catch (IOException e) {
            String msg = "Unable to determine if Containerfile is a multistage Containerfile.";
            log.error((CharSequence)msg, (Throwable)e);
            throw new MojoExecutionException(msg, (Exception)e);
        }
        if (this.targetStage != null && this.isMultistageContainerFile && !foundTargetStage) {
            String msg = String.format("Target stage '%s' was not found in the given Containerfile.", this.targetStage);
            log.error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
    }

    public void setLayers(Boolean layers) {
        this.layers = layers;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setNoCache(boolean noCache) {
        this.noCache = noCache;
    }

    public void setPull(Boolean pull) {
        this.pull = pull;
    }

    public void setPullAlways(Boolean pullAlways) {
        this.pullAlways = pullAlways;
    }

    public void setSquash(Boolean squash) {
        this.squash = squash;
    }

    public void setSquashAll(Boolean squashAll) {
        this.squashAll = squashAll;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public void setContainerFile(String containerFile) {
        this.containerFile = containerFile;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public void setTagWithMavenProjectVersion(boolean tagWithMavenProjectVersion) {
        this.tagWithMavenProjectVersion = tagWithMavenProjectVersion;
    }

    public void setCreateLatestTag(boolean createLatestTag) {
        this.createLatestTag = createLatestTag;
    }

    public void setFormat(ContainerFormat format) {
        this.format = format;
    }

    public void setContainerFileDir(File containerFileDir) {
        this.containerFileDir = containerFileDir;
    }

    public void setTargetStage(String targetStage) {
        this.targetStage = targetStage;
    }

    public Map<String, String> getArgs() {
        return this.args;
    }

    public void setArgs(Map<String, String> args) {
        this.args = args;
    }
}

