/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.config.image;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import nl.lexemmens.podman.config.image.AbstractImageBuildConfiguration;
import nl.lexemmens.podman.config.image.StageConfiguration;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractImageConfiguration<T extends AbstractImageBuildConfiguration> {
    @Parameter
    protected String name;
    @Parameter(defaultValue="false")
    protected boolean customImageNameForMultiStageContainerfile;
    @Parameter
    protected StageConfiguration[] stages;
    private String finalImageHash;
    private final Map<String, String> imageHashPerStage = new HashMap<String, String>();

    public abstract T getBuild();

    public final Optional<String> getFinalImageHash() {
        return Optional.ofNullable(this.finalImageHash);
    }

    public final Map<String, String> getImageHashPerStage() {
        return this.imageHashPerStage;
    }

    public final void setFinalImageHash(String finalImageHash) {
        this.finalImageHash = finalImageHash;
    }

    public boolean useCustomImageNameForMultiStageContainerfile() {
        return this.customImageNameForMultiStageContainerfile;
    }

    public StageConfiguration[] getStages() {
        return this.stages;
    }

    public List<String> getImageNames() {
        ArrayList<String> imageNames = new ArrayList<String>();
        for (String tag : ((AbstractImageBuildConfiguration)this.getBuild()).getAllTags()) {
            imageNames.add(String.format("%s:%s", this.name, tag));
        }
        return imageNames;
    }

    public List<String> getImageNamesByStage(String stageName) {
        ArrayList<String> imageNames = new ArrayList<String>();
        for (StageConfiguration stage : this.stages) {
            if (!stageName.equals(stage.getName())) continue;
            for (String tag : ((AbstractImageBuildConfiguration)this.getBuild()).getAllTags()) {
                imageNames.add(String.format("%s:%s", stage.getImageName(), tag));
            }
        }
        return imageNames;
    }

    public void initAndValidate(Log log) throws MojoExecutionException {
        if (!this.customImageNameForMultiStageContainerfile && this.name == null) {
            String msg = "Image name must not be null, must be alphanumeric and may contain slashes, such as: valid/image/name";
            log.error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
        if (this.customImageNameForMultiStageContainerfile && this.stages == null) {
            String msg = "Plugin is configured for multistage Containerfiles, but there are no custom image names configured.";
            log.error((CharSequence)msg);
            throw new MojoExecutionException(msg);
        }
    }

    public String getImageName() {
        return this.name;
    }

    public boolean isValid() {
        return ((AbstractImageBuildConfiguration)this.getBuild()).isValid();
    }

    public void setImageName(String name) {
        this.name = name;
    }

    public void setCustomImageNameForMultiStageContainerfile(boolean customImageNameForMultiStageContainerfile) {
        this.customImageNameForMultiStageContainerfile = customImageNameForMultiStageContainerfile;
    }

    public void setStages(StageConfiguration[] stages) {
        this.stages = stages;
    }
}

