/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.helper;

import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import nl.lexemmens.podman.config.image.StageConfiguration;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;
import nl.lexemmens.podman.helper.ParameterReplacer;
import org.apache.maven.project.MavenProject;

public class ImageNameHelper {
    private final MavenProject mavenProject;
    private final ParameterReplacer parameterReplacer;

    public ImageNameHelper(MavenProject mavenProject) {
        this.mavenProject = mavenProject;
        this.parameterReplacer = new ParameterReplacer(this.initReplacements());
    }

    public void adaptReplacemeents(SingleImageConfiguration imageConfiguration) {
        this.parameterReplacer.adaptReplacements(imageConfiguration);
    }

    public void formatImageName(SingleImageConfiguration imageConfiguration) {
        String imageName = this.parameterReplacer.replace(imageConfiguration.getImageName());
        imageConfiguration.setImageName(imageName);
        if (imageConfiguration.useCustomImageNameForMultiStageContainerfile() && imageConfiguration.getStages() != null && imageConfiguration.getStages().length > 0) {
            for (StageConfiguration stage : imageConfiguration.getStages()) {
                if (stage.getImageName() == null) {
                    stage.setImageName(imageName);
                    continue;
                }
                String stageImageName = this.parameterReplacer.replace(stage.getImageName());
                stage.setImageName(stageImageName);
            }
        }
    }

    private Map<String, ParameterReplacer.Replacement> initReplacements() {
        HashMap<String, ParameterReplacer.Replacement> replacements = new HashMap<String, ParameterReplacer.Replacement>();
        replacements.put("a", new ArtifactIdReplacement());
        replacements.put("d", new ContainerFileDirectoryReplacement());
        replacements.put("g", new GroupIdReplacement());
        replacements.put("n", new ImageNumberReplacement());
        replacements.put("l", new SnapshotLatestReplacement());
        replacements.put("t", new SnapshotTimestampReplacement());
        replacements.put("v", new ProjectVersionReplacement());
        return replacements;
    }

    private static String alignWithNamingConvention(String imageName) {
        StringBuilder ret = new StringBuilder();
        int underscores = 0;
        boolean lastWasADot = false;
        for (char character : imageName.toCharArray()) {
            if (character == '_') {
                if (++underscores > 2) continue;
                ret.append(character);
                continue;
            }
            if (character == '.') {
                if (!lastWasADot) {
                    ret.append(character);
                }
                lastWasADot = true;
                continue;
            }
            underscores = 0;
            lastWasADot = false;
            if (!Character.isLetter(character) && !Character.isDigit(character) && character != '-') continue;
            ret.append(character);
        }
        return ret.toString().toLowerCase();
    }

    private static class ImageNumberReplacement
    implements ParameterReplacer.Replacement {
        AtomicInteger imageNumber = new AtomicInteger(0);

        private ImageNumberReplacement() {
        }

        @Override
        public void adaptReplacement(SingleImageConfiguration notUsed) {
        }

        @Override
        public String get() {
            return ImageNameHelper.alignWithNamingConvention(String.format("%s", this.imageNumber.getAndIncrement()));
        }
    }

    private static class ContainerFileDirectoryReplacement
    implements ParameterReplacer.Replacement {
        Path containerFileDirectory;

        private ContainerFileDirectoryReplacement() {
        }

        @Override
        public void adaptReplacement(SingleImageConfiguration image) {
            this.containerFileDirectory = image.getBuild().getSourceContainerFileDir();
        }

        @Override
        public String get() {
            return ImageNameHelper.alignWithNamingConvention(this.containerFileDirectory.getParent().getFileName().toString());
        }
    }

    private static class SnapshotTimestampReplacement
    implements ParameterReplacer.Replacement {
        private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd-HHmmss-SSSS");

        private SnapshotTimestampReplacement() {
        }

        @Override
        public void adaptReplacement(SingleImageConfiguration notUsed) {
        }

        @Override
        public String get() {
            Calendar now = Calendar.getInstance();
            this.dateFormat.setTimeZone(now.getTimeZone());
            return ImageNameHelper.alignWithNamingConvention("snapshot-" + this.dateFormat.format(now.getTime()));
        }
    }

    private class GroupIdReplacement
    implements ParameterReplacer.Replacement {
        private GroupIdReplacement() {
        }

        @Override
        public void adaptReplacement(SingleImageConfiguration notUsed) {
        }

        @Override
        public String get() {
            String groupId = ImageNameHelper.this.mavenProject.getGroupId();
            int idx = groupId.lastIndexOf(46);
            if (idx != -1) {
                groupId = groupId.substring(idx + 1);
            }
            return ImageNameHelper.alignWithNamingConvention(groupId);
        }
    }

    private class SnapshotLatestReplacement
    implements ParameterReplacer.Replacement {
        private SnapshotLatestReplacement() {
        }

        @Override
        public void adaptReplacement(SingleImageConfiguration notUsed) {
        }

        @Override
        public String get() {
            String version = ImageNameHelper.this.mavenProject.getVersion();
            if (version.endsWith("-SNAPSHOT")) {
                version = "latest";
            }
            return ImageNameHelper.alignWithNamingConvention(version);
        }
    }

    private class ProjectVersionReplacement
    implements ParameterReplacer.Replacement {
        private ProjectVersionReplacement() {
        }

        @Override
        public void adaptReplacement(SingleImageConfiguration notUsed) {
        }

        @Override
        public String get() {
            return ImageNameHelper.alignWithNamingConvention(ImageNameHelper.this.mavenProject.getVersion());
        }
    }

    private class ArtifactIdReplacement
    implements ParameterReplacer.Replacement {
        private ArtifactIdReplacement() {
        }

        @Override
        public void adaptReplacement(SingleImageConfiguration notUsed) {
        }

        @Override
        public String get() {
            return ImageNameHelper.alignWithNamingConvention(ImageNameHelper.this.mavenProject.getArtifactId());
        }
    }
}

