/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.helper;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nl.lexemmens.podman.config.image.single.SingleImageConfiguration;

public class ParameterReplacer {
    private static final Pattern FORMATTER_PATTERN = Pattern.compile("^(.*?)%([a-zA-Z])(.*)$");
    private final Map<String, Replacement> replacementMap;

    public ParameterReplacer(Map<String, Replacement> replacementMap) {
        this.replacementMap = replacementMap;
    }

    public void adaptReplacements(SingleImageConfiguration imageConfiguration) {
        this.replacementMap.values().forEach(replacement -> replacement.adaptReplacement(imageConfiguration));
    }

    public String replace(String input) {
        StringBuilder ret = new StringBuilder();
        while (true) {
            Matcher matcher;
            if (!(matcher = FORMATTER_PATTERN.matcher(input)).matches()) {
                ret.append(input);
                return ret.toString();
            }
            ret.append(matcher.group(1));
            ret.append(this.formatElement(matcher.group(2)));
            input = matcher.group(3);
        }
    }

    private String formatElement(String what) {
        Replacement lookup = this.replacementMap.get(what);
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("No image name format element '%%%s' known", what));
        }
        String val = lookup.get();
        return String.format("%s", val);
    }

    public static interface Replacement {
        public void adaptReplacement(SingleImageConfiguration var1);

        public String get();
    }
}

