/*
 * Decompiled with CFR 0.152.
 */
package nl.lexemmens.podman.service;

import nl.lexemmens.podman.config.podman.PodmanConfiguration;
import nl.lexemmens.podman.config.skopeo.SkopeoConfiguration;
import nl.lexemmens.podman.executor.CommandExecutorDelegateImpl;
import nl.lexemmens.podman.service.AuthenticationService;
import nl.lexemmens.podman.service.BuildahExecutorService;
import nl.lexemmens.podman.service.ContainerfileDecorator;
import nl.lexemmens.podman.service.PodmanExecutorService;
import nl.lexemmens.podman.service.SecurityContextService;
import nl.lexemmens.podman.service.SkopeoExecutorService;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.shared.filtering.MavenFileFilter;

public class ServiceHub {
    private final PodmanExecutorService podmanExecutorService;
    private final BuildahExecutorService buildahExecutorService;
    private final SkopeoExecutorService skopeoExecutorService;
    private final ContainerfileDecorator containerfileDecorator;
    private final AuthenticationService authenticationService;
    private final MavenProjectHelper mavenProjectHelper;
    private final SecurityContextService securityContextService;

    ServiceHub(Log log, MavenProject mavenProject, MavenFileFilter mavenFileFilter, PodmanConfiguration podmanConfig, SkopeoConfiguration skopeoConfiguration, Settings mavenSettings, SettingsDecrypter settingsDecrypter, MavenProjectHelper mavenProjectHelper) {
        this.podmanExecutorService = new PodmanExecutorService(log, podmanConfig, new CommandExecutorDelegateImpl());
        this.buildahExecutorService = new BuildahExecutorService(log, podmanConfig, new CommandExecutorDelegateImpl());
        this.skopeoExecutorService = new SkopeoExecutorService(log, skopeoConfiguration, new CommandExecutorDelegateImpl());
        this.containerfileDecorator = new ContainerfileDecorator(log, mavenFileFilter, mavenProject);
        this.authenticationService = new AuthenticationService(log, this.podmanExecutorService, mavenSettings, settingsDecrypter);
        this.securityContextService = new SecurityContextService(log, podmanConfig, new CommandExecutorDelegateImpl());
        this.mavenProjectHelper = mavenProjectHelper;
    }

    public ContainerfileDecorator getContainerfileDecorator() {
        return this.containerfileDecorator;
    }

    public AuthenticationService getAuthenticationService() {
        return this.authenticationService;
    }

    public PodmanExecutorService getPodmanExecutorService() {
        return this.podmanExecutorService;
    }

    public BuildahExecutorService getBuildahExecutorService() {
        return this.buildahExecutorService;
    }

    public MavenProjectHelper getMavenProjectHelper() {
        return this.mavenProjectHelper;
    }

    public SkopeoExecutorService getSkopeoExecutorService() {
        return this.skopeoExecutorService;
    }

    public SecurityContextService getSecurityContextService() {
        return this.securityContextService;
    }
}

