/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.emoji.ColorResolver;
import net.sourceforge.plantuml.emoji.GrayLevelRange;
import net.sourceforge.plantuml.emoji.UGraphicWithScale;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.ColorUtils;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.klimt.sprite.Sprite;
import net.sourceforge.plantuml.openiconic.SvgPath;

public class SvgNanoParser
implements Sprite,
GrayLevelRange {
    private static final Pattern P_TEXT_OR_DRAW = Pattern.compile("(\\<text .*?\\</text\\>)|(\\<(svg|path|g|circle|ellipse)[^<>]*\\>)|(\\</[^<>]*\\>)");
    private static final Pattern P_TEXT = Pattern.compile("\\<text[^<>]*\\>(.*?)\\</text\\>");
    private static final Pattern P_FONT_SIZE = Pattern.compile("^(\\d+)p[tx]$");
    private static final Pattern P_MATRIX = Pattern.compile("matrix\\(([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)\\)");
    private static final Pattern P_ROTATE = Pattern.compile("rotate\\(([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)\\)");
    private static final Pattern P_TRANSLATE1 = Pattern.compile("translate\\(([-.0-9]+)[ ,]+([-.0-9]+)\\)");
    private static final Pattern P_TRANSLATE2 = Pattern.compile("translate\\(([-.0-9]+)\\)");
    private static final Pattern P_SCALE1 = Pattern.compile("scale\\(([-.0-9]+)\\)");
    private static final Pattern P_SCALE2 = Pattern.compile("scale\\(([-.0-9]+)[ ,]+([-.0-9]+)\\)");
    private static final String equals_something = "=\"([^\"]+)\"";
    private static final Pattern DATA_CX = Pattern.compile("cx=\"([^\"]+)\"");
    private static final Pattern DATA_CY = Pattern.compile("cy=\"([^\"]+)\"");
    private static final Pattern DATA_FILL = Pattern.compile("fill=\"([^\"]+)\"");
    private static final Pattern DATA_FONT_FAMILY = Pattern.compile("font-family=\"([^\"]+)\"");
    private static final Pattern DATA_FONT_SIZE = Pattern.compile("font-size=\"([^\"]+)\"");
    private static final Pattern DATA_R = Pattern.compile("r=\"([^\"]+)\"");
    private static final Pattern DATA_RX = Pattern.compile("rx=\"([^\"]+)\"");
    private static final Pattern DATA_RY = Pattern.compile("ry=\"([^\"]+)\"");
    private static final Pattern DATA_STROKE = Pattern.compile("stroke=\"([^\"]+)\"");
    private static final Pattern DATA_STROKE_WIDTH = Pattern.compile("stroke-width=\"([^\"]+)\"");
    private static final Pattern DATA_STYLE = Pattern.compile("style=\"([^\"]+)\"");
    private static final Pattern DATA_TRANSFORM = Pattern.compile("transform=\"([^\"]+)\"");
    private static final Pattern DATA_X = Pattern.compile("x=\"([^\"]+)\"");
    private static final Pattern DATA_Y = Pattern.compile("y=\"([^\"]+)\"");
    private static final String colon_something = ":([^;\"]+)";
    private static final Pattern STYLE_FILL = Pattern.compile(Pattern.quote("fill") + ":([^;\"]+)");
    private static final Pattern STYLE_FONT_SIZE = Pattern.compile(Pattern.quote("font-size") + ":([^;\"]+)");
    private static final Pattern STYLE_FONT_FAMILY = Pattern.compile(Pattern.quote("font-family") + ":([^;\"]+)");
    private final List<String> data = new ArrayList<String>();
    private int minGray = 999;
    private int maxGray = -1;
    private List<String> svg;

    private String extract(Pattern p, String s) {
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public SvgNanoParser(String svg) {
        this(Collections.singletonList(svg));
    }

    public SvgNanoParser(List<String> svg) {
        this.svg = svg;
    }

    public void drawU(UGraphic ug, double scale, HColor fontColor, HColor forcedColor) {
        ColorResolver colorResolver = new ColorResolver(fontColor, forcedColor, this);
        UGraphicWithScale ugs = new UGraphicWithScale(ug, colorResolver, scale);
        ArrayList<UGraphicWithScale> stack = new ArrayList<UGraphicWithScale>();
        ArrayDeque<String> stackG = new ArrayDeque<String>();
        for (String s : this.getData()) {
            if (s.startsWith("<path ")) {
                this.drawPath(ugs, s, stackG);
                continue;
            }
            if (s.startsWith("</g>")) {
                ugs = (UGraphicWithScale)stack.remove(0);
                stackG.removeFirst();
                continue;
            }
            if (s.startsWith("<g>")) {
                stack.add(0, ugs);
                stackG.addFirst(s);
                continue;
            }
            if (s.startsWith("<g ")) {
                stack.add(0, ugs);
                stackG.addFirst(s);
                ugs = this.applyFillAndStroke(ugs, s, stackG);
                ugs = this.applyTransform(ugs, s);
                continue;
            }
            if (s.startsWith("<circle ")) {
                this.drawCircle(ugs, s, stackG);
                continue;
            }
            if (s.startsWith("<ellipse ")) {
                this.drawEllipse(ugs, s, stackG);
                continue;
            }
            if (s.startsWith("<text ")) {
                this.drawText(ugs, s, stackG);
                continue;
            }
            System.err.println("**?=" + s);
        }
    }

    private synchronized Collection<String> getData() {
        if (this.data.isEmpty()) {
            for (String singleLine : this.svg) {
                Matcher m = P_TEXT_OR_DRAW.matcher(singleLine);
                while (m.find()) {
                    String s = m.group(0);
                    if (s.startsWith("<path") || s.startsWith("<g ") || s.startsWith("<g>") || s.startsWith("</g>") || s.startsWith("<circle ") || s.startsWith("<ellipse ") || s.startsWith("<text ")) {
                        this.data.add(s);
                        continue;
                    }
                    if (s.startsWith("<svg") || s.startsWith("</svg")) continue;
                    System.err.println("???=" + s);
                }
            }
        }
        return Collections.unmodifiableCollection(this.data);
    }

    private UGraphicWithScale applyFillAndStroke(UGraphicWithScale ugs, String s, Deque<String> stackG) {
        String fillString = this.getFillString(s, stackG);
        String strokeString = this.extract(DATA_STROKE, s);
        String strokeWidth = this.extract(DATA_STROKE_WIDTH, s);
        if (strokeWidth != null) {
            double scale = ugs.getScale();
            ugs = ugs.apply(UStroke.withThickness(scale * Double.parseDouble(strokeWidth)));
        }
        if (strokeString != null) {
            HColor stroke = ugs.getTrueColor(strokeString);
            ugs = ugs.apply(stroke);
            if (fillString == null) {
                return ugs.apply(ugs.getDefaultColor().bg());
            }
        }
        if ("none".equals(fillString)) {
            ugs = ugs.apply(HColors.none().bg());
        } else {
            HColor fill;
            HColor hColor = fill = fillString == null ? ugs.getDefaultColor() : ugs.getTrueColor(fillString);
            if (strokeString == null) {
                ugs = ugs.apply(fill);
            }
            ugs = ugs.apply(fill.bg());
        }
        return ugs;
    }

    private void drawCircle(UGraphicWithScale ugs, String s, Deque<String> stackG) {
        ugs = this.applyFillAndStroke(ugs, s, stackG);
        ugs = this.applyTransform(ugs, s);
        double scalex = ugs.getAffineTransform().getScaleX();
        double scaley = ugs.getAffineTransform().getScaleY();
        double deltax = ugs.getAffineTransform().getTranslateX();
        double deltay = ugs.getAffineTransform().getTranslateY();
        double cx = Double.parseDouble(this.extract(DATA_CX, s)) * scalex;
        double cy = Double.parseDouble(this.extract(DATA_CY, s)) * scaley;
        double rx = Double.parseDouble(this.extract(DATA_R, s)) * scalex;
        double ry = Double.parseDouble(this.extract(DATA_R, s)) * scaley;
        UTranslate translate = new UTranslate(deltax + cx - rx, deltay + cy - ry);
        ugs.apply(translate).draw(UEllipse.build(rx * 2.0, ry * 2.0));
    }

    private void drawEllipse(UGraphicWithScale ugs, String s, Deque<String> stackG) {
        boolean debug = false;
        ugs = this.applyFillAndStroke(ugs, s, stackG);
        ugs = this.applyTransform(ugs, s);
        double cx = Double.parseDouble(this.extract(DATA_CX, s));
        double cy = Double.parseDouble(this.extract(DATA_CY, s));
        double rx = Double.parseDouble(this.extract(DATA_RX, s));
        double ry = Double.parseDouble(this.extract(DATA_RY, s));
        UPath path = UPath.none();
        path.moveTo(0.0, ry);
        path.arcTo(rx, ry, 0.0, 0.0, 1.0, rx, 0.0);
        path.arcTo(rx, ry, 0.0, 0.0, 1.0, 2.0 * rx, ry);
        path.arcTo(rx, ry, 0.0, 0.0, 1.0, rx, 2.0 * ry);
        path.arcTo(rx, ry, 0.0, 0.0, 1.0, 0.0, ry);
        path.closePath();
        path = path.translate(cx - rx, cy - ry);
        path = path.affine(ugs.getAffineTransform(), ugs.getAngle(), ugs.getScale());
        ugs.draw(path);
    }

    private void drawText(UGraphicWithScale ugs, String s, Deque<String> stackG) {
        double x = Double.parseDouble(this.extract(DATA_X, s));
        double y = Double.parseDouble(this.extract(DATA_Y, s));
        String fontColor = this.getFillString(s, stackG);
        int fontSize = this.getTextFontSize(s);
        Matcher m = P_TEXT.matcher(s);
        if (m.find()) {
            String text = m.group(1);
            HColor color = HColorSet.instance().getColorOrWhite(fontColor);
            String fontFamily = this.getTextFontFamily(s, stackG);
            if (fontFamily == null) {
                fontFamily = "SansSerif";
            }
            UFont font = UFont.build(fontFamily, 0, fontSize);
            FontConfiguration fc = FontConfiguration.create(font, color, color, null);
            UText utext = UText.build(text, fc);
            UGraphic ug = ugs.getUg();
            ug = ug.apply(new UTranslate(x, y));
            ug.draw(utext);
        }
    }

    private String getTextFontFamily(String s, Deque<String> stackG) {
        String style;
        String family = this.extract(DATA_FONT_FAMILY, s);
        if (family == null && (style = this.extract(DATA_STYLE, s)) != null) {
            family = this.extract(STYLE_FONT_FAMILY, style);
        }
        if (family == null && stackG != null) {
            for (String g : stackG) {
                family = this.getTextFontFamily(g, null);
                if (family == null) continue;
                return family;
            }
        }
        return family;
    }

    private String getFillString(String s, Deque<String> stackG) {
        String style;
        String color = this.extract(DATA_FILL, s);
        if (color == null && (style = this.extract(DATA_STYLE, s)) != null) {
            color = this.extract(STYLE_FILL, style);
        }
        if (color == null && stackG != null) {
            for (String g : stackG) {
                color = this.getFillString(g, null);
                if (color == null) continue;
                return color;
            }
        }
        return color;
    }

    private int getTextFontSize(String s) {
        String style;
        String fontSize = this.extract(DATA_FONT_SIZE, s);
        if (fontSize == null && (style = this.extract(DATA_STYLE, s)) != null) {
            fontSize = this.extract(STYLE_FONT_SIZE, style);
        }
        if (fontSize == null) {
            return 14;
        }
        Matcher matcher = P_FONT_SIZE.matcher(fontSize);
        if (matcher.matches()) {
            return Integer.parseInt(fontSize.replaceAll("[a-z]", ""));
        }
        return Integer.parseInt(fontSize);
    }

    private void drawPath(UGraphicWithScale ugs, String s, Deque<String> stackG) {
        s = s.replace("id=\"", "ID=\"");
        ugs = this.applyFillAndStroke(ugs, s, stackG);
        ugs = this.applyTransform(ugs, s);
        int x1 = s.indexOf("d=\"");
        int x2 = s.indexOf(34, x1 + 3);
        String tmp = s.substring(x1 + 3, x2);
        SvgPath svgPath = new SvgPath(tmp, UTranslate.none());
        svgPath.drawMe(ugs.getUg(), ugs.getAffineTransform());
    }

    private UGraphicWithScale applyTransform(UGraphicWithScale ugs, String s) {
        String transform = this.extract(DATA_TRANSFORM, s);
        if (transform == null) {
            return ugs;
        }
        if (transform.contains("rotate(")) {
            return this.applyRotate(ugs, transform);
        }
        if (transform.contains("matrix(")) {
            return this.applyMatrix(ugs, transform);
        }
        double[] scale = this.getScale(transform);
        UTranslate translate = this.getTranslate(transform);
        ugs = ugs.applyTranslate(translate.getDx(), translate.getDy());
        return ugs.applyScale(scale[0], scale[1]);
    }

    private UGraphicWithScale applyMatrix(UGraphicWithScale ugs, String transform) {
        Matcher m3 = P_MATRIX.matcher(transform);
        if (m3.find()) {
            double v1 = Double.parseDouble(m3.group(1));
            double v2 = Double.parseDouble(m3.group(2));
            double v3 = Double.parseDouble(m3.group(3));
            double v4 = Double.parseDouble(m3.group(4));
            double v5 = Double.parseDouble(m3.group(5));
            double v6 = Double.parseDouble(m3.group(6));
            ugs = ugs.applyMatrix(v1, v2, v3, v4, v5, v6);
        } else {
            System.err.println("WARNING: " + transform);
        }
        return ugs;
    }

    private UGraphicWithScale applyRotate(UGraphicWithScale ugs, String transform) {
        Matcher m3 = P_ROTATE.matcher(transform);
        if (m3.find()) {
            double angle = Double.parseDouble(m3.group(1));
            double x = Double.parseDouble(m3.group(2));
            double y = Double.parseDouble(m3.group(3));
            ugs = ugs.applyRotate(angle, x, y);
        } else {
            System.err.println("WARNING: " + transform);
        }
        return ugs;
    }

    private UTranslate getTranslate(String transform) {
        double x = 0.0;
        double y = 0.0;
        Matcher m3 = P_TRANSLATE1.matcher(transform);
        if (m3.find()) {
            x = Double.parseDouble(m3.group(1));
            y = Double.parseDouble(m3.group(2));
        } else {
            Matcher m4 = P_TRANSLATE2.matcher(transform);
            if (m4.find()) {
                x = Double.parseDouble(m4.group(1));
                y = Double.parseDouble(m4.group(1));
            }
        }
        return new UTranslate(x, y);
    }

    private double[] getScale(String transform) {
        double[] scale = new double[]{1.0, 1.0};
        Matcher m1 = P_SCALE1.matcher(transform);
        if (m1.find()) {
            scale[0] = Double.parseDouble(m1.group(1));
            scale[1] = scale[0];
        } else {
            Matcher m2 = P_SCALE2.matcher(transform);
            if (m2.find()) {
                scale[0] = Double.parseDouble(m2.group(1));
                scale[1] = Double.parseDouble(m2.group(2));
            }
        }
        return scale;
    }

    @Override
    public TextBlock asTextBlock(final HColor fontColor, final HColor forcedColor, final double scale) {
        UImageSvg data = new UImageSvg(this.svg.get(0), scale);
        final double width = data.getWidth();
        final double height = data.getHeight();
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                SvgNanoParser.this.drawU(ug, scale, fontColor, forcedColor);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }

    private void computeMinMaxGray() {
        for (String s : this.getData()) {
            if (!s.contains("<path ") && !s.contains("<g ") && !s.contains("<circle ") && !s.contains("<ellipse ")) continue;
            String fillString = this.getFillString(s, null);
            String strokeString = this.extract(DATA_STROKE, s);
            this.updateMinMax(strokeString);
            this.updateMinMax(fillString);
        }
    }

    private void updateMinMax(String colorString) {
        if (colorString != null) {
            HColor color = HColorSet.instance().getColorOrWhite(colorString);
            int gray = ColorUtils.getGrayScaleColor(color.toColor(ColorMapper.MONOCHROME)).getGreen();
            this.minGray = Math.min(this.minGray, gray);
            this.maxGray = Math.max(this.maxGray, gray);
        }
    }

    @Override
    public int getMinGrayLevel() {
        if (this.maxGray == -1) {
            this.computeMinMaxGray();
        }
        return this.minGray;
    }

    @Override
    public int getMaxGrayLevel() {
        if (this.maxGray == -1) {
            this.computeMinMaxGray();
        }
        return this.maxGray;
    }
}

