/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineConcat;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;
import net.sourceforge.plantuml.preproc.Stdlib;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.utils.Log;

public class PreprocessorUtils {
    private static final Pattern p = Pattern.compile("%(\\w+)%");
    private static final Map<String, SoftReference<byte[]>> cache = new ConcurrentHashMap<String, SoftReference<byte[]>>();

    public static String withEnvironmentVariable(String s) {
        Matcher m = p.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            String value = PreprocessorUtils.getenv(var);
            if (value == null) continue;
            m.appendReplacement(sb, Matcher.quoteReplacement(value));
        }
        m.appendTail(sb);
        s = sb.toString();
        return s;
    }

    public static String getenv(String var) {
        String env = System.getProperty(var);
        if (StringUtils.isNotEmpty(env)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(env);
        }
        String getenv = System.getenv(var);
        if (StringUtils.isNotEmpty(getenv)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(getenv);
        }
        return null;
    }

    private static InputStream getStdlibInputStream(String filename) throws IOException {
        byte[] data;
        SoftReference<byte[]> ref = cache.get(filename);
        byte[] byArray = data = ref != null ? ref.get() : null;
        if (data == null) {
            data = FileUtils.copyToByteArray(Stdlib.getResourceAsStream(filename));
            cache.put(filename, new SoftReference<byte[]>(data));
        }
        return new ByteArrayInputStream(data);
    }

    public static ReadLine getReaderNonstandardInclude(StringLocated s, String filename) {
        if (!filename.endsWith(".puml")) {
            filename = filename + ".puml";
        }
        String filename2 = filename;
        Log.info(() -> "Loading non standard " + filename2);
        String res = "/stdlib/" + filename;
        InputStream is = Stdlib.class.getResourceAsStream(res);
        if (is == null) {
            return null;
        }
        String description = "[" + filename + "]";
        return ReadLineReader.create(new InputStreamReader(is), description);
    }

    public static ReadLine getReaderStdlibInclude(StringLocated s, String filename) throws IOException {
        Log.info(() -> "Loading sdlib " + filename);
        InputStream is = PreprocessorUtils.getStdlibInputStream(filename);
        if (is == null) {
            return null;
        }
        String description = "<" + filename + ">";
        try {
            if (StartDiagramExtractReader.containsStartDiagram(is, description)) {
                is = PreprocessorUtils.getStdlibInputStream(filename);
                return StartDiagramExtractReader.build(is, description);
            }
            is = PreprocessorUtils.getStdlibInputStream(filename);
            if (is == null) {
                return null;
            }
            return ReadLineReader.create(new InputStreamReader(is), description);
        }
        catch (IOException e) {
            Logme.error(e);
            return new ReadLineSimple(s, e.toString());
        }
    }

    public static ReadLine getReaderStdlibIncludeSprites(StringLocated s, String root) throws IOException {
        Stdlib lib = Stdlib.retrieve(root);
        Collection<String> filenames = lib.getAllFilenamesWithSprites();
        ArrayList<ReadLine> readers = new ArrayList<ReadLine>();
        for (String name : filenames) {
            String data = lib.loadResource(name);
            ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes(StandardCharsets.UTF_8));
            readers.add(StartDiagramExtractReader.build(is, "<" + root + "/" + name + ">"));
        }
        return new ReadLineConcat(readers);
    }

    public static ReadLine getReaderIncludeUrl(SURL url, StringLocated s, String suf, Charset charset) throws EaterException {
        try {
            if (StartDiagramExtractReader.containsStartDiagram(url, s, charset)) {
                return StartDiagramExtractReader.build(url, s, suf, charset);
            }
            return PreprocessorUtils.getReaderInclude(url, s, charset);
        }
        catch (IOException e) {
            Logme.error(e);
            throw new EaterException("Cannot open URL " + e.getMessage(), s);
        }
    }

    public static ReadLine getReaderInclude(SURL url, StringLocated s, Charset charset) throws EaterException, UnsupportedEncodingException {
        InputStream is = url.openStream();
        if (is == null) {
            throw new EaterException("Cannot open URL", s);
        }
        return ReadLineReader.create(new InputStreamReader(is, charset), url.toString(), s.getLocation());
    }
}

