/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet;

import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;
import jdk.javadoc.doclet.StandardDoclet;
import nl.talsmasoftware.umldoclet.html.HtmlPostprocessor;
import nl.talsmasoftware.umldoclet.javadoc.DocletConfig;
import nl.talsmasoftware.umldoclet.javadoc.UMLFactory;
import nl.talsmasoftware.umldoclet.javadoc.dependencies.DependenciesElementScanner;
import nl.talsmasoftware.umldoclet.javadoc.dependencies.PackageDependency;
import nl.talsmasoftware.umldoclet.javadoc.dependencies.PackageDependencyCycle;
import nl.talsmasoftware.umldoclet.logging.Message;
import nl.talsmasoftware.umldoclet.uml.DependencyDiagram;
import nl.talsmasoftware.umldoclet.uml.Diagram;

public class UMLDoclet
extends StandardDoclet {
    private final DocletConfig config = new DocletConfig();

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.config.init(locale, reporter);
        super.init(locale, reporter);
    }

    @Override
    public String getName() {
        return "UML";
    }

    public Set<Doclet.Option> getSupportedOptions() {
        return this.config.mergeOptionsWith(super.getSupportedOptions());
    }

    @Override
    public boolean run(DocletEnvironment environment) {
        this.config.logger().info(Message.DOCLET_COPYRIGHT, new Object[]{Message.DOCLET_VERSION});
        this.config.logger().info(Message.PLANTUML_COPYRIGHT, new Object[0]);
        String delegateDocletName = this.config.delegateDocletName().orElse(null);
        if (StandardDoclet.class.getName().equals(delegateDocletName)) {
            if (!super.run(environment)) {
                return false;
            }
        } else if (delegateDocletName != null) {
            this.config.logger().error(Message.ERROR_UNSUPPORTED_DELEGATE_DOCLET, delegateDocletName);
            return false;
        }
        try {
            this.generateDiagrams(environment).forEach(Diagram::render);
            return new HtmlPostprocessor(this.config).postProcessHtml();
        }
        catch (RuntimeException unanticipatedException) {
            this.config.logger().error(Message.ERROR_UNANTICIPATED_ERROR_GENERATING_UML, unanticipatedException);
            return false;
        }
    }

    private Stream<Diagram> generateDiagrams(DocletEnvironment docEnv) {
        UMLFactory factory = new UMLFactory(this.config, docEnv);
        return Stream.concat(docEnv.getIncludedElements().stream().map(element -> this.generateDiagram(factory, (Element)element)).filter(Objects::nonNull), Stream.of(this.generatePackageDependencyDiagram(docEnv)));
    }

    private Diagram generateDiagram(UMLFactory factory, Element element) {
        if (element instanceof PackageElement) {
            return factory.createPackageDiagram((PackageElement)element);
        }
        if (element instanceof TypeElement && (element.getKind().isClass() || element.getKind().isInterface())) {
            return factory.createClassDiagram((TypeElement)element);
        }
        return null;
    }

    private DependencyDiagram generatePackageDependencyDiagram(DocletEnvironment docEnv) {
        DependenciesElementScanner scanner = new DependenciesElementScanner(docEnv, this.config);
        Set packageDependencies = (Set)scanner.scan(docEnv.getIncludedElements(), null);
        this.detectPackageDependencyCycles(packageDependencies);
        DependencyDiagram dependencyDiagram = new DependencyDiagram(this.config, scanner.getModuleName(), "package-dependencies.puml");
        packageDependencies.forEach(dep -> dependencyDiagram.addPackageDependency(dep.fromPackage, dep.toPackage));
        return dependencyDiagram;
    }

    private Set<PackageDependencyCycle> detectPackageDependencyCycles(Set<PackageDependency> packageDependencies) {
        Set<PackageDependencyCycle> cycles = PackageDependencyCycle.detectCycles(packageDependencies);
        if (!cycles.isEmpty()) {
            String cyclesString = cycles.stream().map(cycle -> " - " + String.valueOf(cycle)).collect(Collectors.joining(System.lineSeparator(), System.lineSeparator(), ""));
            if (this.config.failOnCyclicPackageDependencies()) {
                this.config.logger().error(Message.WARNING_PACKAGE_DEPENDENCY_CYCLES, cyclesString);
            } else {
                this.config.logger().warn(Message.WARNING_PACKAGE_DEPENDENCY_CYCLES, cyclesString);
            }
        }
        return cycles;
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }
}

