/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.javadoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.javadoc.PackagenameValidator;
import nl.talsmasoftware.umldoclet.logging.Message;
import nl.talsmasoftware.umldoclet.util.FileUtils;
import nl.talsmasoftware.umldoclet.util.UriUtils;

final class ExternalLink {
    private static final PackagenameValidator PACKAGENAME_VALIDATOR = new PackagenameValidator();
    private final Configuration config;
    private final URI docUri;
    private final URI baseUri;
    private Map<String, Set<String>> modules;
    private final Map<String, URI> packageUriCache = new HashMap<String, URI>();

    ExternalLink(Configuration config, String apidoc, String packageList) {
        this.config = Objects.requireNonNull(config, "Configuration is <null>.");
        this.docUri = ExternalLink.createUri(Objects.requireNonNull(apidoc, "External apidoc URI is <null>."));
        Objects.requireNonNull(packageList, "Location URI for \"package-list\" is <null>.");
        this.baseUri = ExternalLink.createUri(packageList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> modules() {
        if (this.modules == null) {
            ExternalLink externalLink = this;
            synchronized (externalLink) {
                Map<String, Set<String>> moduleMap = this.tryReadModules();
                this.modules = moduleMap.isEmpty() ? Collections.singletonMap("", this.tryReadPackages()) : moduleMap;
            }
        }
        return this.modules;
    }

    Optional<URI> resolveType(String packagename, String typeName) {
        return this.modules().entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(packagename)).findFirst().map(entry -> this.cached(packagename, () -> this.findPackageUri((String)entry.getKey(), packagename))).map(uri -> UriUtils.addPathComponent(uri, typeName + ".html")).map(uri -> UriUtils.addHttpParam(uri, "is-external", "true"));
    }

    private URI findPackageUri(String modulename, String packagename) {
        Object packagePath = packagename.replace('.', '/');
        if (!modulename.isEmpty()) {
            packagePath = modulename + "/" + (String)packagePath;
        }
        return UriUtils.addPathComponent(this.makeAbsolute(this.docUri), (String)packagePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Set<String>> tryReadModules() {
        Map<String, Set<String>> map;
        URI elementListUri = UriUtils.addPathComponent(this.baseUri, "element-list");
        LinkedHashMap modules = new LinkedHashMap();
        try (BufferedReader reader = new BufferedReader(FileUtils.openReaderTo(this.config.destinationDirectory(), elementListUri, "UTF-8"));){
            String module = "";
            String line = reader.readLine();
            while (line != null) {
                line = line.trim();
                if (module.isEmpty() && line.contains("<")) {
                    this.config.logger().debug("Ignoring {0} as it seems to contain HTML.", elementListUri);
                    Map<String, Set<String>> map2 = Collections.emptyMap();
                    return map2;
                }
                if (line.startsWith("module:")) {
                    module = line.substring("module:".length()).trim();
                } else if (PACKAGENAME_VALIDATOR.test(line)) {
                    if (!modules.containsKey(module)) {
                        modules.put(module, new LinkedHashSet());
                    }
                    ((Set)modules.get(module)).add(line);
                } else {
                    this.config.logger().debug("Skipping '{1}' (in module '{0}') as it does not look like a valid package name.", module, line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException | RuntimeException ex) {
            this.config.logger().debug((Object)Message.DEBUG_CANNOT_READ_ELEMENT_LIST, elementListUri, ex);
        }
        if (modules.isEmpty()) {
            map = Collections.emptyMap();
            return map;
        }
        map = Collections.unmodifiableMap(modules);
        return map;
    }

    private Set<String> tryReadPackages() {
        URI packageListUri = UriUtils.addPathComponent(this.baseUri, "package-list");
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        try (BufferedReader reader = new BufferedReader(FileUtils.openReaderTo(this.config.destinationDirectory(), packageListUri, "UTF-8"));){
            String line = reader.readLine();
            while (line != null) {
                if (PACKAGENAME_VALIDATOR.test(line = line.trim())) {
                    packages.add(line);
                }
                line = reader.readLine();
            }
        }
        catch (IOException | RuntimeException ex) {
            this.config.logger().warn(Message.WARNING_CANNOT_READ_PACKAGE_LIST, packageListUri, ex);
        }
        return packages.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(packages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URI cached(String packagename, Supplier<URI> uri) {
        Map<String, URI> map = this.packageUriCache;
        synchronized (map) {
            if (!this.packageUriCache.containsKey(packagename)) {
                this.packageUriCache.put(packagename, uri.get());
            }
        }
        return this.packageUriCache.get(packagename);
    }

    private URI makeAbsolute(URI uri) {
        if (uri != null && !uri.isAbsolute()) {
            uri = new File(this.config.destinationDirectory(), uri.toASCIIString()).toURI().normalize();
        }
        return uri;
    }

    private static URI createUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException use) {
            if (new File(uri).exists()) {
                return new File(uri).toURI();
            }
            throw new IllegalArgumentException(use.getMessage(), use);
        }
    }
}

