/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.javadoc;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import nl.talsmasoftware.umldoclet.javadoc.TypeNameVisitor;
import nl.talsmasoftware.umldoclet.uml.TypeName;

final class TypeNameWithCardinality {
    final TypeName typeName;
    final String cardinality;

    private TypeNameWithCardinality(TypeName typeName, String cardinality) {
        this.typeName = typeName;
        this.cardinality = cardinality;
    }

    static Function<TypeMirror, TypeNameWithCardinality> function(Types typeUtils) {
        Objects.requireNonNull(typeUtils, "Type utils are <null>.");
        return type -> {
            if (type instanceof ArrayType) {
                TypeName componentName = (TypeName)TypeNameVisitor.INSTANCE.visit(((ArrayType)type).getComponentType());
                return new TypeNameWithCardinality(componentName, "*");
            }
            if (type instanceof DeclaredType) {
                ArrayDeque<TypeMirror> superTypes = new ArrayDeque<TypeMirror>(Collections.singleton(type));
                HashSet<String> checkedTypes = new HashSet<String>();
                while (!superTypes.isEmpty()) {
                    Optional<TypeName> typeArgument;
                    TypeMirror superType = (TypeMirror)superTypes.poll();
                    String qName = ((TypeName)TypeNameVisitor.INSTANCE.visit((TypeMirror)superType)).qualified;
                    if (!checkedTypes.add(qName)) continue;
                    String cardinality = null;
                    if ("java.util.Optional".equals(qName) || "com.google.common.base.Optional".equals(qName)) {
                        cardinality = "0..1";
                    } else if ("java.lang.Iterable".equals(qName) || "java.util.stream.Stream".equals(qName)) {
                        cardinality = "*";
                    }
                    if ((typeArgument = Optional.ofNullable(cardinality).map(c -> superType instanceof DeclaredType ? (DeclaredType)superType : null).map(DeclaredType::getTypeArguments).map(args -> args.size() == 1 ? (TypeMirror)args.get(0) : null).map(TypeNameVisitor.INSTANCE::visit)).isPresent()) {
                        return new TypeNameWithCardinality(typeArgument.get(), cardinality);
                    }
                    superTypes.addAll(typeUtils.directSupertypes(superType));
                }
            }
            return new TypeNameWithCardinality((TypeName)TypeNameVisitor.INSTANCE.visit((TypeMirror)type), null);
        };
    }
}

