/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.rendering.indent;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public final class Indentation
implements CharSequence,
Serializable {
    private static final Indentation[] TWO_SPACES;
    private static final Indentation[] FOUR_SPACES;
    private static final Indentation[] TABS;
    public static final Indentation DEFAULT;
    public static final Indentation NONE;
    private final int width;
    private final int level;
    private final char ch;
    private final transient String value;

    private Indentation(int width, char ch, int level) {
        this.width = Math.max(width, 0);
        this.level = Math.max(level, 0);
        this.ch = ch;
        char[] buf = new char[this.width * this.level];
        Arrays.fill(buf, this.ch);
        this.value = String.valueOf(buf);
    }

    public static Indentation tabs(int level) {
        return level < TABS.length ? TABS[Math.max(level, 0)] : new Indentation(1, '\t', level);
    }

    public static Indentation spaces(int width, int level) {
        return width < 0 ? Indentation.spaces(Indentation.DEFAULT.ch == ' ' ? Indentation.DEFAULT.width : 4, level) : (width == 0 ? NONE : (width == 2 && level < TWO_SPACES.length ? TWO_SPACES[Math.max(level, 0)] : (width == 4 && level < FOUR_SPACES.length ? FOUR_SPACES[Math.max(level, 0)] : new Indentation(width, ' ', level))));
    }

    private static Indentation resolve(int width, char ch, int level) {
        return width == 0 ? NONE : (ch == ' ' ? Indentation.spaces(width, level) : (ch == '\t' && width == 1 ? Indentation.tabs(level) : new Indentation(width, ch, level)));
    }

    public Indentation increase() {
        return Indentation.resolve(this.width, this.ch, this.level + 1);
    }

    public Indentation decrease() {
        return this.level == 0 ? this : Indentation.resolve(this.width, this.ch, this.level - 1);
    }

    private Object readResolve() {
        return Indentation.resolve(this.width, this.ch, this.level);
    }

    public int hashCode() {
        return Objects.hash(this.width, Character.valueOf(this.ch), this.level);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Indentation && this.width == ((Indentation)other).width && this.ch == ((Indentation)other).ch && this.level == ((Indentation)other).level;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.substring(start, end);
    }

    @Override
    public String toString() {
        return this.value;
    }

    static {
        int lvl;
        TWO_SPACES = new Indentation[5];
        FOUR_SPACES = new Indentation[5];
        TABS = new Indentation[5];
        for (lvl = 0; lvl < TWO_SPACES.length; ++lvl) {
            Indentation.TWO_SPACES[lvl] = new Indentation(2, ' ', lvl);
        }
        for (lvl = 0; lvl < FOUR_SPACES.length; ++lvl) {
            Indentation.FOUR_SPACES[lvl] = new Indentation(4, ' ', lvl);
        }
        for (lvl = 0; lvl < TABS.length; ++lvl) {
            Indentation.TABS[lvl] = new Indentation(1, '\t', lvl);
        }
        DEFAULT = FOUR_SPACES[0];
        NONE = new Indentation(0, ' ', 0);
    }
}

